/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.CapabilityReferenceRecorder;
import org.jboss.as.controller.DeprecationData;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceBuilder;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.RestartParentResourceAddHandler;
import org.jboss.as.controller.RestartParentResourceRemoveHandler;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.capability.Capability;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.RuntimePackageDependency;

class ResourceBuilderRoot
implements ResourceBuilder {
    private final PathElement pathElement;
    private final StandardResourceDescriptionResolver resourceResolver;
    private final List<AttributeBinding> attributes = new LinkedList<AttributeBinding>();
    private final List<OperationBinding> operations = new LinkedList<OperationBinding>();
    private final List<Capability> capabilities = new LinkedList<Capability>();
    private ResourceDescriptionResolver attributeResolver = null;
    private OperationStepHandler addHandler;
    private OperationStepHandler removeHandler;
    private DeprecationData deprecationData;
    private final List<ResourceBuilderRoot> children = new LinkedList<ResourceBuilderRoot>();
    private final ResourceBuilderRoot parent;
    private boolean isRuntime = false;
    private Set<RuntimeCapability> incorporatingCapabilities;
    private Set<CapabilityReferenceRecorder> requirements;
    private boolean isFeature = true;
    private final List<RuntimePackageDependency> additionalPackages = new LinkedList<RuntimePackageDependency>();

    private ResourceBuilderRoot(PathElement pathElement, StandardResourceDescriptionResolver resourceResolver, OperationStepHandler addHandler, OperationStepHandler removeHandler, ResourceBuilderRoot parent) {
        this.pathElement = pathElement;
        this.resourceResolver = resourceResolver;
        this.parent = parent;
        this.addHandler = addHandler;
        this.removeHandler = removeHandler;
    }

    private ResourceBuilderRoot(ResourceBuilderRoot toCopy, ResourceBuilderRoot parent) {
        this(toCopy.pathElement, toCopy.resourceResolver, toCopy.addHandler, toCopy.removeHandler, parent);
        this.attributes.addAll(toCopy.attributes);
        this.operations.addAll(toCopy.operations);
        this.capabilities.addAll(toCopy.capabilities);
        this.children.addAll(toCopy.children);
        if (toCopy.incorporatingCapabilities != null) {
            this.incorporatingCapabilities = new HashSet<RuntimeCapability>(toCopy.incorporatingCapabilities);
        }
        if (toCopy.requirements != null) {
            this.requirements = new HashSet<CapabilityReferenceRecorder>(toCopy.requirements);
        }
        this.addHandler = toCopy.addHandler;
        this.removeHandler = toCopy.removeHandler;
        this.deprecationData = toCopy.deprecationData;
        this.isRuntime = parent.isRuntime;
        this.isFeature = parent.isFeature;
        this.attributeResolver = toCopy.attributeResolver;
        this.additionalPackages.addAll(toCopy.additionalPackages);
    }

    static ResourceBuilder create(PathElement pathElement, StandardResourceDescriptionResolver resourceDescriptionResolver) {
        return new ResourceBuilderRoot(pathElement, resourceDescriptionResolver, null, null, null);
    }

    static ResourceBuilder create(PathElement pathElement, StandardResourceDescriptionResolver resourceResolver, OperationStepHandler addHandler, OperationStepHandler removeHandler) {
        return new ResourceBuilderRoot(pathElement, resourceResolver, addHandler, removeHandler, null);
    }

    @Override
    public ResourceBuilder setAddOperation(AbstractAddStepHandler handler) {
        this.addHandler = handler;
        return this;
    }

    @Override
    public ResourceBuilder setRemoveOperation(AbstractRemoveStepHandler handler) {
        this.removeHandler = handler;
        return this;
    }

    @Override
    public ResourceBuilder setAddOperation(RestartParentResourceAddHandler handler) {
        this.addHandler = handler;
        return this;
    }

    @Override
    public ResourceBuilder setRemoveOperation(RestartParentResourceRemoveHandler handler) {
        this.removeHandler = handler;
        return this;
    }

    @Override
    public ResourceBuilder addReadWriteAttribute(AttributeDefinition attributeDefinition, OperationStepHandler reader, OperationStepHandler writer) {
        this.attributes.add(new AttributeBinding(attributeDefinition, reader, writer, AttributeAccess.AccessType.READ_WRITE));
        return this;
    }

    @Override
    public ResourceBuilder addReadWriteAttributes(OperationStepHandler reader, OperationStepHandler writer, AttributeDefinition ... attributes) {
        for (AttributeDefinition ad : attributes) {
            this.attributes.add(new AttributeBinding(ad, reader, writer, AttributeAccess.AccessType.READ_WRITE));
        }
        return this;
    }

    @Override
    public ResourceBuilder addReadOnlyAttribute(AttributeDefinition attributeDefinition) {
        this.attributes.add(new AttributeBinding(attributeDefinition, null, null, AttributeAccess.AccessType.READ_ONLY));
        return this;
    }

    @Override
    public ResourceBuilder addMetric(AttributeDefinition attributeDefinition, OperationStepHandler handler) {
        this.attributes.add(new AttributeBinding(attributeDefinition, handler, null, AttributeAccess.AccessType.METRIC));
        return this;
    }

    @Override
    public ResourceBuilder addMetrics(OperationStepHandler metricHandler, AttributeDefinition ... attributes) {
        for (AttributeDefinition ad : attributes) {
            this.attributes.add(new AttributeBinding(ad, metricHandler, null, AttributeAccess.AccessType.METRIC));
        }
        return this;
    }

    @Override
    public ResourceBuilder setAttributeResolver(ResourceDescriptionResolver resolver) {
        this.attributeResolver = resolver;
        return this;
    }

    @Override
    public ResourceBuilder addOperation(OperationDefinition operationDefinition, OperationStepHandler handler) {
        return this.addOperation(operationDefinition, handler, false);
    }

    @Override
    public ResourceBuilder addOperation(OperationDefinition operationDefinition, OperationStepHandler handler, boolean inherited) {
        this.operations.add(new OperationBinding(operationDefinition, handler, inherited));
        return this;
    }

    @Override
    public ResourceBuilder deprecated(ModelVersion since) {
        this.deprecationData = new DeprecationData(since);
        return this;
    }

    @Override
    public ResourceBuilder setRuntime() {
        this.isRuntime = true;
        return this;
    }

    @Override
    public ResourceBuilder noFeature() {
        this.isFeature = false;
        return this;
    }

    @Override
    public ResourceBuilder addCapability(Capability capability) {
        this.capabilities.add(capability);
        return this;
    }

    @Override
    public ResourceBuilder addCapabilities(Capability ... capabilities) {
        this.capabilities.addAll(Arrays.asList(capabilities));
        return this;
    }

    @Override
    public ResourceBuilder setIncorporatingCapabilities(Set<RuntimeCapability> incorporating) {
        this.incorporatingCapabilities = incorporating;
        return this;
    }

    @Override
    public ResourceBuilder setRequirements(Set<CapabilityReferenceRecorder> requirements) {
        this.requirements = requirements;
        return this;
    }

    @Override
    public ResourceBuilder pushChild(PathElement pathElement) {
        return this.pushChild(pathElement, this.resourceResolver.getChildResolver(pathElement.getKey()));
    }

    @Override
    public ResourceBuilder pushChild(PathElement pathElement, OperationStepHandler addHandler, OperationStepHandler removeHandler) {
        return this.pushChild(pathElement, this.resourceResolver.getChildResolver(pathElement.getKey()), addHandler, removeHandler);
    }

    @Override
    public ResourceBuilder pushChild(PathElement pathElement, StandardResourceDescriptionResolver resolver) {
        return this.pushChild(pathElement, resolver, null, null);
    }

    @Override
    public ResourceBuilder pushChild(PathElement pathElement, StandardResourceDescriptionResolver resolver, OperationStepHandler addHandler, OperationStepHandler removeHandler) {
        ResourceBuilderRoot child = new ResourceBuilderRoot(pathElement, resolver, addHandler, removeHandler, this);
        this.children.add(child);
        return child;
    }

    @Override
    public ResourceBuilder pushChild(ResourceBuilder child) {
        ResourceBuilderRoot childDelegate = new ResourceBuilderRoot((ResourceBuilderRoot)child, this);
        this.children.add(childDelegate);
        return childDelegate;
    }

    @Override
    public ResourceBuilder pop() {
        if (this.parent == null) {
            return this;
        }
        return this.parent;
    }

    @Override
    public ResourceBuilder addAdditionalRuntimePackages(RuntimePackageDependency ... additionalPackages) {
        this.additionalPackages.addAll(Arrays.asList(additionalPackages));
        return this;
    }

    @Override
    public ResourceDefinition build() {
        if (this.parent != null) {
            return this.parent.build();
        }
        return new BuilderResourceDefinition(this);
    }

    List<AttributeBinding> getAttributes() {
        return this.attributes;
    }

    List<OperationBinding> getOperations() {
        return this.operations;
    }

    List<ResourceBuilderRoot> getChildren() {
        return this.children;
    }

    private static final class OperationBinding {
        private OperationDefinition definition;
        private OperationStepHandler handler;
        private boolean inherited;

        OperationBinding(OperationDefinition definition, OperationStepHandler handler, boolean inherited) {
            this.definition = definition;
            this.handler = handler;
            this.inherited = inherited;
        }

        public void register(ManagementResourceRegistration registration) {
            registration.registerOperationHandler(this.definition, this.handler, this.inherited);
        }
    }

    private static final class AttributeBinding {
        private final AttributeDefinition attribute;
        private final OperationStepHandler readOp;
        private final OperationStepHandler writeOp;
        private final AttributeAccess.AccessType accessType;

        AttributeBinding(AttributeDefinition attribute, OperationStepHandler readOp, OperationStepHandler writeOp, AttributeAccess.AccessType accessType) {
            this.attribute = attribute;
            this.readOp = readOp;
            this.writeOp = writeOp;
            this.accessType = accessType;
        }

        void register(ManagementResourceRegistration registration) {
            if (this.accessType == AttributeAccess.AccessType.READ_ONLY) {
                registration.registerReadOnlyAttribute(this.attribute, this.readOp);
            } else if (this.accessType == AttributeAccess.AccessType.READ_WRITE) {
                registration.registerReadWriteAttribute(this.attribute, this.readOp, this.writeOp);
            } else if (this.accessType == AttributeAccess.AccessType.METRIC) {
                registration.registerMetric(this.attribute, this.readOp);
            }
        }
    }

    private static class BuilderResourceDefinition
    extends SimpleResourceDefinition {
        final ResourceBuilderRoot builder;

        private BuilderResourceDefinition(ResourceBuilderRoot builder) {
            super(new SimpleResourceDefinition.Parameters(builder.pathElement, builder.resourceResolver).setAddHandler(builder.addHandler).setRemoveHandler(builder.removeHandler).setDeprecationData(builder.deprecationData).setRuntime(builder.isRuntime).setCapabilities(builder.capabilities.toArray(new RuntimeCapability[builder.capabilities.size()])).setAdditionalPackages(builder.additionalPackages.toArray(new RuntimePackageDependency[builder.additionalPackages.size()])).setIncorporatingCapabilities(builder.incorporatingCapabilities).setFeature(builder.isFeature));
            this.builder = builder;
        }

        @Override
        public void registerOperations(ManagementResourceRegistration resourceRegistration) {
            super.registerOperations(resourceRegistration);
            for (OperationBinding ob : this.builder.operations) {
                ob.register(resourceRegistration);
            }
        }

        @Override
        public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
            super.registerAttributes(resourceRegistration);
            for (AttributeBinding ab : this.builder.attributes) {
                ab.register(resourceRegistration);
            }
        }

        @Override
        public void registerChildren(ManagementResourceRegistration resourceRegistration) {
            super.registerChildren(resourceRegistration);
            for (ResourceBuilderRoot child : this.builder.children) {
                resourceRegistration.registerSubModel(new BuilderResourceDefinition(child));
            }
        }
    }
}

