/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.impl.SingleSignOnManager;
import io.undertow.servlet.handlers.security.ServletSingleSignOnAuthenticationMechanism;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.wildfly.extension.undertow.Host;

public class SingleSignOnService
implements Service<SingleSignOnService> {
    public static final String AUTHENTICATION_MECHANISM_NAME = "SSO";
    private final String domain;
    private final String path;
    private final String cookieName;
    private final boolean httpOnly;
    private final boolean secure;
    private final Consumer<SingleSignOnService> serviceConsumer;
    private final Supplier<Host> host;
    private final Supplier<SingleSignOnManager> manager;

    SingleSignOnService(Consumer<SingleSignOnService> serviceConsumer, Supplier<Host> host, Supplier<SingleSignOnManager> manager, String domain, String path, boolean httpOnly, boolean secure, String cookieName) {
        this.serviceConsumer = serviceConsumer;
        this.host = host;
        this.manager = manager;
        this.domain = domain;
        this.path = path;
        this.httpOnly = httpOnly;
        this.secure = secure;
        this.cookieName = cookieName;
    }

    public void start(StartContext startContext) {
        ServletSingleSignOnAuthenticationMechanism mechanism = new ServletSingleSignOnAuthenticationMechanism(this.manager.get());
        mechanism.setDomain(this.domain);
        mechanism.setPath(this.path);
        mechanism.setHttpOnly(this.httpOnly);
        mechanism.setSecure(this.secure);
        mechanism.setCookieName(this.cookieName);
        this.host.get().registerAdditionalAuthenticationMechanism(AUTHENTICATION_MECHANISM_NAME, (AuthenticationMechanism)mechanism);
        this.serviceConsumer.accept(this);
    }

    public void stop(StopContext stopContext) {
        this.serviceConsumer.accept(null);
        this.host.get().unregisterAdditionalAuthenticationMechanism(AUTHENTICATION_MECHANISM_NAME);
    }

    public SingleSignOnService getValue() {
        return this;
    }
}

