/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.channel;

import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.Channel;
import java.util.AbstractMap;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.apache.sshd.client.channel.ClientChannel;
import org.apache.sshd.client.channel.ClientChannelHolder;
import org.apache.sshd.client.future.DefaultOpenFuture;
import org.apache.sshd.client.future.OpenFuture;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;

public class ClientChannelPendingMessagesQueue
extends AbstractLoggingBean
implements SshFutureListener<OpenFuture>,
Channel,
ClientChannelHolder {
    protected final Deque<Map.Entry<Buffer, Consumer<? super Throwable>>> pendingQueue = new LinkedList<Map.Entry<Buffer, Consumer<? super Throwable>>>();
    protected final DefaultOpenFuture completedFuture;
    private final ClientChannel clientChannel;
    private final AtomicBoolean open = new AtomicBoolean(true);

    public ClientChannelPendingMessagesQueue(ClientChannel channel) {
        this.clientChannel = Objects.requireNonNull(channel, "No channel provided");
        this.completedFuture = new DefaultOpenFuture(this.getClass().getSimpleName() + "[" + channel + "]", null);
    }

    @Override
    public ClientChannel getClientChannel() {
        return this.clientChannel;
    }

    public OpenFuture getCompletedFuture() {
        return this.completedFuture;
    }

    @Override
    public boolean isOpen() {
        return this.open.get();
    }

    @Override
    public void close() throws IOException {
        this.markClosed();
        int numPending = this.clearPendingQueue();
        if (this.log.isDebugEnabled()) {
            this.log.debug("close({}) cleared {} pending messages", (Object)this, (Object)numPending);
        }
    }

    protected boolean markClosed() {
        OpenFuture f = this.getCompletedFuture();
        if (!f.isDone()) {
            f.setException(new CancellationException("Cancelled"));
        }
        return this.open.getAndSet(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int handleIncomingMessage(Buffer buffer, Consumer<? super Throwable> errHandler) throws IOException {
        if (!this.isOpen()) {
            throw new EOFException("Queue is closed");
        }
        Objects.requireNonNull(buffer, "No message to enqueue");
        OpenFuture future = this.getCompletedFuture();
        Deque<Map.Entry<Buffer, Consumer<? super Throwable>>> deque = this.pendingQueue;
        synchronized (deque) {
            boolean enqueue;
            boolean bl = enqueue = !future.isDone();
            if (enqueue) {
                Objects.requireNonNull(errHandler, "No pending message error handler provided");
            }
            if (enqueue) {
                this.pendingQueue.add(new AbstractMap.SimpleImmutableEntry<Buffer, Consumer<? super Throwable>>(buffer, errHandler));
                this.pendingQueue.notifyAll();
            } else {
                this.writeMessage(buffer, errHandler);
            }
            return this.pendingQueue.size();
        }
    }

    protected void writeMessage(Buffer buffer, Consumer<? super IOException> errHandler) throws IOException {
        ClientChannel channel = this.getClientChannel();
        try {
            if (!this.isOpen()) {
                throw new EOFException("Queue is marked as closed");
            }
            if (!channel.isOpen()) {
                throw new EOFException("Client channel is closed/closing");
            }
            Object session = channel.getSession();
            if (!session.isOpen()) {
                throw new EOFException("Client session is closed/closing");
            }
            OutputStream outputStream = channel.getInvertedIn();
            outputStream.write(buffer.array(), buffer.rpos(), buffer.available());
            outputStream.flush();
        }
        catch (IOException e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("writeMessage({}) failed ({}) to output message: {}", new Object[]{this, e.getClass().getSimpleName(), e.getMessage()});
            }
            if (errHandler != null) {
                errHandler.accept(e);
            }
            this.markCompletionException(e);
            throw e;
        }
    }

    public void operationComplete(OpenFuture future) {
        Throwable err = future.getException();
        if (err != null) {
            this.markCompletionException(err);
            if (this.markClosed()) {
                this.log.warn("operationComplete({}) {}[{}] signaled", new Object[]{this, err.getClass().getSimpleName(), err.getMessage()});
            } else {
                this.log.warn("operationComplete({}) got {}[{}] signal while queue is closed", new Object[]{this, err.getClass().getSimpleName(), err.getMessage()});
            }
            this.clearPendingQueue();
        } else {
            this.flushPendingQueue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flushPendingQueue() {
        int numSent = 0;
        try {
            boolean debugEnabled = this.log.isDebugEnabled();
            if (debugEnabled) {
                this.log.debug("flushPendingQueue({}) start sending pending messages", (Object)this);
            }
            Deque<Map.Entry<Buffer, Consumer<? super Throwable>>> deque = this.pendingQueue;
            synchronized (deque) {
                while (!this.pendingQueue.isEmpty()) {
                    Map.Entry<Buffer, Consumer<? super Throwable>> msgEntry = this.pendingQueue.removeFirst();
                    this.writeMessage(msgEntry.getKey(), msgEntry.getValue());
                    ++numSent;
                }
                this.markCompletionSuccessful();
            }
            if (debugEnabled) {
                this.log.debug("flushPendingQueue({}) sent {} pending messages", (Object)this, (Object)numSent);
            }
        }
        catch (IOException e) {
            this.markCompletionException(e);
            boolean closed = this.markClosed();
            int numPending = this.clearPendingQueue();
            this.log.warn("flushPendingQueue({}) Failed ({}) after {} successfully sent messages (pending={}, markClosed={}): {}", new Object[]{this, e.getClass().getSimpleName(), numSent, numPending, closed, e.getMessage()});
        }
    }

    protected OpenFuture markCompletionSuccessful() {
        OpenFuture f = this.getCompletedFuture();
        f.setOpened();
        return f;
    }

    protected OpenFuture markCompletionException(Throwable err) {
        OpenFuture f = this.getCompletedFuture();
        f.setException(err);
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int clearPendingQueue() {
        int numEntries;
        Deque<Map.Entry<Buffer, Consumer<? super Throwable>>> deque = this.pendingQueue;
        synchronized (deque) {
            numEntries = this.pendingQueue.size();
            if (numEntries > 0) {
                this.pendingQueue.clear();
            }
            this.pendingQueue.notifyAll();
        }
        return numEntries;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[channel=" + this.getClientChannel() + ", open=" + this.isOpen() + "]";
    }
}

