/*
 * Decompiled with CFR 0.152.
 */
package javax.sql.rowset;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import javax.sql.rowset.RowSetFactory;

public class RowSetProvider {
    private static final String ROWSET_DEBUG_PROPERTY = "javax.sql.rowset.RowSetProvider.debug";
    private static final String ROWSET_FACTORY_IMPL = "com.sun.rowset.RowSetFactoryImpl";
    private static final String ROWSET_FACTORY_NAME = "javax.sql.rowset.RowSetFactory";
    private static boolean debug = true;

    protected RowSetProvider() {
    }

    public static RowSetFactory newFactory() throws SQLException {
        RowSetFactory factory = null;
        String factoryClassName = null;
        try {
            RowSetProvider.trace("Checking for Rowset System Property...");
            factoryClassName = RowSetProvider.getSystemProperty(ROWSET_FACTORY_NAME);
            if (factoryClassName != null) {
                RowSetProvider.trace("Found system property, value=" + factoryClassName);
                factory = (RowSetFactory)RowSetProvider.getFactoryClass(factoryClassName, null, true).newInstance();
            }
        }
        catch (ClassNotFoundException e) {
            throw new SQLException("RowSetFactory: " + factoryClassName + " not found", e);
        }
        catch (Exception e) {
            throw new SQLException("RowSetFactory: " + factoryClassName + " could not be instantiated: " + e, e);
        }
        if (factory == null) {
            factory = RowSetProvider.loadViaServiceLoader();
            factory = factory == null ? RowSetProvider.newFactory(ROWSET_FACTORY_IMPL, null) : factory;
        }
        return factory;
    }

    public static RowSetFactory newFactory(String factoryClassName, ClassLoader cl) throws SQLException {
        RowSetProvider.trace("***In newInstance()");
        try {
            Class providerClass = RowSetProvider.getFactoryClass(factoryClassName, cl, false);
            RowSetFactory instance = (RowSetFactory)providerClass.newInstance();
            if (debug) {
                RowSetProvider.trace("Created new instance of " + providerClass + " using ClassLoader: " + cl);
            }
            return instance;
        }
        catch (ClassNotFoundException x) {
            throw new SQLException("Provider " + factoryClassName + " not found", x);
        }
        catch (Exception x) {
            throw new SQLException("Provider " + factoryClassName + " could not be instantiated: " + x, x);
        }
    }

    private static ClassLoader getContextClassLoader() throws SecurityException {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                ClassLoader cl = null;
                cl = Thread.currentThread().getContextClassLoader();
                if (cl == null) {
                    cl = ClassLoader.getSystemClassLoader();
                }
                return cl;
            }
        });
    }

    private static Class getFactoryClass(String factoryClassName, ClassLoader cl, boolean doFallback) throws ClassNotFoundException {
        try {
            if (cl == null) {
                cl = RowSetProvider.getContextClassLoader();
                if (cl == null) {
                    throw new ClassNotFoundException();
                }
                return cl.loadClass(factoryClassName);
            }
            return cl.loadClass(factoryClassName);
        }
        catch (ClassNotFoundException e) {
            if (doFallback) {
                return Class.forName(factoryClassName, true, RowSetFactory.class.getClassLoader());
            }
            throw e;
        }
    }

    private static RowSetFactory loadViaServiceLoader() throws SQLException {
        RowSetFactory theFactory = null;
        try {
            RowSetProvider.trace("***in loadViaServiceLoader():");
            Iterator<RowSetFactory> i$ = ServiceLoader.load(RowSetFactory.class).iterator();
            if (i$.hasNext()) {
                RowSetFactory factory = i$.next();
                RowSetProvider.trace(" Loading done by the java.util.ServiceLoader :" + factory.getClass().getName());
                theFactory = factory;
            }
        }
        catch (ServiceConfigurationError e) {
            throw new SQLException("RowSetFactory: Error locating RowSetFactory using Service Loader API: " + e, e);
        }
        return theFactory;
    }

    private static String getSystemProperty(final String propName) {
        String property;
        block2: {
            property = null;
            try {
                property = AccessController.doPrivileged(new PrivilegedAction<String>(){

                    @Override
                    public String run() {
                        return System.getProperty(propName);
                    }
                });
            }
            catch (SecurityException se) {
                if (!debug) break block2;
                se.printStackTrace();
            }
        }
        return property;
    }

    private static void trace(String msg) {
        if (debug) {
            System.err.println("###RowSets: " + msg);
        }
    }

    static {
        String val = RowSetProvider.getSystemProperty(ROWSET_DEBUG_PROPERTY);
        debug = val != null && !"false".equals(val);
    }
}

