/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jmx;

import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.jmx.JMXSubsystemAdd;
import org.jboss.as.jmx.RemotingConnectorResource;
import org.jboss.as.jmx.RemotingConnectorService;
import org.jboss.dmr.ModelNode;

class RemotingConnectorAdd
extends AbstractAddStepHandler {
    static final RemotingConnectorAdd INSTANCE = new RemotingConnectorAdd();

    private RemotingConnectorAdd() {
        super(new AttributeDefinition[]{RemotingConnectorResource.USE_MANAGEMENT_ENDPOINT});
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        boolean useManagementEndpoint = RemotingConnectorResource.USE_MANAGEMENT_ENDPOINT.resolveModelAttribute(context, model).asBoolean();
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        PathAddress parentAddress = address.subAddress(0, address.size() - 1);
        ModelNode jmxSubsystemModel = Resource.Tools.readModel((Resource)context.readResourceFromRoot(parentAddress, true));
        String resolvedDomain = JMXSubsystemAdd.getDomainName(context, jmxSubsystemModel, "resolved");
        String expressionsDomain = JMXSubsystemAdd.getDomainName(context, jmxSubsystemModel, "expression");
        RemotingConnectorService.addService(context.getServiceTarget(), useManagementEndpoint, resolvedDomain, expressionsDomain);
    }
}

