/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.host.controller.DomainModelControllerService;
import org.jboss.as.host.controller.HostControllerEnvironment;
import org.jboss.as.host.controller.HostPathManagerService;
import org.jboss.as.host.controller.HostRunningModeControl;
import org.jboss.as.host.controller.ProcessControllerConnectionService;
import org.jboss.as.remoting.HttpListenerRegistryService;
import org.jboss.as.remoting.management.ManagementRemotingServices;
import org.jboss.as.server.BootstrapListener;
import org.jboss.as.server.FutureServiceContainer;
import org.jboss.as.server.Services;
import org.jboss.as.server.deployment.ContentCleanerService;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.as.version.ProductConfig;
import org.jboss.modules.Module;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;
import org.jboss.threads.AsyncFuture;
import org.jboss.threads.JBossThreadFactory;
import org.wildfly.security.manager.action.GetAccessControlContextAction;

public class HostControllerService
implements Service<AsyncFuture<ServiceContainer>> {
    public static final ServiceName HC_SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"host", "controller"});
    public static final ServiceName HC_EXECUTOR_SERVICE_NAME = HC_SERVICE_NAME.append(new String[]{"executor"});
    public static final ServiceName HC_SCHEDULED_EXECUTOR_SERVICE_NAME = HC_SERVICE_NAME.append(new String[]{"scheduled", "executor"});
    private final ThreadFactory threadFactory = new JBossThreadFactory(new ThreadGroup("Host Controller Service Threads"), Boolean.FALSE, null, "%G - %t", null, null, (AccessControlContext)AccessController.doPrivileged(GetAccessControlContextAction.getInstance()));
    private final HostControllerEnvironment environment;
    private final HostRunningModeControl runningModeControl;
    private final ControlledProcessState processState;
    private final byte[] authCode;
    private volatile FutureServiceContainer futureContainer;
    private volatile long startTime;

    HostControllerService(HostControllerEnvironment environment, HostRunningModeControl runningModeControl, byte[] authCode, ControlledProcessState processState) {
        this.environment = environment;
        this.runningModeControl = runningModeControl;
        this.authCode = authCode;
        this.processState = processState;
        this.startTime = Module.getStartTime();
    }

    public void start(StartContext context) throws StartException {
        this.processState.setStarting();
        ProductConfig config = this.environment.getProductConfig();
        String prettyVersion = config.getPrettyVersionString();
        ServerLogger.AS_ROOT_LOGGER.serverStarting(prettyVersion);
        if (ServerLogger.CONFIG_LOGGER.isDebugEnabled()) {
            Properties properties = System.getProperties();
            StringBuilder b = new StringBuilder(8192);
            b.append("Configured system properties:");
            for (String property : new TreeSet<String>(properties.stringPropertyNames())) {
                String propVal = property.toLowerCase(Locale.getDefault()).contains("password") ? "<redacted>" : properties.getProperty(property, "<undefined>");
                b.append("\n\t").append(property).append(" = ").append(propVal);
            }
            ServerLogger.CONFIG_LOGGER.debug((Object)b);
            ServerLogger.CONFIG_LOGGER.debugf("VM Arguments: %s", (Object)this.getVMArguments());
            if (ServerLogger.CONFIG_LOGGER.isTraceEnabled()) {
                b.setLength(0);
                Map<String, String> env = System.getenv();
                b.append("Configured system environment:");
                for (String key : new TreeSet<String>(env.keySet())) {
                    String envVal = key.toLowerCase(Locale.getDefault()).contains("password") ? "<redacted>" : env.get(key);
                    b.append("\n\t").append(key).append(" = ").append(envVal);
                }
                ServerLogger.CONFIG_LOGGER.trace((Object)b);
            }
        }
        ServiceTarget serviceTarget = context.getChildTarget();
        ServiceController myController = context.getController();
        ServiceContainer serviceContainer = myController.getServiceContainer();
        this.futureContainer = new FutureServiceContainer();
        long startTime = this.startTime;
        if (startTime == -1L) {
            startTime = System.currentTimeMillis();
        } else {
            this.startTime = -1L;
        }
        BootstrapListener bootstrapListener = new BootstrapListener(serviceContainer, startTime, serviceTarget, this.futureContainer, prettyVersion + " (Host Controller)");
        bootstrapListener.getStabilityMonitor().addController(myController);
        ProcessControllerConnectionService processControllerClient = new ProcessControllerConnectionService(this.environment, this.authCode);
        serviceTarget.addService(ProcessControllerConnectionService.SERVICE_NAME, (Service)processControllerClient).install();
        HostControllerExecutorService executorService = new HostControllerExecutorService(this.threadFactory);
        serviceTarget.addService(HC_EXECUTOR_SERVICE_NAME, (Service)executorService).addAliases(new ServiceName[]{ManagementRemotingServices.SHUTDOWN_EXECUTOR_NAME}).install();
        HostControllerScheduledExecutorService scheduledExecutorService = new HostControllerScheduledExecutorService(this.threadFactory);
        serviceTarget.addService(HC_SCHEDULED_EXECUTOR_SERVICE_NAME, (Service)scheduledExecutorService).addDependency(HC_EXECUTOR_SERVICE_NAME, ExecutorService.class, (Injector)scheduledExecutorService.executorInjector).install();
        HostPathManagerService hostPathManagerService = new HostPathManagerService();
        HostPathManagerService.addService(serviceTarget, hostPathManagerService, this.environment);
        HttpListenerRegistryService.install((ServiceTarget)serviceTarget);
        ImmediateValue productConfigValue = new ImmediateValue((Object)config);
        serviceTarget.addService(Services.JBOSS_PRODUCT_CONFIG_SERVICE, (Service)new ValueService((Value)productConfigValue)).setInitialMode(ServiceController.Mode.ACTIVE).install();
        DomainModelControllerService.addService(serviceTarget, this.environment, this.runningModeControl, this.processState, bootstrapListener, hostPathManagerService);
        ContentCleanerService.addServiceOnHostController((ServiceTarget)serviceTarget, (ServiceName)DomainModelControllerService.SERVICE_NAME, (ServiceName)HC_EXECUTOR_SERVICE_NAME, (ServiceName)HC_SCHEDULED_EXECUTOR_SERVICE_NAME);
    }

    public void stop(StopContext context) {
        String prettyVersion = this.environment.getProductConfig().getPrettyVersionString();
        this.processState.setStopping();
        ServerLogger.AS_ROOT_LOGGER.serverStopped(prettyVersion, Integer.valueOf((int)(context.getElapsedTime() / 1000000L)).intValue());
    }

    public AsyncFuture<ServiceContainer> getValue() throws IllegalStateException, IllegalArgumentException {
        return this.futureContainer;
    }

    public HostControllerEnvironment getEnvironment() {
        return this.environment;
    }

    private String getVMArguments() {
        StringBuilder result = new StringBuilder(1024);
        RuntimeMXBean rmBean = ManagementFactory.getRuntimeMXBean();
        List<String> inputArguments = rmBean.getInputArguments();
        for (String arg : inputArguments) {
            result.append(arg).append(" ");
        }
        return result.toString();
    }

    static final class HostControllerScheduledExecutorService
    implements Service<ScheduledExecutorService> {
        private final ThreadFactory threadFactory;
        private ScheduledThreadPoolExecutor scheduledExecutorService;
        private final InjectedValue<ExecutorService> executorInjector = new InjectedValue();

        private HostControllerScheduledExecutorService(ThreadFactory threadFactory) {
            this.threadFactory = threadFactory;
        }

        public synchronized void start(StartContext context) throws StartException {
            this.scheduledExecutorService = new ScheduledThreadPoolExecutor(4, this.threadFactory);
            this.scheduledExecutorService.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void stop(final StopContext context) {
            Runnable r = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        HostControllerScheduledExecutorService.this.scheduledExecutorService.shutdown();
                    }
                    finally {
                        HostControllerScheduledExecutorService.this.scheduledExecutorService = null;
                        context.complete();
                    }
                }
            };
            try {
                ((ExecutorService)this.executorInjector.getValue()).execute(r);
            }
            catch (RejectedExecutionException e) {
                r.run();
            }
            finally {
                context.asynchronous();
            }
        }

        public synchronized ScheduledExecutorService getValue() throws IllegalStateException {
            return this.scheduledExecutorService;
        }
    }

    static final class HostControllerExecutorService
    implements Service<ExecutorService> {
        final ThreadFactory threadFactory;
        private ExecutorService executorService;

        private HostControllerExecutorService(ThreadFactory threadFactory) {
            this.threadFactory = threadFactory;
        }

        public synchronized void start(StartContext context) throws StartException {
            this.executorService = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 5L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), this.threadFactory);
        }

        public synchronized void stop(final StopContext context) {
            Thread executorShutdown = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        HostControllerExecutorService.this.executorService.shutdown();
                    }
                    finally {
                        HostControllerExecutorService.this.executorService = null;
                        context.complete();
                    }
                }
            }, "HostController ExecutorService Shutdown Thread");
            executorShutdown.start();
            context.asynchronous();
        }

        public synchronized ExecutorService getValue() throws IllegalStateException {
            return this.executorService;
        }
    }
}

