/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.PlaceholderResource;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.registry.ResourceFilter;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.controller.services.path.PathResourceDefinition;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.as.logging.logging.LoggingLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public class LoggingResource
implements Resource {
    private static final List<String> FILE_RESOURCE_NAMES = Arrays.asList("file-handler", "periodic-rotating-file-handler", "periodic-size-rotating-file-handler", "size-rotating-file-handler");
    private final PathManager pathManager;
    private final Resource delegate;

    public LoggingResource(PathManager pathManager) {
        this(Resource.Factory.create(), pathManager);
    }

    public LoggingResource(Resource delegate, PathManager pathManager) {
        assert (pathManager != null) : "PathManager cannot be null";
        this.delegate = delegate;
        this.pathManager = pathManager;
    }

    public ModelNode getModel() {
        return this.delegate.getModel();
    }

    public void writeModel(ModelNode newModel) {
        this.delegate.writeModel(newModel);
    }

    public boolean isModelDefined() {
        return this.delegate.isModelDefined();
    }

    public boolean hasChild(PathElement element) {
        if ("log-file".equals(element.getKey())) {
            return this.hasReadableFile(element.getValue());
        }
        return this.delegate.hasChild(element);
    }

    public Resource getChild(PathElement element) {
        if ("log-file".equals(element.getKey())) {
            if (this.hasReadableFile(element.getValue())) {
                return PlaceholderResource.INSTANCE;
            }
            return null;
        }
        return this.delegate.getChild(element);
    }

    public Resource requireChild(PathElement element) {
        if ("log-file".equals(element.getKey())) {
            if (this.hasReadableFile(element.getValue())) {
                return PlaceholderResource.INSTANCE;
            }
            throw new Resource.NoSuchResourceException(element);
        }
        return this.delegate.requireChild(element);
    }

    public boolean hasChildren(String childType) {
        if ("log-file".equals(childType)) {
            return !this.getChildrenNames("log-file").isEmpty();
        }
        return this.delegate.hasChildren(childType);
    }

    public Resource navigate(PathAddress address) {
        if (address.size() > 0 && "log-file".equals(address.getElement(0).getKey())) {
            if (address.size() > 1) {
                throw new Resource.NoSuchResourceException(address.getElement(1));
            }
            return PlaceholderResource.INSTANCE;
        }
        return this.delegate.navigate(address);
    }

    public Set<String> getChildTypes() {
        LinkedHashSet<String> result = new LinkedHashSet<String>(this.delegate.getChildTypes());
        result.add("log-file");
        return result;
    }

    public Set<String> getChildrenNames(String childType) {
        if ("log-file".equals(childType)) {
            LinkedHashSet<String> result = new LinkedHashSet<String>();
            for (File file : LoggingResource.findFiles(this.pathManager.getPathEntry("jboss.server.log.dir").resolvePath(), Resource.Tools.readModel((Resource)this.delegate, (int)-1, (ResourceFilter)FileHandlerResourceFilter.INSTANCE))) {
                result.add(file.getName());
            }
            return result;
        }
        return this.delegate.getChildrenNames(childType);
    }

    public Set<Resource.ResourceEntry> getChildren(String childType) {
        if ("log-file".equals(childType)) {
            Set<String> names = this.getChildrenNames(childType);
            LinkedHashSet<Resource.ResourceEntry> result = new LinkedHashSet<Resource.ResourceEntry>(names.size());
            for (String name : names) {
                result.add((Resource.ResourceEntry)new PlaceholderResource.PlaceholderResourceEntry("log-file", name));
            }
            return result;
        }
        return this.delegate.getChildren(childType);
    }

    public void registerChild(PathElement address, Resource resource) {
        String type = address.getKey();
        if ("log-file".equals(type)) {
            throw LoggingLogger.ROOT_LOGGER.cannotRegisterResourceOfType(type);
        }
        this.delegate.registerChild(address, resource);
    }

    public Resource removeChild(PathElement address) {
        String type = address.getKey();
        if ("log-file".equals(type)) {
            throw LoggingLogger.ROOT_LOGGER.cannotRemoveResourceOfType(type);
        }
        return this.delegate.removeChild(address);
    }

    public boolean isRuntime() {
        return this.delegate.isRuntime();
    }

    public boolean isProxy() {
        return this.delegate.isProxy();
    }

    public Resource clone() {
        return new LoggingResource(this.delegate.clone(), this.pathManager);
    }

    private boolean hasReadableFile(String fileName) {
        return this.getChildrenNames("log-file").contains(fileName);
    }

    static List<File> findFiles(String logDir, ModelNode model) {
        List<File> result;
        if (logDir == null) {
            return Collections.emptyList();
        }
        File[] logFiles = new File(logDir).listFiles(AllowedFilesFilter.create(model));
        if (logFiles == null) {
            result = Collections.emptyList();
        } else {
            result = Arrays.asList(logFiles);
            Collections.sort(result);
        }
        return result;
    }

    private static class AllowedFilesFilter
    implements FileFilter {
        private final List<String> allowedNames;

        private AllowedFilesFilter(List<String> allowedNames) {
            this.allowedNames = allowedNames;
        }

        static AllowedFilesFilter create(ModelNode subsystemModel) {
            ArrayList<String> allowedNames = new ArrayList<String>();
            AllowedFilesFilter.findFileNames(subsystemModel, allowedNames);
            return new AllowedFilesFilter(allowedNames);
        }

        private static void findFileNames(ModelNode model, List<String> names) {
            for (Property resource : model.asPropertyList()) {
                String name = resource.getName();
                if (!FILE_RESOURCE_NAMES.contains(name)) continue;
                for (Property handlerResource : resource.getValue().asPropertyList()) {
                    ModelNode fileModel;
                    ModelNode handlerModel = handlerResource.getValue();
                    if (!handlerModel.hasDefined(CommonAttributes.FILE.getName()) || !(fileModel = handlerModel.get(CommonAttributes.FILE.getName())).hasDefined(PathResourceDefinition.PATH.getName())) continue;
                    names.add(fileModel.get(PathResourceDefinition.PATH.getName()).asString());
                }
            }
        }

        @Override
        public boolean accept(File pathname) {
            if (pathname.canRead()) {
                String name = pathname.getName();
                for (String allowedName : this.allowedNames) {
                    if (!name.equals(allowedName) && !name.startsWith(allowedName)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    private static class FileHandlerResourceFilter
    implements ResourceFilter {
        static final FileHandlerResourceFilter INSTANCE = new FileHandlerResourceFilter();

        private FileHandlerResourceFilter() {
        }

        public boolean accepts(PathAddress address, Resource resource) {
            PathElement last = address.getLastElement();
            return last == null || FILE_RESOURCE_NAMES.contains(last.getKey());
        }
    }
}

