/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.controller.transform.description.AttributeTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.DiscardAttributeChecker;
import org.jboss.as.controller.transform.description.RejectAttributeChecker;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.as.logging.ElementAttributeMarshaller;
import org.jboss.as.logging.KnownModelVersion;
import org.jboss.as.logging.LogFileResourceDefinition;
import org.jboss.as.logging.LoggingExtension;
import org.jboss.as.logging.LoggingResource;
import org.jboss.as.logging.LoggingSubsystemAdd;
import org.jboss.as.logging.TransformerResourceDefinition;
import org.jboss.as.logging.logging.LoggingLogger;
import org.jboss.as.logging.logmanager.WildFlyLogContextSelector;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;

public class LoggingResourceDefinition
extends TransformerResourceDefinition {
    static final PathElement SUBSYSTEM_PATH = PathElement.pathElement((String)"subsystem", (String)"logging");
    static final SimpleAttributeDefinition ADD_LOGGING_API_DEPENDENCIES = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"add-logging-api-dependencies", (ModelType)ModelType.BOOLEAN, (boolean)true).setAllowExpression(true)).setAttributeMarshaller((AttributeMarshaller)ElementAttributeMarshaller.VALUE_ATTRIBUTE_MARSHALLER)).setDefaultValue(new ModelNode(true))).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).build();
    static final SimpleAttributeDefinition USE_DEPLOYMENT_LOGGING_CONFIG = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"use-deployment-logging-config", (ModelType)ModelType.BOOLEAN, (boolean)true).setAllowExpression(true)).setAttributeMarshaller((AttributeMarshaller)ElementAttributeMarshaller.VALUE_ATTRIBUTE_MARSHALLER)).setDefaultValue(new ModelNode(true))).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).build();
    static final SimpleAttributeDefinition NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"name", (ModelType)ModelType.STRING, (boolean)false).setAllowExpression(true)).setValidator((ParameterValidator)new StringLengthValidator(1, false))).build();
    static final SimpleAttributeDefinition LINES = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"lines", (ModelType)ModelType.INT, (boolean)true).setAllowExpression(true)).setDefaultValue(new ModelNode(10))).setValidator((ParameterValidator)new IntRangeValidator(-1, true))).build();
    static final SimpleAttributeDefinition SKIP = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"skip", (ModelType)ModelType.INT, (boolean)true).setAllowExpression(true)).setDefaultValue(new ModelNode(0))).setValidator((ParameterValidator)new IntRangeValidator(0, true))).build();
    static final SimpleAttributeDefinition TAIL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"tail", (ModelType)ModelType.BOOLEAN, (boolean)true).setAllowExpression(true)).setDefaultValue(new ModelNode(true))).build();
    static final SimpleAttributeDefinition FILE_NAME = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"file-name", (ModelType)ModelType.STRING, (boolean)false).setAllowExpression(false)).build();
    static final SimpleAttributeDefinition FILE_SIZE = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"file-size", (ModelType)ModelType.LONG, (boolean)false).setAllowExpression(false)).build();
    static final SimpleAttributeDefinition LAST_MODIFIED_DATE = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"last-modified-date", (ModelType)ModelType.STRING, (boolean)false).setAllowExpression(false)).build();
    static final SimpleOperationDefinition READ_LOG_FILE = new SimpleOperationDefinitionBuilder("read-log-file", LoggingExtension.getResourceDescriptionResolver(new String[0])).addAccessConstraint(LogFileResourceDefinition.VIEW_SERVER_LOGS).setDeprecated(ModelVersion.create((int)3, (int)0, (int)0)).setParameters(new AttributeDefinition[]{NAME, CommonAttributes.ENCODING, LINES, SKIP, TAIL}).setReplyType(ModelType.LIST).setReplyValueType(ModelType.STRING).setReadOnly().setRuntimeOnly().build();
    static final SimpleOperationDefinition LIST_LOG_FILES = new SimpleOperationDefinitionBuilder("list-log-files", LoggingExtension.getResourceDescriptionResolver(new String[0])).addAccessConstraint(LogFileResourceDefinition.VIEW_SERVER_LOGS).setDeprecated(ModelVersion.create((int)3, (int)0, (int)0)).setReplyType(ModelType.LIST).setReplyParameters(new AttributeDefinition[]{FILE_NAME, FILE_SIZE, LAST_MODIFIED_DATE}).setReadOnly().setRuntimeOnly().build();
    static final SimpleAttributeDefinition[] ATTRIBUTES = new SimpleAttributeDefinition[]{ADD_LOGGING_API_DEPENDENCIES, USE_DEPLOYMENT_LOGGING_CONFIG};
    private final PathManager pathManager;

    protected LoggingResourceDefinition(PathManager pathManager, WildFlyLogContextSelector contextSelector) {
        super(SUBSYSTEM_PATH, LoggingExtension.getResourceDescriptionResolver(new String[0]), (OperationStepHandler)new LoggingSubsystemAdd(pathManager, contextSelector), (OperationStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE);
        this.pathManager = pathManager;
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        super.registerAttributes(resourceRegistration);
        ReloadRequiredWriteAttributeHandler writeHandler = new ReloadRequiredWriteAttributeHandler((AttributeDefinition[])ATTRIBUTES);
        for (SimpleAttributeDefinition attribute : ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute((AttributeDefinition)attribute, null, (OperationStepHandler)writeHandler);
        }
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        if (this.pathManager != null) {
            resourceRegistration.registerOperationHandler((OperationDefinition)LIST_LOG_FILES, (OperationStepHandler)new ListLogFilesOperation());
            resourceRegistration.registerOperationHandler((OperationDefinition)READ_LOG_FILE, (OperationStepHandler)new ReadLogFileOperation());
        }
    }

    @Override
    public void registerTransformers(KnownModelVersion modelVersion, ResourceTransformationDescriptionBuilder rootResourceBuilder, ResourceTransformationDescriptionBuilder loggingProfileBuilder) {
        switch (modelVersion) {
            case VERSION_1_3_0: {
                ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)rootResourceBuilder.getAttributeBuilder().setDiscard((DiscardAttributeChecker)new DiscardAttributeChecker.DiscardAttributeValueChecker(false, true, new ModelNode[]{ADD_LOGGING_API_DEPENDENCIES.getDefaultValue()}), new AttributeDefinition[]{ADD_LOGGING_API_DEPENDENCIES})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{ADD_LOGGING_API_DEPENDENCIES})).end();
                break;
            }
            case VERSION_1_5_0: {
                ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)rootResourceBuilder.getAttributeBuilder().setDiscard((DiscardAttributeChecker)new DiscardAttributeChecker.DiscardAttributeValueChecker(false, true, new ModelNode[]{USE_DEPLOYMENT_LOGGING_CONFIG.getDefaultValue()}), new AttributeDefinition[]{USE_DEPLOYMENT_LOGGING_CONFIG})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{USE_DEPLOYMENT_LOGGING_CONFIG})).end();
            }
        }
    }

    private static void safeClose(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Throwable t) {
                LoggingLogger.ROOT_LOGGER.failedToCloseResource(t, closeable);
            }
        }
    }

    private static List<File> findFiles(String defaultLogDir, ModelNode model) {
        ArrayList<File> logFiles = new ArrayList<File>(LoggingResource.findFiles(defaultLogDir, model));
        if (model.hasDefined("logging-profile")) {
            for (Property property : model.get("logging-profile").asPropertyList()) {
                logFiles.addAll(LoggingResource.findFiles(defaultLogDir, property.getValue()));
            }
        }
        return logFiles;
    }

    private class ReadLogFileOperation
    implements OperationStepHandler {
        private ReadLogFileOperation() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            for (AttributeDefinition attribute : READ_LOG_FILE.getParameters()) {
                attribute.validateOperation(operation);
            }
            String fileName = NAME.resolveModelAttribute(context, operation).asString();
            int numberOfLines = LINES.resolveModelAttribute(context, operation).asInt();
            int skip = SKIP.resolveModelAttribute(context, operation).asInt();
            boolean tail = TAIL.resolveModelAttribute(context, operation).asBoolean();
            ModelNode encodingModel = CommonAttributes.ENCODING.resolveModelAttribute(context, operation);
            String encoding = encodingModel.isDefined() ? encodingModel.asString() : null;
            File path = new File(LoggingResourceDefinition.this.pathManager.resolveRelativePathEntry(fileName, "jboss.server.log.dir"));
            if (!path.exists()) {
                throw LoggingLogger.ROOT_LOGGER.logFileNotFound(fileName, "jboss.server.log.dir");
            }
            ModelNode model = Resource.Tools.readModel((Resource)context.readResource(PathAddress.EMPTY_ADDRESS));
            List logFiles = LoggingResourceDefinition.findFiles(LoggingResourceDefinition.this.pathManager.getPathEntry("jboss.server.log.dir").resolvePath(), model);
            if (!path.canRead() || !logFiles.contains(path)) {
                throw LoggingLogger.ROOT_LOGGER.readNotAllowed(fileName);
            }
            try {
                List<Object> lines = numberOfLines == 0 ? Collections.emptyList() : this.readLines(path, encoding, tail, skip, numberOfLines);
                ModelNode result = context.getResult().setEmptyList();
                for (String line : lines) {
                    result.add(line);
                }
            }
            catch (IOException e) {
                throw LoggingLogger.ROOT_LOGGER.failedToReadLogFile(e, fileName);
            }
            context.completeStep(OperationContext.ResultHandler.NOOP_RESULT_HANDLER);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<String> readLines(File file, String encoding, boolean tail, int skip, int numberOfLines) throws IOException {
            ArrayList<String> arrayList;
            ArrayList<String> lines = numberOfLines < 0 ? new ArrayList<String>() : new ArrayList(numberOfLines);
            BufferedReader reader = null;
            try {
                String line;
                InputStream in = tail ? new LogFileResourceDefinition.LifoFileInputStream(file) : new FileInputStream(file);
                reader = encoding == null ? new BufferedReader(new InputStreamReader(in)) : new BufferedReader(new InputStreamReader(in, encoding));
                int lineCount = 0;
                while ((line = reader.readLine()) != null) {
                    if (++lineCount <= skip) continue;
                    if (lines.size() == numberOfLines) break;
                    lines.add(line);
                }
                if (tail) {
                    Collections.reverse(lines);
                }
                arrayList = lines;
            }
            catch (Throwable throwable) {
                LoggingResourceDefinition.safeClose(reader);
                throw throwable;
            }
            LoggingResourceDefinition.safeClose(reader);
            return arrayList;
        }
    }

    private class ListLogFilesOperation
    implements OperationStepHandler {
        private ListLogFilesOperation() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            ModelNode model = Resource.Tools.readModel((Resource)context.readResource(PathAddress.EMPTY_ADDRESS));
            List logFiles = LoggingResourceDefinition.findFiles(LoggingResourceDefinition.this.pathManager.getPathEntry("jboss.server.log.dir").resolvePath(), model);
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
            ModelNode result = context.getResult().setEmptyList();
            for (File logFile : logFiles) {
                ModelNode fileInfo = new ModelNode();
                fileInfo.get(FILE_NAME.getName()).set(logFile.getName());
                fileInfo.get(FILE_SIZE.getName()).set(logFile.length());
                fileInfo.get(LAST_MODIFIED_DATE.getName()).set(dateFormat.format(new Date(logFile.lastModified())));
                result.add(fileInfo);
            }
            context.completeStep(OperationContext.ResultHandler.NOOP_RESULT_HANDLER);
        }
    }
}

