/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.remoting.RemotingEndpointResource;
import org.jboss.as.remoting.RemotingSubsystemAdd;
import org.jboss.as.remoting.WorkerThreadPoolVsEndpointHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public class RemotingEndpointAdd
extends AbstractAddStepHandler {
    public RemotingEndpointAdd() {
        super(RemotingEndpointResource.INSTANCE.getAttributes());
    }

    protected Resource createResource(OperationContext context) {
        try {
            Resource existing = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS);
            ModelNode existingModel = existing.getModel();
            if (!existingModel.isDefined()) {
                return existing;
            }
            boolean undefined = true;
            for (Property prop : existingModel.asPropertyList()) {
                if (!prop.getValue().isDefined()) continue;
                undefined = false;
                break;
            }
            if (undefined) {
                return existing;
            }
        }
        catch (Resource.NoSuchResourceException noSuchResourceException) {
            // empty catch block
        }
        return super.createResource(context);
    }

    protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        super.populateModel(context, operation, resource);
        PathAddress pa = PathAddress.pathAddress((ModelNode)operation.get("address"));
        context.addStep(Util.createOperation((String)"validate-endpoint", (PathAddress)pa.subAddress(0, pa.size() - 1)), WorkerThreadPoolVsEndpointHandler.INSTANCE, OperationContext.Stage.MODEL);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        if (context.getAttachment(RemotingSubsystemAdd.RUNTIME_KEY) == null) {
            boolean reload = false;
            for (AttributeDefinition ad : RemotingEndpointResource.INSTANCE.getAttributes()) {
                ModelNode deflt;
                ModelNode node = model.get(ad.getName());
                if (!node.isDefined() || node.equals(deflt = ad.getDefaultValue())) continue;
                reload = true;
                break;
            }
            if (reload) {
                context.reloadRequired();
                context.attach(RemotingSubsystemAdd.RUNTIME_KEY, (Object)Boolean.TRUE);
            }
        }
    }

    protected void rollbackRuntime(OperationContext context, ModelNode operation, Resource resource) {
        Boolean revert = (Boolean)context.getAttachment(RemotingSubsystemAdd.RUNTIME_KEY);
        if (revert != null && revert.booleanValue()) {
            context.revertReloadRequired();
        }
    }
}

