/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.installation;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jboss.as.patching.installation.AddOn;
import org.jboss.as.patching.installation.Identity;
import org.jboss.as.patching.installation.InstalledImage;
import org.jboss.as.patching.installation.Layer;
import org.jboss.as.patching.installation.LayersFactory;
import org.jboss.as.version.ProductConfig;

public abstract class InstalledIdentity {
    public abstract List<String> getAllInstalledPatches();

    public abstract Identity getIdentity();

    public abstract List<String> getLayerNames();

    public abstract Layer getLayer(String var1);

    public abstract List<Layer> getLayers();

    public abstract Collection<String> getAddOnNames();

    public abstract AddOn getAddOn(String var1);

    public abstract Collection<AddOn> getAddOns();

    public abstract InstalledImage getInstalledImage();

    public static InstalledIdentity load(File jbossHome, ProductConfig productConfig, File ... repoRoots) throws IOException {
        InstalledImage installedImage = InstalledIdentity.installedImage(jbossHome);
        return InstalledIdentity.load(installedImage, productConfig, Arrays.asList(repoRoots), Collections.emptyList());
    }

    public static InstalledIdentity load(InstalledImage installedImage, ProductConfig productConfig, List<File> moduleRoots, List<File> bundleRoots) throws IOException {
        return LayersFactory.load(installedImage, productConfig, moduleRoots, bundleRoots);
    }

    static InstalledImage installedImage(final File jbossHome) {
        final File appClient = new File(jbossHome, "appclient");
        final File bundles = new File(jbossHome, "bundles");
        final File domain = new File(jbossHome, "domain");
        final File modules = new File(jbossHome, "modules");
        final File metadata = new File(jbossHome, ".installation");
        final File layersConf = new File(modules, "layers.conf");
        final File standalone = new File(jbossHome, "standalone");
        return new InstalledImage(){

            @Override
            public File getJbossHome() {
                return jbossHome;
            }

            @Override
            public File getAppClientDir() {
                return appClient;
            }

            @Override
            public File getBundlesDir() {
                return bundles;
            }

            @Override
            public File getDomainDir() {
                return domain;
            }

            @Override
            public File getInstallationMetadata() {
                return metadata;
            }

            @Override
            public File getPatchesDir() {
                return new File(this.getInstallationMetadata(), "patches");
            }

            @Override
            public File getModulesDir() {
                return modules;
            }

            @Override
            public File getPatchHistoryDir(String patchId) {
                return new File(this.getPatchesDir(), patchId);
            }

            @Override
            public File getStandaloneDir() {
                return standalone;
            }

            @Override
            public File getLayersConf() {
                return layersConf;
            }
        };
    }
}

