/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rowset;

import com.sun.rowset.JdbcRowSetResourceBundle;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.Vector;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.sql.RowSetMetaData;
import javax.sql.rowset.BaseRowSet;
import javax.sql.rowset.JdbcRowSet;
import javax.sql.rowset.Joinable;
import javax.sql.rowset.RowSetMetaDataImpl;
import javax.sql.rowset.RowSetWarning;

public class JdbcRowSetImpl
extends BaseRowSet
implements JdbcRowSet,
Joinable {
    private Connection conn;
    private PreparedStatement ps;
    private ResultSet rs;
    private RowSetMetaDataImpl rowsMD;
    private ResultSetMetaData resMD;
    private PropertyChangeSupport propertyChangeSupport;
    private Vector<Integer> iMatchColumns;
    private Vector<String> strMatchColumns;
    protected transient JdbcRowSetResourceBundle resBundle;
    static final long serialVersionUID = -3591946023893483003L;

    public JdbcRowSetImpl() {
        this.conn = null;
        this.ps = null;
        this.rs = null;
        try {
            this.resBundle = JdbcRowSetResourceBundle.getJdbcRowSetResourceBundle();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.initParams();
        try {
            this.setShowDeleted(false);
        }
        catch (SQLException sqle) {
            System.err.println(this.resBundle.handleGetObject("jdbcrowsetimpl.setshowdeleted").toString() + sqle.getLocalizedMessage());
        }
        try {
            this.setQueryTimeout(0);
        }
        catch (SQLException sqle) {
            System.err.println(this.resBundle.handleGetObject("jdbcrowsetimpl.setquerytimeout").toString() + sqle.getLocalizedMessage());
        }
        try {
            this.setMaxRows(0);
        }
        catch (SQLException sqle) {
            System.err.println(this.resBundle.handleGetObject("jdbcrowsetimpl.setmaxrows").toString() + sqle.getLocalizedMessage());
        }
        try {
            this.setMaxFieldSize(0);
        }
        catch (SQLException sqle) {
            System.err.println(this.resBundle.handleGetObject("jdbcrowsetimpl.setmaxfieldsize").toString() + sqle.getLocalizedMessage());
        }
        try {
            this.setEscapeProcessing(true);
        }
        catch (SQLException sqle) {
            System.err.println(this.resBundle.handleGetObject("jdbcrowsetimpl.setescapeprocessing").toString() + sqle.getLocalizedMessage());
        }
        try {
            this.setConcurrency(1008);
        }
        catch (SQLException sqle) {
            System.err.println(this.resBundle.handleGetObject("jdbcrowsetimpl.setconcurrency").toString() + sqle.getLocalizedMessage());
        }
        this.setTypeMap(null);
        try {
            this.setType(1004);
        }
        catch (SQLException sqle) {
            System.err.println(this.resBundle.handleGetObject("jdbcrowsetimpl.settype").toString() + sqle.getLocalizedMessage());
        }
        this.setReadOnly(true);
        try {
            this.setTransactionIsolation(2);
        }
        catch (SQLException sqle) {
            System.err.println(this.resBundle.handleGetObject("jdbcrowsetimpl.settransactionisolation").toString() + sqle.getLocalizedMessage());
        }
        this.iMatchColumns = new Vector(10);
        for (int i = 0; i < 10; ++i) {
            this.iMatchColumns.add(i, -1);
        }
        this.strMatchColumns = new Vector(10);
        for (int j = 0; j < 10; ++j) {
            this.strMatchColumns.add(j, null);
        }
    }

    public JdbcRowSetImpl(Connection con) throws SQLException {
        this.conn = con;
        this.ps = null;
        this.rs = null;
        try {
            this.resBundle = JdbcRowSetResourceBundle.getJdbcRowSetResourceBundle();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.initParams();
        this.setShowDeleted(false);
        this.setQueryTimeout(0);
        this.setMaxRows(0);
        this.setMaxFieldSize(0);
        this.setParams();
        this.setReadOnly(true);
        this.setTransactionIsolation(2);
        this.setEscapeProcessing(true);
        this.setTypeMap(null);
        this.iMatchColumns = new Vector(10);
        for (int i = 0; i < 10; ++i) {
            this.iMatchColumns.add(i, -1);
        }
        this.strMatchColumns = new Vector(10);
        for (int j = 0; j < 10; ++j) {
            this.strMatchColumns.add(j, null);
        }
    }

    public JdbcRowSetImpl(String url, String user, String password) throws SQLException {
        this.conn = null;
        this.ps = null;
        this.rs = null;
        try {
            this.resBundle = JdbcRowSetResourceBundle.getJdbcRowSetResourceBundle();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.initParams();
        this.setUsername(user);
        this.setPassword(password);
        this.setUrl(url);
        this.setShowDeleted(false);
        this.setQueryTimeout(0);
        this.setMaxRows(0);
        this.setMaxFieldSize(0);
        this.conn = this.connect();
        this.setParams();
        this.setReadOnly(true);
        this.setTransactionIsolation(2);
        this.setEscapeProcessing(true);
        this.setTypeMap(null);
        this.iMatchColumns = new Vector(10);
        for (int i = 0; i < 10; ++i) {
            this.iMatchColumns.add(i, -1);
        }
        this.strMatchColumns = new Vector(10);
        for (int j = 0; j < 10; ++j) {
            this.strMatchColumns.add(j, null);
        }
    }

    public JdbcRowSetImpl(ResultSet res) throws SQLException {
        this.conn = null;
        this.ps = null;
        this.rs = res;
        try {
            this.resBundle = JdbcRowSetResourceBundle.getJdbcRowSetResourceBundle();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.initParams();
        this.setShowDeleted(false);
        this.setQueryTimeout(0);
        this.setMaxRows(0);
        this.setMaxFieldSize(0);
        this.setParams();
        this.setReadOnly(true);
        this.setTransactionIsolation(2);
        this.setEscapeProcessing(true);
        this.setTypeMap(null);
        this.resMD = this.rs.getMetaData();
        this.rowsMD = new RowSetMetaDataImpl();
        this.initMetaData(this.rowsMD, this.resMD);
        this.iMatchColumns = new Vector(10);
        for (int i = 0; i < 10; ++i) {
            this.iMatchColumns.add(i, -1);
        }
        this.strMatchColumns = new Vector(10);
        for (int j = 0; j < 10; ++j) {
            this.strMatchColumns.add(j, null);
        }
    }

    protected void initMetaData(RowSetMetaData md, ResultSetMetaData rsmd) throws SQLException {
        int numCols = rsmd.getColumnCount();
        md.setColumnCount(numCols);
        for (int col = 1; col <= numCols; ++col) {
            md.setAutoIncrement(col, rsmd.isAutoIncrement(col));
            md.setCaseSensitive(col, rsmd.isCaseSensitive(col));
            md.setCurrency(col, rsmd.isCurrency(col));
            md.setNullable(col, rsmd.isNullable(col));
            md.setSigned(col, rsmd.isSigned(col));
            md.setSearchable(col, rsmd.isSearchable(col));
            md.setColumnDisplaySize(col, rsmd.getColumnDisplaySize(col));
            md.setColumnLabel(col, rsmd.getColumnLabel(col));
            md.setColumnName(col, rsmd.getColumnName(col));
            md.setSchemaName(col, rsmd.getSchemaName(col));
            md.setPrecision(col, rsmd.getPrecision(col));
            md.setScale(col, rsmd.getScale(col));
            md.setTableName(col, rsmd.getTableName(col));
            md.setCatalogName(col, rsmd.getCatalogName(col));
            md.setColumnType(col, rsmd.getColumnType(col));
            md.setColumnTypeName(col, rsmd.getColumnTypeName(col));
        }
    }

    protected void checkState() throws SQLException {
        if (this.conn == null && this.ps == null && this.rs == null) {
            throw new SQLException(this.resBundle.handleGetObject("jdbcrowsetimpl.invalstate").toString());
        }
    }

    @Override
    public void execute() throws SQLException {
        this.prepare();
        this.setProperties(this.ps);
        this.decodeParams(this.getParams(), this.ps);
        this.rs = this.ps.executeQuery();
        this.notifyRowSetChanged();
    }

    protected void setProperties(PreparedStatement ps) throws SQLException {
        try {
            ps.setEscapeProcessing(this.getEscapeProcessing());
        }
        catch (SQLException ex) {
            System.err.println(this.resBundle.handleGetObject("jdbcrowsetimpl.setescapeprocessing").toString() + ex.getLocalizedMessage());
        }
        try {
            ps.setMaxFieldSize(this.getMaxFieldSize());
        }
        catch (SQLException ex) {
            System.err.println(this.resBundle.handleGetObject("jdbcrowsetimpl.setmaxfieldsize").toString() + ex.getLocalizedMessage());
        }
        try {
            ps.setMaxRows(this.getMaxRows());
        }
        catch (SQLException ex) {
            System.err.println(this.resBundle.handleGetObject("jdbcrowsetimpl.setmaxrows").toString() + ex.getLocalizedMessage());
        }
        try {
            ps.setQueryTimeout(this.getQueryTimeout());
        }
        catch (SQLException ex) {
            System.err.println(this.resBundle.handleGetObject("jdbcrowsetimpl.setquerytimeout").toString() + ex.getLocalizedMessage());
        }
    }

    protected Connection connect() throws SQLException {
        if (this.conn != null) {
            return this.conn;
        }
        if (this.getDataSourceName() != null) {
            try {
                InitialContext ctx = new InitialContext();
                DataSource ds = (DataSource)ctx.lookup(this.getDataSourceName());
                if (this.getUsername() != null && !this.getUsername().equals("")) {
                    return ds.getConnection(this.getUsername(), this.getPassword());
                }
                return ds.getConnection();
            }
            catch (NamingException ex) {
                throw new SQLException(this.resBundle.handleGetObject("jdbcrowsetimpl.connect").toString());
            }
        }
        if (this.getUrl() != null) {
            return DriverManager.getConnection(this.getUrl(), this.getUsername(), this.getPassword());
        }
        return null;
    }

    protected PreparedStatement prepare() throws SQLException {
        this.conn = this.connect();
        try {
            Map<String, Class<?>> aMap = this.getTypeMap();
            if (aMap != null) {
                this.conn.setTypeMap(aMap);
            }
            this.ps = this.conn.prepareStatement(this.getCommand(), 1004, 1008);
        }
        catch (SQLException ex) {
            System.err.println(this.resBundle.handleGetObject("jdbcrowsetimpl.prepare").toString() + ex.getLocalizedMessage());
            if (this.ps != null) {
                this.ps.close();
            }
            if (this.conn != null) {
                this.conn.close();
            }
            throw new SQLException(ex.getMessage());
        }
        return this.ps;
    }

    private void decodeParams(Object[] params, PreparedStatement ps) throws SQLException {
        Object[] param = null;
        for (int i = 0; i < params.length; ++i) {
            if (params[i] instanceof Object[]) {
                param = (Object[])params[i];
                if (param.length == 2) {
                    if (param[0] == null) {
                        ps.setNull(i + 1, (Integer)param[1]);
                        continue;
                    }
                    if (param[0] instanceof Date || param[0] instanceof Time || param[0] instanceof Timestamp) {
                        System.err.println(this.resBundle.handleGetObject("jdbcrowsetimpl.detecteddate"));
                        if (param[1] instanceof Calendar) {
                            System.err.println(this.resBundle.handleGetObject("jdbcrowsetimpl.detectedcalendar"));
                            ps.setDate(i + 1, (Date)param[0], (Calendar)param[1]);
                            continue;
                        }
                        throw new SQLException(this.resBundle.handleGetObject("jdbcrowsetimpl.paramtype").toString());
                    }
                    if (param[0] instanceof Reader) {
                        ps.setCharacterStream(i + 1, (Reader)param[0], (Integer)param[1]);
                        continue;
                    }
                    if (!(param[1] instanceof Integer)) continue;
                    ps.setObject(i + 1, param[0], (Integer)param[1]);
                    continue;
                }
                if (param.length == 3) {
                    if (param[0] == null) {
                        ps.setNull(i + 1, (Integer)param[1], (String)param[2]);
                        continue;
                    }
                    if (param[0] instanceof InputStream) {
                        switch ((Integer)param[2]) {
                            case 0: {
                                ps.setUnicodeStream(i + 1, (InputStream)param[0], (Integer)param[1]);
                            }
                            case 1: {
                                ps.setBinaryStream(i + 1, (InputStream)param[0], (Integer)param[1]);
                            }
                            case 2: {
                                ps.setAsciiStream(i + 1, (InputStream)param[0], (Integer)param[1]);
                            }
                        }
                        throw new SQLException(this.resBundle.handleGetObject("jdbcrowsetimpl.paramtype").toString());
                    }
                    if (param[1] instanceof Integer && param[2] instanceof Integer) {
                        ps.setObject(i + 1, param[0], (Integer)param[1], (int)((Integer)param[2]));
                        continue;
                    }
                    throw new SQLException(this.resBundle.handleGetObject("jdbcrowsetimpl.paramtype").toString());
                }
                ps.setObject(i + 1, params[i]);
                continue;
            }
            ps.setObject(i + 1, params[i]);
        }
    }

    @Override
    public boolean next() throws SQLException {
        this.checkState();
        boolean b = this.rs.next();
        this.notifyCursorMoved();
        return b;
    }

    @Override
    public void close() throws SQLException {
        if (this.rs != null) {
            this.rs.close();
        }
        if (this.ps != null) {
            this.ps.close();
        }
        if (this.conn != null) {
            this.conn.close();
        }
    }

    @Override
    public boolean wasNull() throws SQLException {
        this.checkState();
        return this.rs.wasNull();
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        this.checkState();
        return this.rs.getString(columnIndex);
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        this.checkState();
        return this.rs.getBoolean(columnIndex);
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        this.checkState();
        return this.rs.getByte(columnIndex);
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        this.checkState();
        return this.rs.getShort(columnIndex);
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        this.checkState();
        return this.rs.getInt(columnIndex);
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        this.checkState();
        return this.rs.getLong(columnIndex);
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        this.checkState();
        return this.rs.getFloat(columnIndex);
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        this.checkState();
        return this.rs.getDouble(columnIndex);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        this.checkState();
        return this.rs.getBigDecimal(columnIndex, scale);
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        this.checkState();
        return this.rs.getBytes(columnIndex);
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        this.checkState();
        return this.rs.getDate(columnIndex);
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        this.checkState();
        return this.rs.getTime(columnIndex);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        this.checkState();
        return this.rs.getTimestamp(columnIndex);
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        this.checkState();
        return this.rs.getAsciiStream(columnIndex);
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        this.checkState();
        return this.rs.getUnicodeStream(columnIndex);
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        this.checkState();
        return this.rs.getBinaryStream(columnIndex);
    }

    @Override
    public String getString(String columnName) throws SQLException {
        return this.getString(this.findColumn(columnName));
    }

    @Override
    public boolean getBoolean(String columnName) throws SQLException {
        return this.getBoolean(this.findColumn(columnName));
    }

    @Override
    public byte getByte(String columnName) throws SQLException {
        return this.getByte(this.findColumn(columnName));
    }

    @Override
    public short getShort(String columnName) throws SQLException {
        return this.getShort(this.findColumn(columnName));
    }

    @Override
    public int getInt(String columnName) throws SQLException {
        return this.getInt(this.findColumn(columnName));
    }

    @Override
    public long getLong(String columnName) throws SQLException {
        return this.getLong(this.findColumn(columnName));
    }

    @Override
    public float getFloat(String columnName) throws SQLException {
        return this.getFloat(this.findColumn(columnName));
    }

    @Override
    public double getDouble(String columnName) throws SQLException {
        return this.getDouble(this.findColumn(columnName));
    }

    @Override
    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName), scale);
    }

    @Override
    public byte[] getBytes(String columnName) throws SQLException {
        return this.getBytes(this.findColumn(columnName));
    }

    @Override
    public Date getDate(String columnName) throws SQLException {
        return this.getDate(this.findColumn(columnName));
    }

    @Override
    public Time getTime(String columnName) throws SQLException {
        return this.getTime(this.findColumn(columnName));
    }

    @Override
    public Timestamp getTimestamp(String columnName) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName));
    }

    @Override
    public InputStream getAsciiStream(String columnName) throws SQLException {
        return this.getAsciiStream(this.findColumn(columnName));
    }

    @Override
    public InputStream getUnicodeStream(String columnName) throws SQLException {
        return this.getUnicodeStream(this.findColumn(columnName));
    }

    @Override
    public InputStream getBinaryStream(String columnName) throws SQLException {
        return this.getBinaryStream(this.findColumn(columnName));
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkState();
        return this.rs.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkState();
        this.rs.clearWarnings();
    }

    @Override
    public String getCursorName() throws SQLException {
        this.checkState();
        return this.rs.getCursorName();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkState();
        try {
            this.checkState();
        }
        catch (SQLException sqle) {
            this.prepare();
            return this.ps.getMetaData();
        }
        return this.rs.getMetaData();
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        this.checkState();
        return this.rs.getObject(columnIndex);
    }

    @Override
    public Object getObject(String columnName) throws SQLException {
        return this.getObject(this.findColumn(columnName));
    }

    @Override
    public int findColumn(String columnName) throws SQLException {
        this.checkState();
        return this.rs.findColumn(columnName);
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        this.checkState();
        return this.rs.getCharacterStream(columnIndex);
    }

    @Override
    public Reader getCharacterStream(String columnName) throws SQLException {
        return this.getCharacterStream(this.findColumn(columnName));
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        this.checkState();
        return this.rs.getBigDecimal(columnIndex);
    }

    @Override
    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName));
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        this.checkState();
        return this.rs.isBeforeFirst();
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        this.checkState();
        return this.rs.isAfterLast();
    }

    @Override
    public boolean isFirst() throws SQLException {
        this.checkState();
        return this.rs.isFirst();
    }

    @Override
    public boolean isLast() throws SQLException {
        this.checkState();
        return this.rs.isLast();
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.checkState();
        this.rs.beforeFirst();
        this.notifyCursorMoved();
    }

    @Override
    public void afterLast() throws SQLException {
        this.checkState();
        this.rs.afterLast();
        this.notifyCursorMoved();
    }

    @Override
    public boolean first() throws SQLException {
        this.checkState();
        boolean b = this.rs.first();
        this.notifyCursorMoved();
        return b;
    }

    @Override
    public boolean last() throws SQLException {
        this.checkState();
        boolean b = this.rs.last();
        this.notifyCursorMoved();
        return b;
    }

    @Override
    public int getRow() throws SQLException {
        this.checkState();
        return this.rs.getRow();
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        this.checkState();
        boolean b = this.rs.absolute(row);
        this.notifyCursorMoved();
        return b;
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        this.checkState();
        boolean b = this.rs.relative(rows);
        this.notifyCursorMoved();
        return b;
    }

    @Override
    public boolean previous() throws SQLException {
        this.checkState();
        boolean b = this.rs.previous();
        this.notifyCursorMoved();
        return b;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.checkState();
        this.rs.setFetchDirection(direction);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        try {
            this.checkState();
        }
        catch (SQLException sqle) {
            super.getFetchDirection();
        }
        return this.rs.getFetchDirection();
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.checkState();
        this.rs.setFetchSize(rows);
    }

    @Override
    public int getType() throws SQLException {
        try {
            this.checkState();
        }
        catch (SQLException sqle) {
            return super.getType();
        }
        if (this.rs == null) {
            return super.getType();
        }
        int rstype = this.rs.getType();
        return rstype;
    }

    @Override
    public int getConcurrency() throws SQLException {
        try {
            this.checkState();
        }
        catch (SQLException sqle) {
            super.getConcurrency();
        }
        return this.rs.getConcurrency();
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        this.checkState();
        return this.rs.rowUpdated();
    }

    @Override
    public boolean rowInserted() throws SQLException {
        this.checkState();
        return this.rs.rowInserted();
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        this.checkState();
        return this.rs.rowDeleted();
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        this.checkState();
        this.checkTypeConcurrency();
        this.rs.updateNull(columnIndex);
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        this.checkState();
        this.checkTypeConcurrency();
        this.rs.updateBoolean(columnIndex, x);
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        this.checkState();
        this.checkTypeConcurrency();
        this.rs.updateByte(columnIndex, x);
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        this.checkState();
        this.checkTypeConcurrency();
        this.rs.updateShort(columnIndex, x);
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        this.checkState();
        this.checkTypeConcurrency();
        this.rs.updateInt(columnIndex, x);
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        this.checkState();
        this.checkTypeConcurrency();
        this.rs.updateLong(columnIndex, x);
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        this.checkState();
        this.checkTypeConcurrency();
        this.rs.updateFloat(columnIndex, x);
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        this.checkState();
        this.checkTypeConcurrency();
        this.rs.updateDouble(columnIndex, x);
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        this.checkState();
        this.checkTypeConcurrency();
        this.rs.updateBigDecimal(columnIndex, x);
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        this.checkState();
        this.checkTypeConcurrency();
        this.rs.updateString(columnIndex, x);
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        this.checkState();
        this.checkTypeConcurrency();
        this.rs.updateBytes(columnIndex, x);
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        this.checkState();
        this.checkTypeConcurrency();
        this.rs.updateDate(columnIndex, x);
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        this.checkState();
        this.checkTypeConcurrency();
        this.rs.updateTime(columnIndex, x);
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        this.checkState();
        this.checkTypeConcurrency();
        this.rs.updateTimestamp(columnIndex, x);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.checkState();
        this.checkTypeConcurrency();
        this.rs.updateAsciiStream(columnIndex, x, length);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.checkState();
        this.checkTypeConcurrency();
        this.rs.updateBinaryStream(columnIndex, x, length);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        this.checkState();
        this.checkTypeConcurrency();
        this.rs.updateCharacterStream(columnIndex, x, length);
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        this.checkState();
        this.checkTypeConcurrency();
        this.rs.updateObject(columnIndex, x, scale);
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        this.checkState();
        this.checkTypeConcurrency();
        this.rs.updateObject(columnIndex, x);
    }

    @Override
    public void updateNull(String columnName) throws SQLException {
        this.updateNull(this.findColumn(columnName));
    }

    @Override
    public void updateBoolean(String columnName, boolean x) throws SQLException {
        this.updateBoolean(this.findColumn(columnName), x);
    }

    @Override
    public void updateByte(String columnName, byte x) throws SQLException {
        this.updateByte(this.findColumn(columnName), x);
    }

    @Override
    public void updateShort(String columnName, short x) throws SQLException {
        this.updateShort(this.findColumn(columnName), x);
    }

    @Override
    public void updateInt(String columnName, int x) throws SQLException {
        this.updateInt(this.findColumn(columnName), x);
    }

    @Override
    public void updateLong(String columnName, long x) throws SQLException {
        this.updateLong(this.findColumn(columnName), x);
    }

    @Override
    public void updateFloat(String columnName, float x) throws SQLException {
        this.updateFloat(this.findColumn(columnName), x);
    }

    @Override
    public void updateDouble(String columnName, double x) throws SQLException {
        this.updateDouble(this.findColumn(columnName), x);
    }

    @Override
    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        this.updateBigDecimal(this.findColumn(columnName), x);
    }

    @Override
    public void updateString(String columnName, String x) throws SQLException {
        this.updateString(this.findColumn(columnName), x);
    }

    @Override
    public void updateBytes(String columnName, byte[] x) throws SQLException {
        this.updateBytes(this.findColumn(columnName), x);
    }

    @Override
    public void updateDate(String columnName, Date x) throws SQLException {
        this.updateDate(this.findColumn(columnName), x);
    }

    @Override
    public void updateTime(String columnName, Time x) throws SQLException {
        this.updateTime(this.findColumn(columnName), x);
    }

    @Override
    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        this.updateTimestamp(this.findColumn(columnName), x);
    }

    @Override
    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        this.updateAsciiStream(this.findColumn(columnName), x, length);
    }

    @Override
    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        this.updateBinaryStream(this.findColumn(columnName), x, length);
    }

    @Override
    public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        this.updateCharacterStream(this.findColumn(columnName), reader, length);
    }

    @Override
    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        this.updateObject(this.findColumn(columnName), x, scale);
    }

    @Override
    public void updateObject(String columnName, Object x) throws SQLException {
        this.updateObject(this.findColumn(columnName), x);
    }

    @Override
    public void insertRow() throws SQLException {
        this.checkState();
        this.rs.insertRow();
        this.notifyRowChanged();
    }

    @Override
    public void updateRow() throws SQLException {
        this.checkState();
        this.rs.updateRow();
        this.notifyRowChanged();
    }

    @Override
    public void deleteRow() throws SQLException {
        this.checkState();
        this.rs.deleteRow();
        this.notifyRowChanged();
    }

    @Override
    public void refreshRow() throws SQLException {
        this.checkState();
        this.rs.refreshRow();
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        this.checkState();
        this.rs.cancelRowUpdates();
        this.notifyRowChanged();
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        this.checkState();
        this.rs.moveToInsertRow();
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        this.checkState();
        this.rs.moveToCurrentRow();
    }

    @Override
    public Statement getStatement() throws SQLException {
        if (this.rs != null) {
            return this.rs.getStatement();
        }
        return null;
    }

    @Override
    public Object getObject(int i, Map<String, Class<?>> map) throws SQLException {
        this.checkState();
        return this.rs.getObject(i, map);
    }

    @Override
    public Ref getRef(int i) throws SQLException {
        this.checkState();
        return this.rs.getRef(i);
    }

    @Override
    public Blob getBlob(int i) throws SQLException {
        this.checkState();
        return this.rs.getBlob(i);
    }

    @Override
    public Clob getClob(int i) throws SQLException {
        this.checkState();
        return this.rs.getClob(i);
    }

    @Override
    public Array getArray(int i) throws SQLException {
        this.checkState();
        return this.rs.getArray(i);
    }

    @Override
    public Object getObject(String colName, Map<String, Class<?>> map) throws SQLException {
        return this.getObject(this.findColumn(colName), map);
    }

    @Override
    public Ref getRef(String colName) throws SQLException {
        return this.getRef(this.findColumn(colName));
    }

    @Override
    public Blob getBlob(String colName) throws SQLException {
        return this.getBlob(this.findColumn(colName));
    }

    @Override
    public Clob getClob(String colName) throws SQLException {
        return this.getClob(this.findColumn(colName));
    }

    @Override
    public Array getArray(String colName) throws SQLException {
        return this.getArray(this.findColumn(colName));
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        this.checkState();
        return this.rs.getDate(columnIndex, cal);
    }

    @Override
    public Date getDate(String columnName, Calendar cal) throws SQLException {
        return this.getDate(this.findColumn(columnName), cal);
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        this.checkState();
        return this.rs.getTime(columnIndex, cal);
    }

    @Override
    public Time getTime(String columnName, Calendar cal) throws SQLException {
        return this.getTime(this.findColumn(columnName), cal);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        this.checkState();
        return this.rs.getTimestamp(columnIndex, cal);
    }

    @Override
    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName), cal);
    }

    @Override
    public void updateRef(int columnIndex, Ref ref) throws SQLException {
        this.checkState();
        this.rs.updateRef(columnIndex, ref);
    }

    @Override
    public void updateRef(String columnName, Ref ref) throws SQLException {
        this.updateRef(this.findColumn(columnName), ref);
    }

    @Override
    public void updateClob(int columnIndex, Clob c) throws SQLException {
        this.checkState();
        this.rs.updateClob(columnIndex, c);
    }

    @Override
    public void updateClob(String columnName, Clob c) throws SQLException {
        this.updateClob(this.findColumn(columnName), c);
    }

    @Override
    public void updateBlob(int columnIndex, Blob b) throws SQLException {
        this.checkState();
        this.rs.updateBlob(columnIndex, b);
    }

    @Override
    public void updateBlob(String columnName, Blob b) throws SQLException {
        this.updateBlob(this.findColumn(columnName), b);
    }

    @Override
    public void updateArray(int columnIndex, Array a) throws SQLException {
        this.checkState();
        this.rs.updateArray(columnIndex, a);
    }

    @Override
    public void updateArray(String columnName, Array a) throws SQLException {
        this.updateArray(this.findColumn(columnName), a);
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        this.checkState();
        return this.rs.getURL(columnIndex);
    }

    @Override
    public URL getURL(String columnName) throws SQLException {
        return this.getURL(this.findColumn(columnName));
    }

    @Override
    public RowSetWarning getRowSetWarnings() throws SQLException {
        return null;
    }

    @Override
    public void unsetMatchColumn(int[] columnIdxes) throws SQLException {
        for (int j = 0; j < columnIdxes.length; ++j) {
            int i_val = Integer.parseInt(this.iMatchColumns.get(j).toString());
            if (columnIdxes[j] == i_val) continue;
            throw new SQLException(this.resBundle.handleGetObject("jdbcrowsetimpl.matchcols").toString());
        }
        for (int i = 0; i < columnIdxes.length; ++i) {
            this.iMatchColumns.set(i, -1);
        }
    }

    @Override
    public void unsetMatchColumn(String[] columnIdxes) throws SQLException {
        for (int j = 0; j < columnIdxes.length; ++j) {
            if (columnIdxes[j].equals(this.strMatchColumns.get(j))) continue;
            throw new SQLException(this.resBundle.handleGetObject("jdbcrowsetimpl.matchcols").toString());
        }
        for (int i = 0; i < columnIdxes.length; ++i) {
            this.strMatchColumns.set(i, null);
        }
    }

    @Override
    public String[] getMatchColumnNames() throws SQLException {
        Object[] str_temp = new String[this.strMatchColumns.size()];
        if (this.strMatchColumns.get(0) == null) {
            throw new SQLException(this.resBundle.handleGetObject("jdbcrowsetimpl.setmatchcols").toString());
        }
        this.strMatchColumns.copyInto(str_temp);
        return str_temp;
    }

    @Override
    public int[] getMatchColumnIndexes() throws SQLException {
        Object[] int_temp = new Integer[this.iMatchColumns.size()];
        int[] i_temp = new int[this.iMatchColumns.size()];
        int i_val = this.iMatchColumns.get(0);
        if (i_val == -1) {
            throw new SQLException(this.resBundle.handleGetObject("jdbcrowsetimpl.setmatchcols").toString());
        }
        this.iMatchColumns.copyInto(int_temp);
        for (int i = 0; i < int_temp.length; ++i) {
            i_temp[i] = (Integer)int_temp[i];
        }
        return i_temp;
    }

    @Override
    public void setMatchColumn(int[] columnIdxes) throws SQLException {
        for (int j = 0; j < columnIdxes.length; ++j) {
            if (columnIdxes[j] >= 0) continue;
            throw new SQLException(this.resBundle.handleGetObject("jdbcrowsetimpl.matchcols1").toString());
        }
        for (int i = 0; i < columnIdxes.length; ++i) {
            this.iMatchColumns.add(i, columnIdxes[i]);
        }
    }

    @Override
    public void setMatchColumn(String[] columnNames) throws SQLException {
        for (int j = 0; j < columnNames.length; ++j) {
            if (columnNames[j] != null && !columnNames[j].equals("")) continue;
            throw new SQLException(this.resBundle.handleGetObject("jdbcrowsetimpl.matchcols2").toString());
        }
        for (int i = 0; i < columnNames.length; ++i) {
            this.strMatchColumns.add(i, columnNames[i]);
        }
    }

    @Override
    public void setMatchColumn(int columnIdx) throws SQLException {
        if (columnIdx < 0) {
            throw new SQLException(this.resBundle.handleGetObject("jdbcrowsetimpl.matchcols1").toString());
        }
        this.iMatchColumns.set(0, columnIdx);
    }

    @Override
    public void setMatchColumn(String columnName) throws SQLException {
        if (columnName == null || (columnName = columnName.trim()).equals("")) {
            throw new SQLException(this.resBundle.handleGetObject("jdbcrowsetimpl.matchcols2").toString());
        }
        this.strMatchColumns.set(0, columnName);
    }

    @Override
    public void unsetMatchColumn(int columnIdx) throws SQLException {
        if (!this.iMatchColumns.get(0).equals(columnIdx)) {
            throw new SQLException(this.resBundle.handleGetObject("jdbcrowsetimpl.unsetmatch").toString());
        }
        if (this.strMatchColumns.get(0) != null) {
            throw new SQLException(this.resBundle.handleGetObject("jdbcrowsetimpl.usecolname").toString());
        }
        this.iMatchColumns.set(0, -1);
    }

    @Override
    public void unsetMatchColumn(String columnName) throws SQLException {
        columnName = columnName.trim();
        if (!this.strMatchColumns.get(0).equals(columnName)) {
            throw new SQLException(this.resBundle.handleGetObject("jdbcrowsetimpl.unsetmatch").toString());
        }
        if (this.iMatchColumns.get(0) > 0) {
            throw new SQLException(this.resBundle.handleGetObject("jdbcrowsetimpl.usecolid").toString());
        }
        this.strMatchColumns.set(0, null);
    }

    public DatabaseMetaData getDatabaseMetaData() throws SQLException {
        Connection con = this.connect();
        return con.getMetaData();
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        this.prepare();
        return this.ps.getParameterMetaData();
    }

    @Override
    public void commit() throws SQLException {
        this.conn.commit();
        if (this.conn.getHoldability() != 1) {
            ResultSet oldVal = this.rs;
            this.rs = null;
        }
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        if (this.conn != null) {
            this.conn.setAutoCommit(autoCommit);
        } else {
            this.conn = this.connect();
            this.conn.setAutoCommit(autoCommit);
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.conn.getAutoCommit();
    }

    @Override
    public void rollback() throws SQLException {
        this.conn.rollback();
        ResultSet oldVal = this.rs;
        this.rs = null;
    }

    @Override
    public void rollback(Savepoint s) throws SQLException {
        this.conn.rollback(s);
    }

    protected void setParams() throws SQLException {
        if (this.rs == null) {
            this.setType(1004);
            this.setConcurrency(1008);
        } else {
            this.setType(this.rs.getType());
            this.setConcurrency(this.rs.getConcurrency());
        }
    }

    private void checkTypeConcurrency() throws SQLException {
        if (this.rs.getType() == 1003 || this.rs.getConcurrency() == 1007) {
            throw new SQLException(this.resBundle.handleGetObject("jdbcrowsetimpl.resnotupd").toString());
        }
    }

    protected Connection getConnection() {
        return this.conn;
    }

    protected void setConnection(Connection connection) {
        this.conn = connection;
    }

    protected PreparedStatement getPreparedStatement() {
        return this.ps;
    }

    protected void setPreparedStatement(PreparedStatement preparedStatement) {
        this.ps = preparedStatement;
    }

    protected ResultSet getResultSet() throws SQLException {
        this.checkState();
        return this.rs;
    }

    protected void setResultSet(ResultSet resultSet) {
        this.rs = resultSet;
    }

    @Override
    public void setCommand(String command) throws SQLException {
        if (this.getCommand() != null) {
            if (!this.getCommand().equals(command)) {
                String oldVal = this.getCommand();
                super.setCommand(command);
                this.ps = null;
                this.rs = null;
                this.propertyChangeSupport.firePropertyChange("command", oldVal, command);
            }
        } else {
            super.setCommand(command);
            this.propertyChangeSupport.firePropertyChange("command", null, command);
        }
    }

    @Override
    public void setDataSourceName(String dsName) throws SQLException {
        if (this.getDataSourceName() != null) {
            if (!this.getDataSourceName().equals(dsName)) {
                String oldVal = this.getDataSourceName();
                super.setDataSourceName(dsName);
                this.conn = null;
                this.ps = null;
                this.rs = null;
                this.propertyChangeSupport.firePropertyChange("dataSourceName", oldVal, dsName);
            }
        } else {
            super.setDataSourceName(dsName);
            this.propertyChangeSupport.firePropertyChange("dataSourceName", null, dsName);
        }
    }

    @Override
    public void setUrl(String url) throws SQLException {
        if (this.getUrl() != null) {
            if (!this.getUrl().equals(url)) {
                String oldVal = this.getUrl();
                super.setUrl(url);
                this.conn = null;
                this.ps = null;
                this.rs = null;
                this.propertyChangeSupport.firePropertyChange("url", oldVal, url);
            }
        } else {
            super.setUrl(url);
            this.propertyChangeSupport.firePropertyChange("url", null, url);
        }
    }

    @Override
    public void setUsername(String uname) {
        if (this.getUsername() != null) {
            if (!this.getUsername().equals(uname)) {
                String oldVal = this.getUsername();
                super.setUsername(uname);
                this.conn = null;
                this.ps = null;
                this.rs = null;
                this.propertyChangeSupport.firePropertyChange("username", oldVal, uname);
            }
        } else {
            super.setUsername(uname);
            this.propertyChangeSupport.firePropertyChange("username", null, uname);
        }
    }

    @Override
    public void setPassword(String password) {
        if (this.getPassword() != null) {
            if (!this.getPassword().equals(password)) {
                String oldVal = this.getPassword();
                super.setPassword(password);
                this.conn = null;
                this.ps = null;
                this.rs = null;
                this.propertyChangeSupport.firePropertyChange("password", oldVal, password);
            }
        } else {
            super.setPassword(password);
            this.propertyChangeSupport.firePropertyChange("password", null, password);
        }
    }

    @Override
    public void setType(int type) throws SQLException {
        int oldVal;
        try {
            oldVal = this.getType();
        }
        catch (SQLException ex) {
            oldVal = 0;
        }
        if (oldVal != type) {
            super.setType(type);
            this.propertyChangeSupport.firePropertyChange("type", oldVal, type);
        }
    }

    @Override
    public void setConcurrency(int concur) throws SQLException {
        int oldVal;
        try {
            oldVal = this.getConcurrency();
        }
        catch (NullPointerException ex) {
            oldVal = 0;
        }
        if (oldVal != concur) {
            super.setConcurrency(concur);
            this.propertyChangeSupport.firePropertyChange("concurrency", oldVal, concur);
        }
    }

    @Override
    public void setTransactionIsolation(int transIso) throws SQLException {
        int oldVal;
        try {
            oldVal = this.getTransactionIsolation();
        }
        catch (NullPointerException ex) {
            oldVal = 0;
        }
        if (oldVal != transIso) {
            super.setTransactionIsolation(transIso);
            this.propertyChangeSupport.firePropertyChange("transactionIsolation", oldVal, transIso);
        }
    }

    @Override
    public void setMaxRows(int mRows) throws SQLException {
        int oldVal;
        try {
            oldVal = this.getMaxRows();
        }
        catch (NullPointerException ex) {
            oldVal = 0;
        }
        if (oldVal != mRows) {
            super.setMaxRows(mRows);
            this.propertyChangeSupport.firePropertyChange("maxRows", oldVal, mRows);
        }
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("jdbcrowsetimpl.featnotsupp").toString());
    }

    @Override
    public SQLXML getSQLXML(String colName) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("jdbcrowsetimpl.featnotsupp").toString());
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("jdbcrowsetimpl.featnotsupp").toString());
    }

    @Override
    public RowId getRowId(String columnName) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("jdbcrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("jdbcrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void updateRowId(String columnName, RowId x) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("jdbcrowsetimpl.featnotsupp").toString());
    }

    @Override
    public int getHoldability() throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("jdbcrowsetimpl.featnotsupp").toString());
    }

    @Override
    public boolean isClosed() throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("jdbcrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("jdbcrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void updateNString(String columnName, String nString) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("jdbcrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("jdbcrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void updateNClob(String columnName, NClob nClob) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("jdbcrowsetimpl.featnotsupp").toString());
    }

    @Override
    public NClob getNClob(int i) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("jdbcrowsetimpl.featnotsupp").toString());
    }

    @Override
    public NClob getNClob(String colName) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("jdbcrowsetimpl.featnotsupp").toString());
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> interfaces) throws SQLException {
        return false;
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("jdbcrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void setSQLXML(String parameterName, SQLXML xmlObject) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("jdbcrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("jdbcrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void setRowId(String parameterName, RowId x) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("jdbcrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("jdbcrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("jdbcrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void setNClob(String parameterName, NClob value) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("jdbcrowsetimpl.featnotsupp").toString());
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("jdbcrowsetimpl.featnotsupp").toString());
    }

    @Override
    public Reader getNCharacterStream(String columnName) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("jdbcrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("jdbcrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void updateSQLXML(String columnName, SQLXML xmlObject) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("jdbcrowsetimpl.featnotsupp").toString());
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("jdbcrowsetimpl.featnotsupp").toString());
    }

    @Override
    public String getNString(String columnName) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("jdbcrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("jdbcrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void updateNCharacterStream(String columnName, Reader x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("jdbcrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("jdbcrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("jdbcrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("jdbcrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("jdbcrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("jdbcrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("jdbcrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("jdbcrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("jdbcrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("jdbcrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("jdbcrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("jdbcrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("jdbcrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("jdbcrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("jdbcrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("jdbcrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("jdbcrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("jdbcrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("jdbcrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("jdbcrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("jdbcrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("jdbcrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("jdbcrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("jdbcrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("jdbcrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("jdbcrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("jdbcrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("jdbcrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("jdbcrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void setNClob(String parameterName, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("jdbcrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void setNClob(String parameterName, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("jdbcrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("jdbcrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("jdbcrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void setNString(String parameterName, String value) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("jdbcrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("jdbcrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("jdbcrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("jdbcrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x, Calendar cal) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("jdbcrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void setClob(String parameterName, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("jdbcrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void setClob(String parameterName, Clob x) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("jdbcrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void setClob(String parameterName, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("jdbcrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void setDate(String parameterName, Date x) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("jdbcrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void setDate(String parameterName, Date x, Calendar cal) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("jdbcrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void setTime(String parameterName, Time x) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("jdbcrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void setTime(String parameterName, Time x, Calendar cal) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("jdbcrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("jdbcrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("jdbcrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("jdbcrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("jdbcrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("jdbcrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void setBlob(String parameterName, Blob x) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("jdbcrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("jdbcrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType, int scale) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("jdbcrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("jdbcrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void setObject(String parameterName, Object x) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("jdbcrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("jdbcrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("jdbcrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("jdbcrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("jdbcrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("jdbcrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("jdbcrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void setBigDecimal(String parameterName, BigDecimal x) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("jdbcrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void setString(String parameterName, String x) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("jdbcrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void setBytes(String parameterName, byte[] x) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("jdbcrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("jdbcrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void setNull(String parameterName, int sqlType) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("jdbcrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("jdbcrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void setBoolean(String parameterName, boolean x) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("jdbcrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void setByte(String parameterName, byte x) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("jdbcrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void setShort(String parameterName, short x) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("jdbcrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void setInt(String parameterName, int x) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("jdbcrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void setLong(String parameterName, long x) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("jdbcrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void setFloat(String parameterName, float x) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("jdbcrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void setDouble(String parameterName, double x) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("jdbcrowsetimpl.featnotsupp").toString());
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        try {
            this.resBundle = JdbcRowSetResourceBundle.getJdbcRowSetResourceBundle();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }
}

