/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.plugin.config;

import java.nio.file.attribute.PosixFilePermission;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.galleon.util.CollectionUtils;
import org.wildfly.galleon.plugin.config.FileFilter;

public class FilePermission {
    private Set<PosixFilePermission> permission = Collections.emptySet();
    private String value;
    private List<FileFilter> filters = Collections.emptyList();

    public void setValue(String value) {
        this.value = value;
        this.permission = FilePermission.fromString(value);
    }

    public void addFilter(FileFilter filter) {
        this.filters = CollectionUtils.add(this.filters, (Object)filter);
    }

    private static Set<PosixFilePermission> fromString(String permission) {
        int others;
        int group;
        if (permission.length() != 3) {
            throw new RuntimeException("Permission string must be 3 digits");
        }
        HashSet<PosixFilePermission> permissions = new HashSet<PosixFilePermission>();
        int user = Integer.parseInt(Character.toString(permission.charAt(0)));
        if ((user & 1) != 0) {
            permissions.add(PosixFilePermission.OWNER_EXECUTE);
        }
        if ((user & 2) != 0) {
            permissions.add(PosixFilePermission.OWNER_WRITE);
        }
        if ((user & 4) != 0) {
            permissions.add(PosixFilePermission.OWNER_READ);
        }
        if (((group = Integer.parseInt(Character.toString(permission.charAt(1)))) & 1) != 0) {
            permissions.add(PosixFilePermission.GROUP_EXECUTE);
        }
        if ((group & 2) != 0) {
            permissions.add(PosixFilePermission.GROUP_WRITE);
        }
        if ((group & 4) != 0) {
            permissions.add(PosixFilePermission.GROUP_READ);
        }
        if (((others = Integer.parseInt(Character.toString(permission.charAt(2)))) & 1) != 0) {
            permissions.add(PosixFilePermission.OTHERS_EXECUTE);
        }
        if ((others & 2) != 0) {
            permissions.add(PosixFilePermission.OTHERS_WRITE);
        }
        if ((others & 4) != 0) {
            permissions.add(PosixFilePermission.OTHERS_READ);
        }
        return permissions;
    }

    public Set<PosixFilePermission> getPermission() {
        return this.permission;
    }

    public List<FileFilter> getFilters() {
        return this.filters;
    }

    public String getValue() {
        return this.value;
    }

    public boolean includeFile(String path) {
        for (FileFilter filter : this.filters) {
            if (!filter.matches(path)) continue;
            return filter.isInclude();
        }
        return false;
    }
}

