/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.plugin.server;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import org.jboss.galleon.MessageWriter;
import org.jboss.galleon.ProvisioningException;
import org.wildfly.core.launcher.CliCommandBuilder;

public class CliScriptRunner {
    public static void runCliScript(Path installHome, Path script, MessageWriter messageWriter) throws ProvisioningException {
        CliCommandBuilder builder = CliCommandBuilder.of((Path)installHome).addCliArgument("--no-operation-validation").addCliArgument("--echo-command").addCliArgument("--file=" + script);
        List arguments = builder.build();
        messageWriter.verbose("Executing jboss console: %s", new Object[]{arguments.stream().collect(Collectors.joining(" "))});
        ProcessBuilder processBuilder = new ProcessBuilder(arguments).redirectErrorStream(true);
        processBuilder.environment().put("JBOSS_HOME", installHome.toString());
        CliScriptRunner.execute(processBuilder, messageWriter);
    }

    private static void execute(ProcessBuilder processBuilder, MessageWriter messageWriter) throws ProvisioningException {
        try {
            Process cliProcess = processBuilder.start();
            String config = null;
            StringWriter errorWriter = new StringWriter();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(cliProcess.getInputStream()));
                 BufferedWriter writer = new BufferedWriter(errorWriter);){
                String line = reader.readLine();
                boolean flush = false;
                while (line != null) {
                    if (line.equals("}")) {
                        flush = true;
                    } else {
                        if (line.startsWith("&config ")) {
                            config = line;
                        }
                        if (flush) {
                            writer.flush();
                            errorWriter.getBuffer().setLength(0);
                            flush = false;
                        }
                    }
                    writer.write(line);
                    writer.newLine();
                    line = reader.readLine();
                }
            }
            catch (IOException e) {
                messageWriter.error((Throwable)e, (CharSequence)e.getMessage());
            }
            if (cliProcess.isAlive()) {
                try {
                    cliProcess.waitFor();
                }
                catch (InterruptedException e) {
                    messageWriter.error((Throwable)e, (CharSequence)e.getMessage());
                }
            }
            if (cliProcess.exitValue() != 0) {
                throw new ProvisioningException("Failed to generate " + config.substring(1), (Throwable)new ProvisioningException(errorWriter.getBuffer().toString()));
            }
        }
        catch (IOException e) {
            throw new ProvisioningException("CLI process failed", (Throwable)e);
        }
    }
}

