/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.plugin;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.config.ConfigId;
import org.jboss.galleon.config.ConfigModel;
import org.jboss.galleon.config.FeatureConfig;
import org.jboss.galleon.config.FeaturePackConfig;
import org.jboss.galleon.plugin.PluginOption;
import org.jboss.galleon.runtime.FeaturePackRuntime;
import org.jboss.galleon.runtime.ProvisioningRuntime;
import org.jboss.galleon.runtime.ResolvedFeatureSpec;
import org.jboss.galleon.spec.FeatureAnnotation;
import org.jboss.galleon.spec.FeatureId;
import org.jboss.galleon.spec.FeatureParameterSpec;
import org.jboss.galleon.spec.FeatureSpec;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.wildfly.galleon.plugin.server.CompleteServerInvoker;
import org.wildfly.galleon.plugin.server.EmbeddedServerInvoker;

public class WfDiffConfigGenerator {
    private static final String CONFIGURE_SYNC = "/synchronization=simple:add(host=%s, port=%s, protocol=%s, username=%s, password=%s)";
    private static final String EXPORT_DIFF = "attachment save --overwrite --operation=/synchronization=simple:export-diff --file=%s";
    private static final String EXPORT_FEATURE = "attachment save --overwrite --operation=/synchronization=simple:feature-diff --file=%s";
    static final PluginOption HOST = PluginOption.builder((String)"host").setDefaultValue("127.0.0.1").build();
    static final PluginOption PORT = PluginOption.builder((String)"port").setDefaultValue("9990").build();
    static final PluginOption PROTOCOL = PluginOption.builder((String)"protocol").setDefaultValue("remote+http").build();
    static final PluginOption USERNAME = PluginOption.builder((String)"username").setRequired().build();
    static final PluginOption PASSWORD = PluginOption.builder((String)"password").setRequired().build();
    static final PluginOption SERVER_CONFIG = PluginOption.builder((String)"server-config").setDefaultValue("standalone.xml").build();

    public static ConfigModel exportDiff(ProvisioningRuntime runtime, Map<FeaturePackLocation.FPID, ConfigId> includedConfigs, Path customizedInstallation, Path target) throws ProvisioningException {
        String host = runtime.getOptionValue(HOST);
        String port = runtime.getOptionValue(PORT);
        String protocol = runtime.getOptionValue(PROTOCOL);
        String username = runtime.getOptionValue(USERNAME);
        String password = runtime.getOptionValue(PASSWORD);
        String serverConfig = runtime.getOptionValue(SERVER_CONFIG);
        CompleteServerInvoker server = new CompleteServerInvoker(customizedInstallation.toAbsolutePath(), runtime.getMessageWriter(), serverConfig);
        EmbeddedServerInvoker embeddedServer = new EmbeddedServerInvoker(runtime.getMessageWriter(), runtime.getInstallDir().toAbsolutePath(), serverConfig);
        try {
            Files.createDirectories(target, new FileAttribute[0]);
            server.startServer();
            embeddedServer.execute(String.format(CONFIGURE_SYNC, host, port, protocol, username, password), String.format(EXPORT_DIFF, target.resolve("finalize.cli").toAbsolutePath()), String.format(EXPORT_FEATURE, target.resolve("feature_config.dmr").toAbsolutePath()));
            ConfigModel.Builder configBuilder = ((ConfigModel.Builder)ConfigModel.builder().setName("standalone.xml")).setModel("standalone");
            WfDiffConfigGenerator.createConfiguration(runtime, configBuilder, includedConfigs, target.resolve("feature_config.dmr").toAbsolutePath());
            ConfigModel configModel = configBuilder.build();
            return configModel;
        }
        catch (IOException | XMLStreamException ex) {
            runtime.getMessageWriter().error((Throwable)ex, "Couldn't compute the WildFly Model diff because of %s", new Object[]{ex.getMessage()});
            throw new ProvisioningException("Couldn't compute the WildFly Model diff", (Throwable)ex);
        }
        finally {
            server.stopServer();
        }
    }

    private static void createConfiguration(ProvisioningRuntime runtime, ConfigModel.Builder builder, Map<FeaturePackLocation.FPID, ConfigId> includedConfigBuilders, Path json) throws IOException, XMLStreamException, ProvisioningDescriptionException {
        try (InputStream in = Files.newInputStream(json, new OpenOption[0]);){
            ModelNode featureDiff = ModelNode.fromBase64((InputStream)in);
            for (ModelNode feature : featureDiff.asList()) {
                String specName = feature.require("feature").require("spec").asString();
                DependencySpec dependencySpec = WfDiffConfigGenerator.getFeatureSpec(runtime, specName);
                FeatureSpec resolvedSpec = dependencySpec.spec;
                if (resolvedSpec == null || !resolvedSpec.hasAnnotations()) continue;
                HashMap<String, String> address = new HashMap<String, String>();
                for (Property elt : feature.require("feature").require("address").asPropertyList()) {
                    address.put(elt.getName(), elt.getValue().asString());
                }
                FeatureConfig featureConfig = FeatureConfig.newConfig((String)specName).setOrigin(dependencySpec.fpName);
                FeatureAnnotation firstAnnotation = (FeatureAnnotation)resolvedSpec.getAnnotations().iterator().next();
                WfDiffConfigGenerator.resolveAddressParams(featureConfig, address, firstAnnotation);
                HashMap<String, String> params = new HashMap<String, String>();
                if (feature.require("feature").hasDefined("params")) {
                    for (Property elt : feature.require("feature").require("params").asPropertyList()) {
                        params.put(elt.getName(), elt.getValue().asString());
                    }
                    WfDiffConfigGenerator.resolveParams(featureConfig, params, firstAnnotation);
                }
                if (feature.require("feature").require("exclude").asBoolean()) {
                    if (!includedConfigBuilders.containsKey(dependencySpec.fpid)) {
                        includedConfigBuilders.put(dependencySpec.fpid, new ConfigId("standalone", "standalone.xml"));
                    }
                    FeatureId.Builder idBuilder = FeatureId.builder((String)specName);
                    for (FeatureParameterSpec fparam : resolvedSpec.getIdParams()) {
                        idBuilder.setParam(fparam.getName(), featureConfig.getParam(fparam.getName()));
                    }
                    builder.excludeFeature(dependencySpec.fpName, idBuilder.build());
                    continue;
                }
                builder.addFeature(featureConfig);
            }
        }
    }

    private static DependencySpec getFeatureSpec(ProvisioningRuntime runtime, String name) throws ProvisioningDescriptionException {
        ResolvedFeatureSpec spec;
        for (FeaturePackRuntime fp : runtime.getFeaturePacks()) {
            spec = fp.getResolvedFeatureSpec(name);
            if (spec == null) continue;
            return new DependencySpec(FeaturePackConfig.getDefaultOriginName((FeaturePackLocation)fp.getSpec().getFPID().getLocation()), fp.getFPID(), spec.getSpec());
        }
        for (FeaturePackRuntime fp : runtime.getFeaturePacks()) {
            spec = fp.getFeatureSpec(name);
            if (spec == null) continue;
            return new DependencySpec(FeaturePackConfig.getDefaultOriginName((FeaturePackLocation)fp.getSpec().getFPID().getLocation()), fp.getFPID(), (FeatureSpec)spec);
        }
        return null;
    }

    private static void resolveAddressParams(FeatureConfig featureConfig, Map<String, String> address, FeatureAnnotation annotation) {
        List addressParams = annotation.getElementAsList("addr-params");
        List addressParamMappings = annotation.getElementAsList("addr-params-mapping");
        if (addressParamMappings == null || addressParamMappings.isEmpty()) {
            addressParamMappings = addressParams;
        }
        for (int i = 0; i < addressParams.size(); ++i) {
            String value = address.get(addressParams.get(i));
            if (value != null) {
                if ("undefined".equals(value)) {
                    value = "GLN_UNDEFINED";
                }
            } else {
                value = "GLN_UNDEFINED";
            }
            featureConfig.putParam((String)addressParamMappings.get(i), value);
        }
    }

    private static void resolveParams(FeatureConfig featureConfig, Map<String, String> params, FeatureAnnotation annotation) {
        List addressParams = annotation.getElementAsList("op-params");
        List addressParamMappings = annotation.getElementAsList("op-params-mapping");
        if (addressParamMappings == null || addressParamMappings.isEmpty()) {
            addressParamMappings = addressParams;
        }
        for (int i = 0; i < addressParams.size(); ++i) {
            String value = params.get(addressParams.get(i));
            if (value == null) continue;
            featureConfig.putParam((String)addressParamMappings.get(i), value);
        }
    }

    private static class DependencySpec {
        private final String fpName;
        private final FeaturePackLocation.FPID fpid;
        private final FeatureSpec spec;

        DependencySpec(String fpName, FeaturePackLocation.FPID fpid, FeatureSpec spec) {
            this.fpName = fpName;
            this.spec = spec;
            this.fpid = fpid;
        }
    }
}

