/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.integration.common.jms;

import jakarta.jms.Connection;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.Queue;
import jakarta.jms.QueueRequestor;
import jakarta.jms.QueueSession;
import jakarta.jms.Session;
import java.util.Map;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.jms.ActiveMQJMSClient;
import org.apache.activemq.artemis.api.jms.management.JMSManagementHelper;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.test.integration.common.jms.JMSOperations;
import org.jboss.as.test.integration.common.jms.JMSOperationsException;
import org.jboss.as.test.integration.common.jms.JMSOperationsProvider;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public class RemoteActiveMQProviderJMSOperations
implements JMSOperations {
    private final ModelControllerClient client;
    private static final ModelNode subsystemAddress = new ModelNode();
    private static final ModelNode serverAddress;

    public RemoteActiveMQProviderJMSOperations(ModelControllerClient client) {
        this.client = client;
    }

    public RemoteActiveMQProviderJMSOperations(ManagementClient client) {
        this.client = client.getControllerClient();
    }

    @Override
    public ModelControllerClient getControllerClient() {
        return this.client;
    }

    @Override
    public ModelNode getServerAddress() {
        return subsystemAddress.clone();
    }

    @Override
    public ModelNode getSubsystemAddress() {
        return subsystemAddress.clone();
    }

    @Override
    public String getProviderName() {
        return "activemq";
    }

    @Override
    public void createJmsQueue(String queueName, String jndiName) {
        this.createJmsQueue(queueName, jndiName, new ModelNode());
    }

    @Override
    public void createJmsQueue(String queueName, String jndiName, ModelNode attributes) {
        ModelNode address = this.getServerAddress().add("external-jms-queue", queueName);
        attributes.get("entries").add(jndiName);
        this.executeOperation(address, "add", attributes);
        this.createRemoteQueue("jms.queue." + queueName);
    }

    @Override
    public void createJmsTopic(String topicName, String jndiName) {
        this.createJmsTopic(topicName, jndiName, new ModelNode());
    }

    @Override
    public void createJmsTopic(String topicName, String jndiName, ModelNode attributes) {
        ModelNode address = this.getServerAddress().add("external-jms-topic", topicName);
        attributes.get("entries").add(jndiName);
        this.executeOperation(address, "add", attributes);
        this.createRemoteTopic("jms.topic." + topicName);
    }

    @Override
    public void removeJmsQueue(String queueName) {
        ModelNode address = this.getServerAddress().add("external-jms-queue", queueName);
        this.executeOperation(address, "remove", null);
        this.deleteRemoteQueue("jms.queue." + queueName);
    }

    @Override
    public void removeJmsTopic(String topicName) {
        ModelNode address = this.getServerAddress().add("external-jms-topic", topicName);
        this.executeOperation(address, "remove", null);
        this.deleteRemoteTopic("jms.topic." + topicName);
    }

    @Override
    public void addJmsConnectionFactory(String name, String jndiName, ModelNode attributes) {
        ModelNode address = this.getServerAddress().add("connection-factory", name);
        attributes.get("entries").add(jndiName);
        this.executeOperation(address, "add", attributes);
    }

    @Override
    public void removeJmsConnectionFactory(String name) {
        ModelNode address = this.getServerAddress().add("connection-factory", name);
        this.executeOperation(address, "remove", null);
    }

    @Override
    public void addJmsExternalConnectionFactory(String name, String jndiName, ModelNode attributes) {
        ModelNode address = this.getSubsystemAddress().add("connection-factory", name);
        attributes.get("entries").add(jndiName);
        this.executeOperation(address, "add", attributes);
    }

    @Override
    public void removeJmsExternalConnectionFactory(String name) {
        ModelNode address = this.getSubsystemAddress().add("connection-factory", name);
        this.executeOperation(address, "remove", null);
    }

    @Override
    public void addJmsBridge(String name, ModelNode attributes) {
        ModelNode address = new ModelNode();
        address.add("subsystem", "messaging-activemq");
        address.add("jms-bridge", name);
        this.executeOperation(address, "add", attributes);
    }

    @Override
    public void removeJmsBridge(String name) {
        ModelNode address = new ModelNode();
        address.add("subsystem", "messaging-activemq");
        address.add("jms-bridge", name);
        this.executeOperation(address, "remove", null);
    }

    @Override
    public void addCoreBridge(String name, ModelNode attributes) {
        ModelNode address = this.getServerAddress();
        address.add("bridge", name);
        this.executeOperation(address, "add", attributes);
    }

    @Override
    public void removeCoreBridge(String name) {
        ModelNode address = this.getServerAddress();
        address.add("bridge", name);
        this.executeOperation(address, "remove", null);
    }

    @Override
    public void addCoreQueue(String queueName, String queueAddress, boolean durable, String routing) {
        ModelNode address = this.getServerAddress().add("queue", queueName);
        ModelNode attributes = new ModelNode();
        attributes.get("queue-address").set(queueAddress);
        attributes.get("durable").set(durable);
        attributes.get("routing-type").set(routing);
        this.executeOperation(address, "add", attributes);
    }

    @Override
    public void removeCoreQueue(String queueName) {
        ModelNode address = this.getServerAddress().add("queue", queueName);
        this.executeOperation(address, "remove", null);
    }

    @Override
    public void createRemoteAcceptor(String name, String socketBinding, Map<String, String> params) {
        ModelNode model = this.getServerAddress().add("remote-acceptor", name);
        ModelNode attributes = new ModelNode();
        attributes.get("socket-binding").set(socketBinding);
        if (params != null) {
            for (String key : params.keySet()) {
                model.get("params").add(key, params.get(key));
            }
        }
        this.executeOperation(model, "add", attributes);
    }

    @Override
    public void removeRemoteAcceptor(String name) {
        ModelNode model = this.getServerAddress().add("remote-acceptor", name);
        this.executeOperation(model, "remove", null);
    }

    @Override
    public void close() {
    }

    private void executeOperation(ModelNode address, String opName, ModelNode attributes) {
        ModelNode operation = new ModelNode();
        operation.get("operation").set(opName);
        operation.get("address").set(address);
        if (attributes != null) {
            for (Property property : attributes.asPropertyList()) {
                operation.get(property.getName()).set(property.getValue());
            }
        }
        try {
            JMSOperationsProvider.execute(this.client, operation);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setSystemProperties(String destination, String resourceAdapter) {
        ModelNode enableSubstitutionOp = new ModelNode();
        enableSubstitutionOp.get("address").set("subsystem", "ee");
        enableSubstitutionOp.get("operation").set("write-attribute");
        enableSubstitutionOp.get("name").set("annotation-property-replacement");
        enableSubstitutionOp.get("value").set(true);
        ModelNode setDestinationOp = new ModelNode();
        setDestinationOp.get("operation").set("add");
        setDestinationOp.get("address").add("system-property", "destination");
        setDestinationOp.get("value").set(destination);
        ModelNode setResourceAdapterOp = new ModelNode();
        setResourceAdapterOp.get("operation").set("add");
        setResourceAdapterOp.get("address").add("system-property", "resource.adapter");
        setResourceAdapterOp.get("value").set(resourceAdapter);
        try {
            JMSOperationsProvider.execute(this.client, enableSubstitutionOp);
            JMSOperationsProvider.execute(this.client, setDestinationOp);
            JMSOperationsProvider.execute(this.client, setResourceAdapterOp);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void removeSystemProperties() {
        ModelNode removeDestinationOp = new ModelNode();
        removeDestinationOp.get("operation").set("remove");
        removeDestinationOp.get("address").add("system-property", "destination");
        ModelNode removeResourceAdapterOp = new ModelNode();
        removeResourceAdapterOp.get("operation").set("remove");
        removeResourceAdapterOp.get("address").add("system-property", "resource.adapter");
        ModelNode disableSubstitutionOp = new ModelNode();
        disableSubstitutionOp.get("address").set("subsystem", "ee");
        disableSubstitutionOp.get("operation").set("write-attribute");
        disableSubstitutionOp.get("name").set("annotation-property-replacement");
        disableSubstitutionOp.get("value").set(false);
        try {
            JMSOperationsProvider.execute(this.client, removeDestinationOp);
            JMSOperationsProvider.execute(this.client, removeResourceAdapterOp);
            JMSOperationsProvider.execute(this.client, disableSubstitutionOp);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void addHttpConnector(String connectorName, String socketBinding, String endpoint, Map<String, String> parameters) {
        ModelNode address = this.getServerAddress().add("http-connector", connectorName);
        ModelNode attributes = new ModelNode();
        attributes.get("socket-binding").set(socketBinding);
        attributes.get("endpoint").set(endpoint);
        if (parameters != null && parameters.size() > 0) {
            ModelNode params = attributes.get("params").setEmptyList();
            for (Map.Entry<String, String> param : parameters.entrySet()) {
                params.add(param.getKey(), param.getValue());
            }
        }
        this.executeOperation(address, "add", attributes);
    }

    @Override
    public void removeHttpConnector(String connectorName) {
        ModelNode address = this.getServerAddress().add("http-connector", connectorName);
        this.executeOperation(address, "remove", null);
    }

    @Override
    public void addExternalHttpConnector(String connectorName, String socketBinding, String endpoint) {
        ModelNode address = this.getSubsystemAddress().add("http-connector", connectorName);
        ModelNode attributes = new ModelNode();
        attributes.get("socket-binding").set(socketBinding);
        attributes.get("endpoint").set(endpoint);
        this.executeOperation(address, "add", attributes);
    }

    @Override
    public void addExternalRemoteConnector(String name, String socketBinding) {
        ModelNode address = this.getSubsystemAddress().add("remote-connector", name);
        ModelNode attributes = new ModelNode();
        attributes.get("socket-binding").set(socketBinding);
        this.executeOperation(address, "add", attributes);
    }

    @Override
    public void removeExternalHttpConnector(String connectorName) {
        ModelNode address = this.getSubsystemAddress().add("http-connector", connectorName);
        this.executeOperation(address, "remove", null);
    }

    @Override
    public void removeExternalRemoteConnector(String connectorName) {
        ModelNode address = this.getSubsystemAddress().add("remote-connector", connectorName);
        this.executeOperation(address, "remove", null);
    }

    @Override
    public void enableMessagingTraces() {
        ModelNode attributes = new ModelNode();
        attributes.get("level").set("TRACE");
        ModelNode address = PathAddress.parseCLIStyleAddress((String)"/subsystem=logging/logger=org.wildfly.extension.messaging-activemq").toModelNode();
        try {
            this.executeOperation(address, "remove", null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.executeOperation(address, "add", attributes);
        address = PathAddress.parseCLIStyleAddress((String)"/subsystem=logging/logger=org.apache.activemq.artemis").toModelNode();
        try {
            this.executeOperation(address, "remove", null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.executeOperation(address, "add", attributes);
    }

    @Override
    public void createRemoteConnector(String name, String socketBinding, Map<String, String> params) {
        ModelNode address = PathAddress.parseCLIStyleAddress((String)(" /subsystem=messaging-activemq/server=default/remote-connector=" + name)).toModelNode();
        ModelNode attributes = new ModelNode();
        attributes.get("socket-binding").set(socketBinding);
        if (params != null) {
            for (String key : params.keySet()) {
                attributes.get("params").add(key, params.get(key));
            }
        }
        try {
            this.executeOperation(address, "remove", null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.executeOperation(address, "add", attributes);
    }

    @Override
    public void createSocketBinding(String name, String interfaceName, int port) {
        String interfaceValue = interfaceName == null || interfaceName.isEmpty() ? "public" : interfaceName;
        ModelNode address = PathAddress.parseCLIStyleAddress((String)("/socket-binding-group=standard-sockets/socket-binding=" + name)).toModelNode();
        ModelNode attributes = new ModelNode();
        attributes.get("interface").set(interfaceValue);
        attributes.get("port").set(port);
        try {
            this.executeOperation(address, "remove", null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.executeOperation(address, "add", attributes);
    }

    private void createRemoteQueue(String queueName) {
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory("tcp://localhost:61616", "guest", "guest");
        try (Connection connection = cf.createConnection();
             Session session = connection.createSession(false, 1);){
            String body;
            connection.start();
            Queue managementQueue = ActiveMQJMSClient.createQueue((String)"activemq.management");
            QueueRequestor requestor = new QueueRequestor((QueueSession)session, managementQueue);
            Message m = session.createMessage();
            JMSManagementHelper.putOperationInvocation((Message)m, (String)"broker", (String)"createQueue", (Object[])new Object[]{queueName, queueName, true, RoutingType.ANYCAST.name()});
            Message reply = requestor.request(m);
            System.out.println("Creating queue " + queueName + " returned " + reply);
            if (!reply.getBooleanProperty("_AMQ_OperationSucceeded") && !this.destinationAlreadyExist(body = (String)reply.getBody(String.class))) {
                System.out.println("Creation of queue " + queueName + " has failed because of " + body);
            }
        }
        catch (JMSException ex) {
            ex.printStackTrace();
            throw new JMSOperationsException(ex);
        }
        System.out.println("Queue " + queueName + " has been created");
    }

    private void deleteRemoteQueue(String queueName) {
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory("tcp://localhost:61616", "guest", "guest");
        try (Connection connection = cf.createConnection();
             Session session = connection.createSession(false, 1);){
            connection.start();
            Queue managementQueue = ActiveMQJMSClient.createQueue((String)"activemq.management");
            QueueRequestor requestor = new QueueRequestor((QueueSession)session, managementQueue);
            Message m = session.createMessage();
            JMSManagementHelper.putOperationInvocation((Message)m, (String)"broker", (String)"destroyQueue", (Object[])new Object[]{queueName, true, true});
            Message reply = requestor.request(m);
            System.out.println("Deleting queue " + queueName + " returned " + reply);
            if (!reply.getBooleanProperty("_AMQ_OperationSucceeded")) {
                String body = (String)reply.getBody(String.class);
                System.out.println("Deleting of queue " + queueName + " has failed because of " + body);
            }
        }
        catch (JMSException ex) {
            ex.printStackTrace();
            throw new JMSOperationsException(ex);
        }
        System.out.println("Queue " + queueName + " has been deleted");
    }

    private boolean destinationAlreadyExist(String body) {
        return body.contains("AMQ119019") || body.contains("AMQ119018") || body.contains("AMQ229019") || body.contains("AMQ229018");
    }

    private void createRemoteTopic(String topicName) {
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory("tcp://localhost:61616", "guest", "guest");
        try (Connection connection = cf.createConnection();
             Session session = connection.createSession(false, 1);){
            String body;
            connection.start();
            Queue managementQueue = ActiveMQJMSClient.createQueue((String)"activemq.management");
            QueueRequestor requestor = new QueueRequestor((QueueSession)session, managementQueue);
            Message m = session.createMessage();
            JMSManagementHelper.putOperationInvocation((Message)m, (String)"broker", (String)"createAddress", (Object[])new Object[]{topicName, RoutingType.MULTICAST.name()});
            Message reply = requestor.request(m);
            System.out.println("Creating topic " + topicName + " returned " + reply);
            if (!reply.getBooleanProperty("_AMQ_OperationSucceeded") && !this.destinationAlreadyExist(body = (String)reply.getBody(String.class))) {
                System.out.println("Creation of topic " + topicName + " has failed because of " + body);
                throw new JMSOperationsException("Creation of topic " + topicName + " has failed because of " + body);
            }
        }
        catch (JMSException ex) {
            ex.printStackTrace();
            throw new JMSOperationsException(ex);
        }
        System.out.println("Topic " + topicName + " has been created");
    }

    private void deleteRemoteTopic(String topicName) {
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory("tcp://localhost:61616", "guest", "guest");
        try (Connection connection = cf.createConnection();
             Session session = connection.createSession(false, 1);){
            connection.start();
            Queue managementQueue = ActiveMQJMSClient.createQueue((String)"activemq.management");
            QueueRequestor requestor = new QueueRequestor((QueueSession)session, managementQueue);
            Message m = session.createMessage();
            JMSManagementHelper.putOperationInvocation((Message)m, (String)"broker", (String)"deleteAddress", (Object[])new Object[]{topicName, true});
            Message reply = requestor.request(m);
            System.out.println("Deleting topic " + topicName + " returned " + reply);
            if (!reply.getBooleanProperty("_AMQ_OperationSucceeded")) {
                String body = (String)reply.getBody(String.class);
                System.out.println("Deleting of topic " + topicName + " has failed because of " + body);
            }
        }
        catch (JMSException ex) {
            ex.printStackTrace();
            throw new JMSOperationsException(ex);
        }
        System.out.println("Topic " + topicName + " has been deleted");
    }

    @Override
    public boolean isRemoteBroker() {
        return true;
    }

    @Override
    public void disableSecurity() {
        ModelNode operation = new ModelNode();
        operation.get("operation").set("write-attribute");
        operation.get("address").set(this.getServerAddress());
        operation.get("name").set("security-enabled");
        operation.get("value").set(false);
        try {
            JMSOperationsProvider.execute(this.client, operation);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void enableSecurity() {
        ModelNode operation = new ModelNode();
        operation.get("operation").set("write-attribute");
        operation.get("address").set(this.getServerAddress());
        operation.get("name").set("security-enabled");
        operation.get("value").set(true);
        try {
            JMSOperationsProvider.execute(this.client, operation);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        subsystemAddress.add("subsystem", "messaging-activemq");
        serverAddress = new ModelNode();
        serverAddress.add("subsystem", "messaging-activemq");
        serverAddress.add("server", "default");
    }
}

