/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.http.util;

import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.cookie.CommonCookieAttributeHandler;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.cookie.CookieSpec;
import org.apache.http.cookie.CookieSpecProvider;
import org.apache.http.cookie.MalformedCookieException;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.CookieSpecRegistries;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.cookie.BasicDomainHandler;
import org.apache.http.impl.cookie.BasicExpiresHandler;
import org.apache.http.impl.cookie.BasicMaxAgeHandler;
import org.apache.http.impl.cookie.BasicPathHandler;
import org.apache.http.impl.cookie.BasicSecureHandler;
import org.apache.http.impl.cookie.RFC6265CookieSpec;
import org.apache.http.protocol.HttpContext;

public class TestHttpClientUtils {
    public static HttpClient wrapHttpsClient(HttpClient base) {
        try {
            SSLContext ctx = SSLContext.getInstance("TLS");
            X509TrustManager tm = new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] xcs, String string) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] xcs, String string) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }
            };
            ctx.init(null, new TrustManager[]{tm}, null);
            SSLSocketFactory ssf = new SSLSocketFactory(ctx, SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            ClientConnectionManager ccm = base.getConnectionManager();
            SchemeRegistry sr = ccm.getSchemeRegistry();
            sr.register(new Scheme("https", 443, (SchemeSocketFactory)ssf));
            return new DefaultHttpClient(ccm, base.getParams());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static CloseableHttpClient relaxedCookieHttpClient() {
        return TestHttpClientUtils.relaxedCookieHttpClientBuilder().build();
    }

    public static HttpClientBuilder relaxedCookieHttpClientBuilder() {
        HttpClientBuilder builder = HttpClients.custom();
        RegistryBuilder registryBuilder = CookieSpecRegistries.createDefaultBuilder();
        Registry relaxedCookieSpecRegistry = registryBuilder.register("relaxed", (Object)new RelaxedCookieSpecProvider()).build();
        builder.setDefaultCookieSpecRegistry((Lookup)relaxedCookieSpecRegistry);
        RequestConfig requestConfig = RequestConfig.custom().setCookieSpec("relaxed").build();
        builder.setDefaultRequestConfig(requestConfig);
        return builder;
    }

    private static class RelaxedCookieSpec
    extends RFC6265CookieSpec {
        RelaxedCookieSpec(CommonCookieAttributeHandler ... handlers) {
            super(new CommonCookieAttributeHandler[]{new BasicPathHandler(), new BasicDomainHandler(){

                public boolean match(Cookie cookie, CookieOrigin origin) {
                    return true;
                }

                public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
                }
            }, new BasicMaxAgeHandler(), new BasicSecureHandler(), new BasicExpiresHandler(new String[]{"EEE, dd MMM yyyy HH:mm:ss zzz", "EEE, dd-MMM-yy HH:mm:ss zzz", "EEE MMM d HH:mm:ss yyyy"})});
        }
    }

    private static class RelaxedCookieSpecProvider
    implements CookieSpecProvider {
        private RelaxedCookieSpecProvider() {
        }

        public CookieSpec create(HttpContext context) {
            return new RelaxedCookieSpec(new CommonCookieAttributeHandler[0]);
        }
    }
}

