/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.shared.integration.ejb.security;

import java.io.IOException;
import java.util.HashMap;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.jboss.security.ClientLoginModule;

public class Util {
    public static LoginContext getCLMLoginContext(final String username, final String password) throws LoginException {
        String configurationName = "Testing";
        CallbackHandler cbh = new CallbackHandler(){

            @Override
            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                for (Callback current : callbacks) {
                    if (current instanceof NameCallback) {
                        ((NameCallback)current).setName(username);
                        continue;
                    }
                    if (current instanceof PasswordCallback) {
                        ((PasswordCallback)current).setPassword(password.toCharArray());
                        continue;
                    }
                    throw new UnsupportedCallbackException(current);
                }
            }
        };
        Configuration config = new Configuration(){

            @Override
            public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
                if (!"Testing".equals(name)) {
                    throw new IllegalArgumentException("Unexpected configuration name '" + name + "'");
                }
                HashMap<String, String> options = new HashMap<String, String>();
                options.put("multi-threaded", "true");
                options.put("restore-login-identity", "true");
                AppConfigurationEntry clmEntry = new AppConfigurationEntry(ClientLoginModule.class.getName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options);
                return new AppConfigurationEntry[]{clmEntry};
            }
        };
        return new LoginContext("Testing", new Subject(), cbh, config);
    }

    public static String createRemoteEjbJndiContext(String appName, String moduleName, String distinctName, String beanName, String viewClassName, boolean isStateful) {
        return "ejb:" + appName + "/" + moduleName + "/" + distinctName + "/" + beanName + "!" + viewClassName + (isStateful ? "?stateful" : "");
    }

    public static Context createNamingContext() throws NamingException {
        Properties jndiProps = new Properties();
        jndiProps.setProperty("java.naming.factory.url.pkgs", "org.jboss.ejb.client.naming");
        return new InitialContext(jndiProps);
    }
}

