/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.integration.transactions;

import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.jboss.as.test.integration.transactions.TransactionCheckerSingleton;
import org.jboss.logging.Logger;

public class TestXAResource
implements XAResource {
    private static Logger log = Logger.getLogger(TestXAResource.class);
    private TransactionCheckerSingleton checker;
    private int transactionTimeout;
    private int prepareReturnValue = 0;

    public TestXAResource(TransactionCheckerSingleton checker) {
        this.checker = checker;
    }

    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        log.tracef("commit xid:[%s], %s one phase", (Object)xid, (Object)(onePhase ? "with" : "without"));
        this.checker.addCommit();
    }

    @Override
    public void end(Xid xid, int flags) throws XAException {
        log.tracef("end xid:[%s], flag: %s", (Object)xid, (Object)flags);
    }

    @Override
    public void forget(Xid xid) throws XAException {
        log.tracef("forget xid:[%s]", (Object)xid);
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        log.tracef("getTransactionTimeout: returning timeout: %s", this.transactionTimeout);
        return this.transactionTimeout;
    }

    @Override
    public boolean isSameRM(XAResource xares) throws XAException {
        log.tracef("isSameRM returning false to xares: %s", (Object)xares);
        return false;
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        log.tracef("prepare xid: [%s]", (Object)xid);
        this.checker.addPrepare();
        return this.prepareReturnValue;
    }

    @Override
    public Xid[] recover(int flag) throws XAException {
        log.tracef("recover with flags: %s", flag);
        return new Xid[0];
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        log.tracef("rollback xid: [%s]", (Object)xid);
        this.checker.addRollback();
    }

    @Override
    public boolean setTransactionTimeout(int seconds) throws XAException {
        log.tracef("setTransactionTimeout: setting timeout: %s", seconds);
        this.transactionTimeout = seconds;
        return true;
    }

    @Override
    public void start(Xid xid, int flags) throws XAException {
        log.tracef("start xid: [%s], flags: %s", (Object)xid, (Object)flags);
    }
}

