/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.http.util;

import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.cookie.CommonCookieAttributeHandler;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.cookie.CookieSpec;
import org.apache.http.cookie.CookieSpecProvider;
import org.apache.http.cookie.MalformedCookieException;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.CookieSpecRegistries;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.impl.cookie.BasicDomainHandler;
import org.apache.http.impl.cookie.BasicExpiresHandler;
import org.apache.http.impl.cookie.BasicMaxAgeHandler;
import org.apache.http.impl.cookie.BasicPathHandler;
import org.apache.http.impl.cookie.BasicSecureHandler;
import org.apache.http.impl.cookie.RFC6265CookieSpec;
import org.apache.http.protocol.HttpContext;

public class TestHttpClientUtils {
    public static CloseableHttpClient getHttpsClient(CredentialsProvider credentialsProvider) {
        try {
            SSLContext ctx = SSLContext.getInstance("TLS");
            X509TrustManager tm = new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] xcs, String string) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] xcs, String string) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }
            };
            ctx.init(null, new TrustManager[]{tm}, null);
            ctx.init(null, new TrustManager[]{tm}, null);
            SSLConnectionSocketFactory sslConnectionFactory = new SSLConnectionSocketFactory(ctx, (HostnameVerifier)new NoopHostnameVerifier());
            Registry registry = RegistryBuilder.create().register("https", (Object)sslConnectionFactory).build();
            BasicHttpClientConnectionManager ccm = new BasicHttpClientConnectionManager((Lookup)registry);
            HttpClientBuilder builder = HttpClientBuilder.create().setSSLSocketFactory((LayeredConnectionSocketFactory)sslConnectionFactory).setSSLHostnameVerifier((HostnameVerifier)new NoopHostnameVerifier()).setConnectionManager((HttpClientConnectionManager)ccm);
            if (credentialsProvider != null) {
                builder.setDefaultCredentialsProvider(credentialsProvider);
            }
            return builder.build();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static CloseableHttpClient promiscuousCookieHttpClient() {
        return TestHttpClientUtils.promiscuousCookieHttpClientBuilder().build();
    }

    public static HttpClientBuilder promiscuousCookieHttpClientBuilder() {
        HttpClientBuilder builder = HttpClients.custom();
        RegistryBuilder registryBuilder = CookieSpecRegistries.createDefaultBuilder();
        Registry promiscuousCookieSpecRegistry = registryBuilder.register("promiscuous", (Object)new PromiscuousCookieSpecProvider()).build();
        builder.setDefaultCookieSpecRegistry((Lookup)promiscuousCookieSpecRegistry);
        RequestConfig requestConfig = RequestConfig.custom().setCookieSpec("promiscuous").build();
        builder.setDefaultRequestConfig(requestConfig);
        builder.setDefaultCookieStore((CookieStore)new PromiscuousCookieStore());
        return builder;
    }

    private static class PromiscuousCookieStore
    extends BasicCookieStore {
        private PromiscuousCookieStore() {
        }

        public synchronized void addCookie(Cookie cookie) {
            ((BasicClientCookie)cookie).setDomain(null);
            super.addCookie(cookie);
        }
    }

    private static class PromiscuousCookieSpec
    extends RFC6265CookieSpec {
        private PromiscuousCookieSpec() {
            super(new CommonCookieAttributeHandler[]{new BasicPathHandler(), new BasicDomainHandler(){

                public boolean match(Cookie cookie, CookieOrigin origin) {
                    return true;
                }

                public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
                }
            }, new BasicMaxAgeHandler(), new BasicSecureHandler(), new BasicExpiresHandler(new String[]{"EEE, dd MMM yyyy HH:mm:ss zzz", "EEE, dd-MMM-yy HH:mm:ss zzz", "EEE MMM d HH:mm:ss yyyy"})});
        }
    }

    private static class PromiscuousCookieSpecProvider
    implements CookieSpecProvider {
        private PromiscuousCookieSpecProvider() {
        }

        public CookieSpec create(HttpContext context) {
            return new PromiscuousCookieSpec();
        }
    }
}

