/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.integration.common;

import java.util.HashMap;
import java.util.Properties;
import org.jboss.as.test.shared.integration.ejb.security.CallbackHandler;

public class DefaultConfiguration {
    private static final boolean isRemote = Boolean.parseBoolean(System.getProperty("org.jboss.as.test.integration.remote", "false"));
    private static final String MBEAN_USERNAME = System.getProperty("jboss.mbean.username", "testSuite");
    private static final String MBEAN_PASSWORD = System.getProperty("jboss.mbean.username", "testSuitePassword");
    private static final String APPLICATION_USERNAME = System.getProperty("jboss.application.username", "guest");
    private static final String APPLICATION_PASSWORD = System.getProperty("jboss.application.username", "guest");

    public static boolean isRemote() {
        return isRemote;
    }

    public static String applicationUsername() {
        return APPLICATION_USERNAME;
    }

    public static String applicationPassword() {
        return APPLICATION_PASSWORD;
    }

    public static HashMap<String, String[]> credentials() {
        HashMap<String, String[]> propEnv = new HashMap<String, String[]>();
        String[] credentials = new String[]{MBEAN_USERNAME, MBEAN_PASSWORD};
        propEnv.put("jmx.remote.credentials", credentials);
        return DefaultConfiguration.isRemote() ? propEnv : null;
    }

    public static Properties addSecurityProperties(Properties env) {
        if (DefaultConfiguration.isRemote()) {
            env.put("java.naming.security.principal", DefaultConfiguration.applicationUsername());
            env.put("java.naming.security.credentials", DefaultConfiguration.applicationPassword());
        } else {
            env.put("jboss.naming.client.security.callback.handler.class", CallbackHandler.class.getName());
        }
        return env;
    }
}

