/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.integration.security.common;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;
import org.jboss.as.test.integration.security.common.servlets.RolePrintingServlet;
import org.junit.Assert;

public class RolesPrintingServletUtils {
    public static URL prepareRolePrintingUrl(URL webAppURL, String[] allPossibleRoles) {
        ArrayList<BasicNameValuePair> qparams = new ArrayList<BasicNameValuePair>();
        for (String role : allPossibleRoles) {
            qparams.add(new BasicNameValuePair(RolePrintingServlet.PARAM_ROLE_NAME, role));
        }
        String queryRoles = URLEncodedUtils.format(qparams, (String)"UTF-8");
        try {
            return new URL(webAppURL.toExternalForm() + "/printRoles".substring(1) + "?" + queryRoles);
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void assertExpectedRoles(String rolesResponse, String[] allPossibleRoles, String[] expectedAssignedRoles) {
        List<String> assignedRolesList = Arrays.asList(expectedAssignedRoles);
        int checkedRoles = 0;
        for (String role : allPossibleRoles) {
            if (assignedRolesList.contains(role)) {
                RolesPrintingServletUtils.assertInRole(rolesResponse, role);
                ++checkedRoles;
                continue;
            }
            RolesPrintingServletUtils.assertNotInRole(rolesResponse, role);
        }
        if (assignedRolesList.size() != checkedRoles) {
            throw new RuntimeException("There are some roles which have not been checked. It is probably test case issue - you try to check some roles which are missing in all possible roles array.");
        }
    }

    private static void assertInRole(String rolePrintResponse, String role) {
        if (!StringUtils.contains((String)rolePrintResponse, (String)("," + role + ","))) {
            Assert.fail((String)("Missing role '" + role + "' assignment"));
        }
    }

    private static void assertNotInRole(String rolePrintResponse, String role) {
        if (StringUtils.contains((String)rolePrintResponse, (String)("," + role + ","))) {
            Assert.fail((String)("Unexpected role '" + role + "' assignment"));
        }
    }
}

