/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.integration.transactions;

import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.ManagedBean;
import javax.ejb.LocalBean;
import javax.ejb.Remote;
import javax.ejb.Singleton;
import org.jboss.as.test.integration.transactions.TransactionCheckerSingletonRemote;

@Singleton
@LocalBean
@Remote
@ManagedBean
public class TransactionCheckerSingleton
implements TransactionCheckerSingletonRemote {
    private int committed;
    private int prepared;
    private int rolledback;
    private int synchronizedBegin;
    private int synchronizedBefore;
    private int synchronizedAfter;
    private int synchronizedAfterCommitted;
    private int synchronizedAfterRolledBack;
    private Collection<String> messages = new ArrayList<String>();

    @Override
    public int getCommitted() {
        return this.committed;
    }

    @Override
    public void addCommit() {
        ++this.committed;
    }

    @Override
    public int getPrepared() {
        return this.prepared;
    }

    @Override
    public void addPrepare() {
        ++this.prepared;
    }

    @Override
    public int getRolledback() {
        return this.rolledback;
    }

    @Override
    public void addRollback() {
        ++this.rolledback;
    }

    @Override
    public boolean isSynchronizedBefore() {
        return this.synchronizedBefore > 0;
    }

    @Override
    public void setSynchronizedBefore() {
        ++this.synchronizedBefore;
    }

    @Override
    public boolean isSynchronizedAfter() {
        return this.synchronizedAfter > 0;
    }

    @Override
    public void setSynchronizedAfter(boolean isCommit) {
        ++this.synchronizedAfter;
        if (isCommit) {
            ++this.synchronizedAfterCommitted;
        } else {
            ++this.synchronizedAfterRolledBack;
        }
    }

    @Override
    public boolean isSynchronizedBegin() {
        return this.synchronizedBegin > 0;
    }

    @Override
    public void setSynchronizedBegin() {
        ++this.synchronizedBegin;
    }

    @Override
    public void resetCommitted() {
        this.committed = 0;
    }

    @Override
    public void resetPrepared() {
        this.prepared = 0;
    }

    @Override
    public void resetRolledback() {
        this.rolledback = 0;
    }

    @Override
    public void resetSynchronizedBefore() {
        this.synchronizedBefore = 0;
    }

    @Override
    public void resetSynchronizedAfter() {
        this.synchronizedAfter = 0;
        this.synchronizedAfterCommitted = 0;
        this.synchronizedAfterRolledBack = 0;
    }

    @Override
    public void resetSynchronizedBegin() {
        this.synchronizedBegin = 0;
    }

    @Override
    public int countSynchronizedBefore() {
        return this.synchronizedBefore;
    }

    @Override
    public int countSynchronizedAfter() {
        return this.synchronizedAfter;
    }

    @Override
    public int countSynchronizedAfterCommitted() {
        return this.synchronizedAfterCommitted;
    }

    @Override
    public int countSynchronizedAfterRolledBack() {
        return this.synchronizedAfterRolledBack;
    }

    @Override
    public int countSynchronizedBegin() {
        return this.synchronizedBegin;
    }

    @Override
    public void addMessage(String msg) {
        this.messages.add(msg);
    }

    @Override
    public Collection<String> getMessages() {
        return this.messages;
    }

    @Override
    public void resetMessages() {
        this.messages.clear();
    }

    @Override
    public void resetAll() {
        this.resetCommitted();
        this.resetPrepared();
        this.resetRolledback();
        this.resetSynchronizedAfter();
        this.resetSynchronizedBefore();
        this.resetSynchronizedBegin();
        this.resetMessages();
    }
}

