/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.test.security.common.elytron;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.wildfly.test.security.common.elytron.AbstractConfigurableElement;
import org.wildfly.test.security.common.elytron.UserWithRoles;
import org.wildfly.test.security.common.elytron.UsersRolesCapableElement;

public abstract class AbstractUserRolesCapableElement
extends AbstractConfigurableElement
implements UsersRolesCapableElement {
    private final List<UserWithRoles> usersWithRoles;

    protected AbstractUserRolesCapableElement(Builder<?> builder) {
        super(builder);
        this.usersWithRoles = Collections.unmodifiableList(new ArrayList(((Builder)builder).usersWithRoles));
    }

    @Override
    public List<UserWithRoles> getUsersWithRoles() {
        return this.usersWithRoles;
    }

    public static abstract class Builder<T extends Builder<T>>
    extends AbstractConfigurableElement.Builder<T> {
        private List<UserWithRoles> usersWithRoles = new ArrayList<UserWithRoles>();

        protected Builder() {
        }

        public final T withUser(UserWithRoles userWithRoles) {
            this.usersWithRoles.add(Objects.requireNonNull(userWithRoles, "Provided user must not be null."));
            return (T)((Builder)this.self());
        }

        public final T withUser(String username, String password, String ... roles) {
            this.usersWithRoles.add(UserWithRoles.builder().withName(username).withPassword(password).withRoles(roles).build());
            return (T)((Builder)this.self());
        }
    }
}

