/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.test.security.common.elytron;

import org.apache.commons.lang3.StringUtils;
import org.jboss.as.test.integration.management.util.CLIWrapper;
import org.wildfly.test.security.common.elytron.AbstractConfigurableElement;

public class SyslogAuditLog
extends AbstractConfigurableElement {
    private final String format;
    private final String hostName;
    private final Integer port;
    private final String serverAddress;
    private final String sslContext;
    private final String transport;

    private SyslogAuditLog(Builder builder) {
        super(builder);
        this.format = builder.format;
        this.hostName = builder.hostName;
        this.port = builder.port;
        this.serverAddress = builder.serverAddress;
        this.sslContext = builder.sslContext;
        this.transport = builder.transport;
    }

    @Override
    public void create(CLIWrapper cli) throws Exception {
        StringBuilder command = new StringBuilder("/subsystem=elytron/syslog-audit-log=").append(this.name).append(":add(");
        if (StringUtils.isNotBlank((CharSequence)this.format)) {
            command.append("format=\"").append(this.format).append("\", ");
        }
        if (StringUtils.isNotBlank((CharSequence)this.hostName)) {
            command.append("host-name=\"").append(this.hostName).append("\", ");
        }
        if (this.port != null) {
            command.append("port=").append(this.port).append(", ");
        }
        if (StringUtils.isNotBlank((CharSequence)this.serverAddress)) {
            command.append("server-address=\"").append(this.serverAddress).append("\", ");
        }
        if (StringUtils.isNotBlank((CharSequence)this.sslContext)) {
            command.append("ssl-context=\"").append(this.sslContext).append("\", ");
        }
        if (StringUtils.isNotBlank((CharSequence)this.transport)) {
            command.append("transport=\"").append(this.transport).append("\", ");
        }
        command.append(")");
        cli.sendLine(command.toString());
    }

    @Override
    public void remove(CLIWrapper cli) throws Exception {
        cli.sendLine(String.format("/subsystem=elytron/syslog-audit-log=%s:remove()", this.name));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends AbstractConfigurableElement.Builder<Builder> {
        private String format;
        private String hostName;
        private Integer port;
        private String serverAddress;
        private String sslContext;
        private String transport;

        private Builder() {
        }

        public Builder withServerAddress(String serverAddress) {
            this.serverAddress = serverAddress;
            return this;
        }

        public Builder withPort(int port) {
            this.port = port;
            return this;
        }

        public Builder withTransportProtocol(String transport) {
            this.transport = transport;
            return this;
        }

        public Builder withHostName(String hostName) {
            this.hostName = hostName;
            return this;
        }

        public Builder withFormat(String format) {
            this.format = format;
            return this;
        }

        public Builder withSslContext(String sslContext) {
            this.sslContext = sslContext;
            return this;
        }

        public SyslogAuditLog build() {
            return new SyslogAuditLog(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

