/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.test.security.common.elytron;

import java.util.HashSet;
import java.util.Set;
import org.jboss.as.test.integration.management.util.CLIWrapper;
import org.wildfly.test.security.common.elytron.AbstractConfigurableElement;
import org.wildfly.test.security.common.elytron.SecurityDomainMapper;

public class UndertowDomainMapper
extends AbstractConfigurableElement
implements SecurityDomainMapper {
    private final Set<String> applicationDomains;

    private UndertowDomainMapper(Builder builder) {
        super(builder);
        this.applicationDomains = new HashSet<String>(builder.applicationDomains);
    }

    @Override
    public void create(CLIWrapper cli) throws Exception {
        cli.sendLine(String.format("/subsystem=elytron/provider-http-server-mechanism-factory=%s:add()", this.name));
        cli.sendLine(String.format("/subsystem=elytron/http-authentication-factory=%1$s:add(security-domain=%1$s, http-server-mechanism-factory=%1$s,  mechanism-configurations=[    {mechanism-name=DIGEST,mechanism-realm-configurations=[{realm-name=%1$s}]},    {mechanism-name=BASIC,mechanism-realm-configurations=[{realm-name=%1$s}]},    {mechanism-name=FORM}])", this.name));
        if (this.applicationDomains.isEmpty()) {
            cli.sendLine(String.format("/subsystem=undertow/application-security-domain=%1$s:add(http-authentication-factory=%1$s)", this.name));
        } else {
            for (String appDomain : this.applicationDomains) {
                cli.sendLine(String.format("/subsystem=undertow/application-security-domain=%s:add(http-authentication-factory=%s)", appDomain, this.name));
            }
        }
    }

    @Override
    public void remove(CLIWrapper cli) throws Exception {
        if (this.applicationDomains.isEmpty()) {
            cli.sendLine(String.format("/subsystem=undertow/application-security-domain=%s:remove()", this.name));
        } else {
            for (String appDomain : this.applicationDomains) {
                cli.sendLine(String.format("/subsystem=undertow/application-security-domain=%s:remove()", appDomain));
            }
        }
        cli.sendLine(String.format("/subsystem=elytron/http-authentication-factory=%s:remove()", this.name));
        cli.sendLine(String.format("/subsystem=elytron/provider-http-server-mechanism-factory=%s:remove()", this.name));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends AbstractConfigurableElement.Builder<Builder> {
        private Set<String> applicationDomains = new HashSet<String>();

        private Builder() {
        }

        public Builder withApplicationDomains(String ... applicationDomains) {
            if (applicationDomains != null) {
                for (String domain : applicationDomains) {
                    this.applicationDomains.add(domain);
                }
            }
            return this;
        }

        public UndertowDomainMapper build() {
            return new UndertowDomainMapper(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

