/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.test.security.common.elytron;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class UserWithRoles {
    private final String name;
    private final String password;
    private final Set<String> roles;

    private UserWithRoles(Builder builder) {
        this.name = Objects.requireNonNull(builder.name, "Username must be not-null");
        this.password = builder.password != null ? builder.password : builder.name;
        this.roles = new HashSet<String>(builder.roles);
    }

    public String getName() {
        return this.name;
    }

    public String getPassword() {
        return this.password;
    }

    public Set<String> getRoles() {
        return this.roles;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String name;
        private String password;
        private final Set<String> roles = new HashSet<String>();

        private Builder() {
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withPassword(String password) {
            this.password = password;
            return this;
        }

        public Builder withRoles(Set<String> roles) {
            if (roles != null) {
                this.roles.addAll(roles);
            }
            return this;
        }

        public Builder withRoles(String ... roles) {
            if (roles != null) {
                this.roles.addAll(Arrays.asList(roles));
            }
            return this;
        }

        public Builder clearRoles() {
            this.roles.clear();
            return this;
        }

        public UserWithRoles build() {
            return new UserWithRoles(this);
        }
    }
}

