/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.shared;

import java.io.File;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.as.test.shared.ServerReload;
import org.jboss.dmr.ModelNode;
import org.junit.Assert;

public class ServerSnapshot {
    public static AutoCloseable takeSnapshot(final ManagementClient client) {
        try {
            String snapshot;
            ModelNode node = new ModelNode();
            node.get("operation").set("take-snapshot");
            ModelNode result = client.getControllerClient().execute(node);
            if (!"success".equals(result.get("outcome").asString())) {
                Assert.fail((String)("Reload operation didn't finish successfully: " + result.asString()));
            }
            final String fileName = (snapshot = result.get("result").asString()).contains(File.separator) ? snapshot.substring(snapshot.lastIndexOf(File.separator) + 1) : snapshot;
            return new AutoCloseable(){

                @Override
                public void close() throws Exception {
                    ServerReload.executeReloadAndWaitForCompletion(client.getControllerClient(), fileName);
                    ModelNode node = new ModelNode();
                    node.get("operation").set("write-config");
                    ModelNode result = client.getControllerClient().execute(node);
                    if (!"success".equals(result.get("outcome").asString())) {
                        Assert.fail((String)("Failed to write config after restoring from snapshot " + result.asString()));
                    }
                }
            };
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to take snapshot", e);
        }
    }
}

