/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.test.security.common.elytron;

import org.jboss.as.arquillian.api.ServerSetupTask;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.test.shared.ServerReload;
import org.jboss.dmr.ModelNode;
import org.wildfly.test.security.common.elytron.Utils;

public class EjbElytronDomainSetup
implements ServerSetupTask {
    private static final String DEFAULT_SECURITY_DOMAIN_NAME = "elytron-tests";
    private PathAddress saslAuthenticationAddress;
    private PathAddress remotingConnectorAddress;
    private PathAddress ejbDomainAddress;
    private final String securityDomainName;

    public EjbElytronDomainSetup() {
        this(DEFAULT_SECURITY_DOMAIN_NAME);
    }

    public EjbElytronDomainSetup(String securityDomainName) {
        this.securityDomainName = securityDomainName;
    }

    protected String getSecurityDomainName() {
        return this.securityDomainName;
    }

    protected String getSecurityRealmName() {
        return this.getSecurityDomainName() + "-ejb3-UsersRoles";
    }

    protected String getEjbDomainName() {
        return this.getSecurityDomainName();
    }

    protected String getSaslAuthenticationName() {
        return this.getSecurityDomainName();
    }

    protected String getRemotingConnectorName() {
        return "http-remoting-connector";
    }

    public void setup(ManagementClient managementClient, String containerId) throws Exception {
        this.saslAuthenticationAddress = PathAddress.pathAddress((PathElement[])new PathElement[0]).append("subsystem", "elytron").append("sasl-authentication-factory", this.getSaslAuthenticationName());
        this.remotingConnectorAddress = PathAddress.pathAddress((PathElement[])new PathElement[0]).append("subsystem", "remoting").append("http-connector", this.getRemotingConnectorName());
        this.ejbDomainAddress = PathAddress.pathAddress((PathElement[])new PathElement[0]).append("subsystem", "ejb3").append("application-security-domain", this.getEjbDomainName());
        ModelNode compositeOp = new ModelNode();
        compositeOp.get("operation").set("composite");
        compositeOp.get("address").setEmptyList();
        ModelNode steps = compositeOp.get("steps");
        ModelNode addSaslAuthentication = Util.createAddOperation((PathAddress)this.saslAuthenticationAddress);
        addSaslAuthentication.get("sasl-server-factory").set("configured");
        addSaslAuthentication.get("security-domain").set(this.getSecurityDomainName());
        addSaslAuthentication.get("mechanism-configurations").get(0).get("mechanism-name").set("JBOSS-LOCAL-USER");
        addSaslAuthentication.get("mechanism-configurations").get(0).get("realm-mapper").set("local");
        addSaslAuthentication.get("mechanism-configurations").get(1).get("mechanism-name").set("DIGEST-MD5");
        addSaslAuthentication.get("mechanism-configurations").get(1).get("mechanism-realm-configurations").get(0).get("realm-name").set(this.getSecurityRealmName());
        steps.add(addSaslAuthentication);
        ModelNode updateRemotingConnector = Util.getWriteAttributeOperation((PathAddress)this.remotingConnectorAddress, (String)"sasl-authentication-factory", (String)this.getSaslAuthenticationName());
        steps.add(updateRemotingConnector);
        ModelNode addEjbDomain = Util.createAddOperation((PathAddress)this.ejbDomainAddress);
        addEjbDomain.get("security-domain").set(this.getSecurityDomainName());
        steps.add(addEjbDomain);
        Utils.applyUpdate(managementClient.getControllerClient(), compositeOp, false);
        ServerReload.reloadIfRequired(managementClient);
    }

    public void tearDown(ManagementClient managementClient, String containerId) {
        try {
            Utils.applyUpdate(managementClient.getControllerClient(), Util.getWriteAttributeOperation((PathAddress)this.remotingConnectorAddress, (String)"sasl-authentication-factory", (String)"application-sasl-authentication"), false);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Utils.applyRemoveAllowReload(managementClient.getControllerClient(), this.ejbDomainAddress, false);
        try {
            ServerReload.reloadIfRequired(managementClient.getControllerClient());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Utils.applyRemoveAllowReload(managementClient.getControllerClient(), this.saslAuthenticationAddress, false);
    }
}

