/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.test.security.common.elytron;

import java.util.Objects;
import javax.net.ssl.KeyManagerFactory;
import org.apache.commons.lang3.ObjectUtils;
import org.jboss.as.test.integration.management.util.CLIWrapper;
import org.wildfly.test.security.common.elytron.AbstractConfigurableElement;
import org.wildfly.test.security.common.elytron.CredentialReference;
import org.wildfly.test.security.common.elytron.KeyManager;

public class SimpleKeyManager
extends AbstractConfigurableElement
implements KeyManager {
    private final String keyStore;
    private final CredentialReference credentialReference;

    private SimpleKeyManager(Builder builder) {
        super(builder);
        this.keyStore = Objects.requireNonNull(builder.keyStore, "Key-store name has to be provided");
        this.credentialReference = (CredentialReference)ObjectUtils.defaultIfNull((Object)builder.credentialReference, (Object)CredentialReference.EMPTY);
    }

    @Override
    public void create(CLIWrapper cli) throws Exception {
        cli.sendLine(String.format("/subsystem=elytron/key-manager=%s:add(key-store=\"%s\",algorithm=\"%s\", %s)", this.name, this.keyStore, KeyManagerFactory.getDefaultAlgorithm(), this.credentialReference.asString()));
    }

    @Override
    public void remove(CLIWrapper cli) throws Exception {
        cli.sendLine(String.format("/subsystem=elytron/key-manager=%s:remove()", this.name));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends AbstractConfigurableElement.Builder<Builder> {
        private String keyStore;
        private CredentialReference credentialReference;

        private Builder() {
        }

        public Builder withKeyStore(String keyStore) {
            this.keyStore = keyStore;
            return this;
        }

        public Builder withCredentialReference(CredentialReference credentialReference) {
            this.credentialReference = credentialReference;
            return this;
        }

        public SimpleKeyManager build() {
            return new SimpleKeyManager(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

