/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.test.security.servlets;

import java.io.IOException;
import java.io.PrintWriter;
import java.security.Permission;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.evidence.PasswordGuessEvidence;

@WebServlet(value={"/checkIdentityPermission"})
public class CheckIdentityPermissionServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    public static final String SERVLET_PATH = "/checkIdentityPermission";
    public static final String PARAM_USER = "user";
    public static final String PARAM_PASSWORD = "password";
    public static final String PARAM_CLASS = "class";
    public static final String PARAM_TARGET = "target";
    public static final String PARAM_ACTION = "action";

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String className;
        resp.setContentType("text/plain");
        resp.setCharacterEncoding("UTF-8");
        SecurityIdentity si = null;
        String user = req.getParameter(PARAM_USER);
        if (user != null) {
            String password = req.getParameter(PARAM_PASSWORD);
            try {
                si = SecurityDomain.getCurrent().authenticate(user, (Evidence)new PasswordGuessEvidence(password.toCharArray()));
            }
            catch (Exception e) {
                e.printStackTrace();
                resp.sendError(403, e.getMessage());
                return;
            }
        } else {
            si = SecurityDomain.getCurrent().getCurrentSecurityIdentity();
        }
        if ((className = req.getParameter(PARAM_CLASS)) == null) {
            resp.sendError(400, "Parameter class has to be provided");
            return;
        }
        String target = req.getParameter(PARAM_TARGET);
        String action = req.getParameter(PARAM_ACTION);
        Permission perm = null;
        try {
            perm = target == null ? (Permission)Class.forName(className).newInstance() : (action == null ? (Permission)Class.forName(className).getConstructor(String.class).newInstance(target) : (Permission)Class.forName(className).getConstructor(String.class, String.class).newInstance(target, action));
        }
        catch (Exception e) {
            throw new ServletException("Unable to create permission instance", (Throwable)e);
        }
        PrintWriter writer = resp.getWriter();
        writer.print(si.implies(perm));
        writer.close();
    }
}

