/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.test.security.servlets;

import java.io.IOException;
import java.io.PrintWriter;
import java.security.Principal;
import javax.annotation.security.DeclareRoles;
import javax.servlet.ServletException;
import javax.servlet.annotation.HttpConstraint;
import javax.servlet.annotation.ServletSecurity;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@DeclareRoles(value={"JBossAdmin"})
@ServletSecurity(value=@HttpConstraint(rolesAllowed={"JBossAdmin"}))
@WebServlet(value={"/principal"})
public class SecuredPrincipalPrintingServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    public static final String SERVLET_PATH = "/principal";
    public static final String ALLOWED_ROLE = "JBossAdmin";

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setContentType("text/plain");
        resp.setCharacterEncoding("UTF-8");
        Principal userPrincipal = req.getUserPrincipal();
        if (userPrincipal != null) {
            PrintWriter writer = resp.getWriter();
            writer.print(userPrincipal.getName());
            writer.close();
        }
    }
}

