/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.shared;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import org.jboss.as.arquillian.api.ServerSetupTask;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.Operation;
import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.as.test.shared.util.LoggingUtil;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;

public abstract class TestLogHandlerSetupTask
implements ServerSetupTask {
    private final Logger LOGGER = Logger.getLogger(TestLogHandlerSetupTask.class);
    private final Deque<ModelNode> removeOps = new ArrayDeque<ModelNode>();

    public void setup(ManagementClient managementClient, String containerId) throws Exception {
        Operations.CompositeOperationBuilder builder = Operations.CompositeOperationBuilder.create();
        ModelNode handlerAddress = Operations.createAddress((String[])new String[]{"subsystem", "logging", "file-handler", this.getHandlerName()});
        ModelNode addTestLogOp = Operations.createAddOperation((ModelNode)handlerAddress);
        addTestLogOp.get("level").set(this.getLevel());
        addTestLogOp.get("append").set("true");
        ModelNode file = new ModelNode();
        file.get("relative-to").set("jboss.server.log.dir");
        file.get("path").set(this.getLogFileName());
        addTestLogOp.get("file").set(file);
        addTestLogOp.get("formatter").set("%-5p [%c] (%t) %s%e%n");
        builder.addStep(addTestLogOp);
        this.removeOps.add(Operations.createRemoveOperation((ModelNode)handlerAddress));
        Collection<String> categories = this.getCategories();
        if (categories == null || categories.isEmpty()) {
            this.LOGGER.warn((Object)"getCategories() returned empty collection.");
            return;
        }
        for (String category : categories) {
            if (category == null || category.isEmpty()) {
                this.LOGGER.warn((Object)"Empty category name provided.");
                continue;
            }
            ModelNode loggerAddress = Operations.createAddress((String[])new String[]{"subsystem", "logging", "logger", category});
            ModelNode op = Operations.createAddOperation((ModelNode)loggerAddress);
            op.get("level").set(this.getLevel());
            op.get("handlers").add(this.getHandlerName());
            builder.addStep(op);
            this.removeOps.addFirst(Operations.createRemoveOperation((ModelNode)loggerAddress));
        }
        this.applyUpdate(managementClient.getControllerClient(), builder.build(), false);
    }

    public void tearDown(ManagementClient managementClient, String containerId) throws Exception {
        ModelNode removeOp;
        Path logPath = LoggingUtil.getLogPath(managementClient, "file-handler", this.getHandlerName());
        Operations.CompositeOperationBuilder builder = Operations.CompositeOperationBuilder.create();
        while ((removeOp = this.removeOps.pollFirst()) != null) {
            builder.addStep(removeOp);
        }
        this.applyUpdate(managementClient.getControllerClient(), builder.build(), false);
        Files.deleteIfExists(logPath);
    }

    public abstract Collection<String> getCategories();

    public abstract String getLevel();

    public abstract String getHandlerName();

    public abstract String getLogFileName();

    protected void applyUpdate(ModelControllerClient client, ModelNode update, boolean allowFailure) throws IOException {
        this.applyUpdate(client, Operation.Factory.create((ModelNode)update), allowFailure);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void applyUpdate(ModelControllerClient client, Operation update, boolean allowFailure) throws IOException {
        ModelNode result = client.execute(update);
        if (!Operations.isSuccessfulOutcome((ModelNode)result)) {
            if (!allowFailure) throw new RuntimeException("Failed to configure logger: " + Operations.getFailureDescription((ModelNode)result).asString());
            this.LOGGER.tracef("Failed to configure logger: %s", (Object)Operations.getFailureDescription((ModelNode)result).asString());
            return;
        } else {
            this.LOGGER.trace((Object)Operations.readResult((ModelNode)result).asString());
        }
    }
}

