/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.integration.security.common;

import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.test.integration.security.common.CoreUtils;
import org.jboss.as.test.integration.security.common.config.DataSource;
import org.jboss.as.test.shared.ServerReload;
import org.jboss.as.test.shared.SnapshotRestoreSetupTask;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;

public abstract class AbstractDataSourceServerSetupTask
extends SnapshotRestoreSetupTask {
    private static final Logger LOGGER = Logger.getLogger(AbstractDataSourceServerSetupTask.class);
    private static final String SUBSYSTEM_DATASOURCES = "datasources";
    private static final String DATASOURCE = "data-source";

    @Override
    public final void doSetup(ManagementClient managementClient, String containerId) throws Exception {
        DataSource[] dataSourceConfigurations = this.getDataSourceConfigurations(managementClient, containerId);
        if (dataSourceConfigurations == null) {
            LOGGER.warn((Object)"Null DataSourceConfiguration array provided");
            return;
        }
        ArrayList<ModelNode> updates = new ArrayList<ModelNode>();
        for (DataSource config : dataSourceConfigurations) {
            String name = config.getName();
            LOGGER.trace((Object)("Adding datasource " + name));
            ModelNode dsNode = new ModelNode();
            dsNode.get("operation").set("add");
            dsNode.get("address").add("subsystem", SUBSYSTEM_DATASOURCES);
            dsNode.get("address").add(DATASOURCE, name);
            dsNode.get("connection-url").set(config.getConnectionUrl());
            dsNode.get("jndi-name").set(config.getJndiName());
            dsNode.get("driver-name").set(config.getDriver());
            dsNode.get("enabled").set("false");
            if (StringUtils.isNotEmpty((CharSequence)config.getUsername())) {
                dsNode.get("user-name").set(config.getUsername());
            }
            if (StringUtils.isNotEmpty((CharSequence)config.getPassword())) {
                dsNode.get("password").set(config.getPassword());
            }
            updates.add(dsNode);
            ModelNode enableNode = new ModelNode();
            enableNode.get("name").set("enabled");
            enableNode.get("value").set(true);
            enableNode.get("operation").set("write-attribute");
            enableNode.get("address").add("subsystem", SUBSYSTEM_DATASOURCES);
            enableNode.get("address").add(DATASOURCE, name);
            updates.add(enableNode);
        }
        CoreUtils.applyUpdates(updates, (ModelControllerClient)managementClient.getControllerClient());
        ServerReload.executeReloadAndWaitForCompletion(managementClient, 50000);
    }

    protected DataSource[] getDataSourceConfigurations(ManagementClient managementClient, String containerId) {
        return null;
    }
}

