/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.integration.common.jms;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.test.integration.common.jms.JMSOperations;
import org.jboss.as.test.integration.common.jms.JMSOperationsException;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;

public class JMSOperationsProvider {
    private static final Logger logger = Logger.getLogger(JMSOperationsProvider.class);
    private static final String PROPERTY_NAME = "jmsoperations.implementation.class";
    private static final String FILE_NAME = "jmsoperations.properties";

    @Deprecated
    public static JMSOperations getInstance(ManagementClient client) {
        Object jmsOperationsInstance;
        String className = System.getProperty(PROPERTY_NAME);
        if (className == null) {
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            InputStream stream = tccl.getResourceAsStream(FILE_NAME);
            Properties propsFromFile = new Properties();
            try {
                propsFromFile.load(stream);
                className = propsFromFile.getProperty(PROPERTY_NAME);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        if (className == null) {
            throw new JMSOperationsException("Please specify a property jmsoperations.implementation.class in jmsoperations.properties");
        }
        try {
            Class<?> clazz = Class.forName(className);
            jmsOperationsInstance = clazz.getConstructor(ManagementClient.class).newInstance(client);
        }
        catch (Exception e) {
            throw new JMSOperationsException(e);
        }
        if (!(jmsOperationsInstance instanceof JMSOperations)) {
            throw new JMSOperationsException("Class " + className + " does not implement interface JMSOperations");
        }
        return (JMSOperations)jmsOperationsInstance;
    }

    public static JMSOperations getInstance(ModelControllerClient client) {
        Object jmsOperationsInstance;
        String className = System.getProperty(PROPERTY_NAME);
        if (className == null) {
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            InputStream stream = tccl.getResourceAsStream(FILE_NAME);
            Properties propsFromFile = new Properties();
            try {
                propsFromFile.load(stream);
                className = propsFromFile.getProperty(PROPERTY_NAME);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        if (className == null) {
            throw new JMSOperationsException("Please specify a property jmsoperations.implementation.class in jmsoperations.properties");
        }
        try {
            Class<?> clazz = Class.forName(className);
            jmsOperationsInstance = clazz.getConstructor(ModelControllerClient.class).newInstance(client);
        }
        catch (Exception e) {
            throw new JMSOperationsException(e);
        }
        if (!(jmsOperationsInstance instanceof JMSOperations)) {
            throw new JMSOperationsException("Class " + className + " does not implement interface JMSOperations");
        }
        return (JMSOperations)jmsOperationsInstance;
    }

    static void execute(ManagementClient managementClient, ModelNode operation) throws IOException, JMSOperationsException {
        JMSOperationsProvider.execute(managementClient.getControllerClient(), operation);
    }

    static void execute(ModelControllerClient client, ModelNode operation) throws IOException, JMSOperationsException {
        ModelNode result = client.execute(operation);
        if (!result.hasDefined("outcome") || !"success".equals(result.get("outcome").asString())) {
            if (result.hasDefined("failure-description")) {
                String failureDesc = result.get("failure-description").toString();
                throw new JMSOperationsException(failureDesc);
            }
            throw new JMSOperationsException("Operation not successful; outcome = " + result.get("outcome"));
        }
        logger.trace((Object)("Operation successful for update = " + operation.toString()));
    }
}

