/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.integration.transactions.spi;

import com.arjuna.ats.arjuna.recovery.RecoveryManager;
import com.arjuna.ats.arjuna.recovery.RecoveryModule;
import com.arjuna.ats.internal.jta.recovery.arjunacore.XARecoveryModule;
import com.arjuna.ats.jta.recovery.XAResourceRecoveryHelper;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.EJB;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.transaction.xa.XAResource;
import org.jboss.as.test.integration.transactions.PersistentTestXAResource;
import org.jboss.as.test.integration.transactions.TestXAResource;
import org.jboss.as.test.integration.transactions.TransactionCheckerSingleton;
import org.jboss.logging.Logger;

@Singleton
@Startup
public class TestXAResourceRecoveryHelper
implements XAResourceRecoveryHelper {
    private static final Logger log = Logger.getLogger(TestXAResourceRecoveryHelper.class);
    private TestXAResource testXaResourceInstance;
    private TestXAResource persistentTestXaResourceInstance;
    @EJB
    private TransactionCheckerSingleton transactionCheckerSingleton;

    @PostConstruct
    public void postConstruct() {
        log.debug((Object)"TestXAResourceRecoveryHelper starting");
        this.testXaResourceInstance = new TestXAResource(this.transactionCheckerSingleton);
        this.persistentTestXaResourceInstance = new PersistentTestXAResource(this.transactionCheckerSingleton);
        this.getRecoveryModule().addXAResourceRecoveryHelper((XAResourceRecoveryHelper)this);
    }

    @PreDestroy
    public void preDestroy() {
        log.debug((Object)"TestXAResourceRecoveryHelper stopping");
        this.getRecoveryModule().removeXAResourceRecoveryHelper((XAResourceRecoveryHelper)this);
    }

    public boolean initialise(String param) throws Exception {
        return true;
    }

    public XAResource[] getXAResources() throws Exception {
        log.debugf("getXAResources() instances: %s and %s", (Object)this.testXaResourceInstance, (Object)this.persistentTestXaResourceInstance);
        return new XAResource[]{this.testXaResourceInstance, this.persistentTestXaResourceInstance};
    }

    private XARecoveryModule getRecoveryModule() {
        for (RecoveryModule recoveryModule : RecoveryManager.manager().getModules()) {
            if (!(recoveryModule instanceof XARecoveryModule)) continue;
            return (XARecoveryModule)recoveryModule;
        }
        throw new IllegalStateException("Cannot find XARecoveryModule which is necessary for recovery initialization of the test XAResources");
    }
}

