/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.shared.util;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.function.Supplier;
import org.junit.Assume;
import org.junit.AssumptionViolatedException;
import org.testcontainers.DockerClientFactory;

public class AssumeTestGroupUtil {
    public static void assumeSecurityManagerDisabled() {
        AssumeTestGroupUtil.assumeCondition("Tests failing if the security manager is enabled.", () -> System.getProperty("security.manager") == null);
    }

    public static void assumeSecurityManagerDisabledOrAssumeJDKVersionBefore(int javaSpecificationVersion) {
        AssumeTestGroupUtil.assumeCondition("Tests failing if the security manager is enabled and JDK in use is after " + javaSpecificationVersion + ".", () -> System.getProperty("security.manager") == null || AssumeTestGroupUtil.getJavaSpecificationVersion() < javaSpecificationVersion);
    }

    public static void assumeJDKVersionAfter(int javaSpecificationVersion) {
        assert (javaSpecificationVersion >= 8);
        AssumeTestGroupUtil.assumeCondition("Tests failing if the JDK in use is before " + javaSpecificationVersion + ".", () -> AssumeTestGroupUtil.getJavaSpecificationVersion() > javaSpecificationVersion);
    }

    public static void assumeJDKVersionBefore(int javaSpecificationVersion) {
        assert (javaSpecificationVersion >= 9);
        AssumeTestGroupUtil.assumeCondition("Tests failing if the JDK in use is after " + javaSpecificationVersion + ".", () -> AssumeTestGroupUtil.getJavaSpecificationVersion() < javaSpecificationVersion);
    }

    public static void assumeFullDistribution() {
        AssumeTestGroupUtil.assumeCondition("Tests requiring full distribution are disabled", () -> System.getProperty("testsuite.default.build.project.prefix", "").equals(""));
    }

    public static void assumeDockerAvailable() {
        try {
            DockerClientFactory.instance().client();
        }
        catch (Throwable ex) {
            throw new AssumptionViolatedException("Docker is not available.");
        }
    }

    public static void assumeNotWildFlyPreview() {
        Assume.assumeTrue((String)"Some tests are disabled on WildFly Preview", (System.getProperty("ts.ee9") == null && System.getProperty("ts.bootable.ee9") == null ? 1 : 0) != 0);
    }

    private static int getJavaSpecificationVersion() {
        String versionString = System.getProperty("java.specification.version");
        return Integer.parseInt(versionString);
    }

    private static void assumeCondition(final String message, final Supplier<Boolean> assumeTrueCondition) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                Assume.assumeTrue((String)message, (boolean)((Boolean)assumeTrueCondition.get()));
                return null;
            }
        });
    }
}

