/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.shared.integration.ejb.security;

import java.util.Properties;
import java.util.concurrent.Callable;
import javax.ejb.EJBAccessException;
import javax.ejb.EJBException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.junit.Assert;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.evidence.PasswordGuessEvidence;

public class Util {
    public static String createRemoteEjbJndiContext(String appName, String moduleName, String distinctName, String beanName, String viewClassName, boolean isStateful) {
        return "ejb:" + appName + "/" + moduleName + "/" + distinctName + "/" + beanName + "!" + viewClassName + (isStateful ? "?stateful" : "");
    }

    public static Context createNamingContext() throws NamingException {
        Properties jndiProps = new Properties();
        jndiProps.setProperty("java.naming.factory.url.pkgs", "org.jboss.ejb.client.naming");
        return new InitialContext(jndiProps);
    }

    public static <T> T switchIdentity(String username, String password, Callable<T> callable) throws Exception {
        return Util.switchIdentity(username, password, callable, false);
    }

    public static <T> T switchIdentity(String username, String password, Callable<T> callable, ClassLoader classLoader) throws Exception {
        return Util.switchIdentity(username, password, callable, false, classLoader);
    }

    public static <T> T switchIdentity(String username, String password, Callable<T> callable, boolean validateException) throws Exception {
        return Util.switchIdentity(username, password, callable, validateException, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T switchIdentity(String username, String password, Callable<T> callable, boolean validateException, ClassLoader classLoader) throws Exception {
        boolean initialAuthSucceeded = false;
        try {
            if (username != null && password != null) {
                SecurityDomain securityDomain;
                if (classLoader != null) {
                    ClassLoader current = Thread.currentThread().getContextClassLoader();
                    try {
                        Thread.currentThread().setContextClassLoader(classLoader);
                        securityDomain = SecurityDomain.getCurrent();
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(current);
                    }
                } else {
                    securityDomain = SecurityDomain.getCurrent();
                }
                if (securityDomain != null) {
                    SecurityIdentity securityIdentity = securityDomain.authenticate(username, (Evidence)new PasswordGuessEvidence(password.toCharArray()));
                    initialAuthSucceeded = true;
                    return (T)securityIdentity.runAs(callable);
                }
                throw new IllegalStateException("Legacy security is no longer supported.");
            }
            return callable.call();
        }
        catch (Exception e) {
            if (!validateException) {
                throw e;
            }
            Util.validateException(e, initialAuthSucceeded);
            return null;
        }
    }

    private static void validateException(Exception e, boolean initialAuthSucceeded) {
        if (SecurityDomain.getCurrent() != null) {
            if (initialAuthSucceeded) {
                Assert.assertTrue((String)"Expected EJBException due to bad password not thrown.", (e instanceof EJBException && e.getCause() instanceof SecurityException ? 1 : 0) != 0);
            } else {
                Assert.assertTrue((String)"Expected SecurityException due to bad password not thrown.", (boolean)(e instanceof SecurityException));
            }
        } else {
            Assert.assertTrue((String)"Expected EJBAccessException due to bad password not thrown. (EJB 3.1 FR 17.6.9)", (boolean)(e instanceof EJBAccessException));
        }
    }

    public static <T> T switchIdentitySCF(String username, String password, Callable<T> callable) throws Exception {
        return Util.switchIdentity(username, password, callable, false);
    }
}

