/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.integration.logging.syslogserver;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateException;
import javax.net.ServerSocketFactory;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.io.IOUtils;
import org.jboss.as.test.integration.logging.syslogserver.TCPSyslogServer;
import org.jboss.logging.Logger;
import org.productivity.java.syslog4j.SyslogRuntimeException;
import org.productivity.java.syslog4j.server.impl.net.tcp.ssl.SSLTCPNetSyslogServerConfigIF;

public class TLSSyslogServer
extends TCPSyslogServer {
    private static final Logger LOGGER = Logger.getLogger(TLSSyslogServer.class);
    private static final String BC_PROVIDER = "BC";
    private SSLContext sslContext;
    private Provider providerToRestore;

    public void initialize() throws SyslogRuntimeException {
        super.initialize();
        this.providerToRestore = this.removeBouncyCastle();
        SSLTCPNetSyslogServerConfigIF config = (SSLTCPNetSyslogServerConfigIF)this.tcpNetSyslogServerConfig;
        try {
            char[] keystorePwd = config.getKeyStorePassword().toCharArray();
            KeyStore keystore = TLSSyslogServer.loadKeyStore(config.getKeyStore(), keystorePwd);
            char[] truststorePassword = config.getTrustStorePassword().toCharArray();
            KeyStore truststore = TLSSyslogServer.loadKeyStore(config.getTrustStore(), truststorePassword);
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keystore, keystorePwd);
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(truststore);
            this.sslContext = SSLContext.getInstance("TLS");
            this.sslContext.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), null);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Exception occurred during SSLContext for TLS syslog server initialization", (Throwable)e);
            throw new SyslogRuntimeException((Throwable)e);
        }
    }

    protected ServerSocketFactory getServerSocketFactory() throws IOException {
        return this.sslContext.getServerSocketFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KeyStore loadKeyStore(String keystoreFile, char[] keystorePwd) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        KeyStore keystore = KeyStore.getInstance("JKS");
        FileInputStream is = null;
        try {
            is = new FileInputStream(keystoreFile);
            keystore.load(is, keystorePwd);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(is);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)is);
        return keystore;
    }

    public synchronized void shutdown() {
        super.shutdown();
        this.restoreProvider(this.providerToRestore);
        this.providerToRestore = null;
    }

    public Provider removeBouncyCastle() {
        try {
            Provider removed = Security.getProvider(BC_PROVIDER);
            if (removed != null) {
                Security.removeProvider(BC_PROVIDER);
            }
            return removed;
        }
        catch (SecurityException ex) {
            LOGGER.warn((Object)"Cannot deregister BouncyCastleProvider", (Throwable)ex);
            return null;
        }
    }

    private void restoreProvider(Provider toRestore) {
        try {
            if (toRestore != null) {
                Security.addProvider(toRestore);
            }
        }
        catch (SecurityException ex) {
            LOGGER.warn((Object)"Cannot register BouncyCastleProvider", (Throwable)ex);
        }
    }
}

