/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.integration.management.base;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.arquillian.container.test.api.ContainerController;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.test.integration.domain.management.util.DomainTestUtils;
import org.jboss.as.test.integration.management.util.MgmtOperationException;
import org.jboss.as.test.shared.ServerReload;
import org.jboss.as.test.shared.TestSuiteEnvironment;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;
import org.jboss.dmr.ValueExpression;
import org.jboss.logging.Logger;
import org.junit.Assert;

public abstract class AbstractExpressionSupportTestCase {
    private static final Logger LOGGER = Logger.getLogger(AbstractExpressionSupportTestCase.class);
    private static final Set<ModelType> COMPLEX_TYPES = Collections.unmodifiableSet(EnumSet.of(ModelType.LIST, ModelType.OBJECT, ModelType.PROPERTY));
    private final boolean immediateValidation = Boolean.getBoolean("immediate.expression.validation");
    private final boolean logHandling = Boolean.getBoolean("expression.logging");
    @ArquillianResource
    protected ContainerController container;
    private int conflicts;
    private int noSimple;
    private int noSimpleCollection;
    private int noComplexList;
    private int noObject;
    private int noComplexProperty;
    private int supportedUndefined;
    private int simple;
    private int simpleCollection;
    private int complexList;
    private int object;
    private int complexProperty;
    private ManagementClient managementClient;

    protected static ManagementClient createManagementClient() {
        return new ManagementClient(TestSuiteEnvironment.getModelControllerClient(), TestSuiteEnvironment.formatPossibleIpv6Address((String)TestSuiteEnvironment.getServerAddress()), TestSuiteEnvironment.getServerPort(), "remote+http");
    }

    public void test(ManagementClient managementClient) throws Exception {
        this.managementClient = managementClient;
        this.complexList = 0;
        this.complexProperty = 0;
        this.object = 0;
        this.simpleCollection = 0;
        this.simple = 0;
        this.supportedUndefined = 0;
        this.noComplexProperty = 0;
        this.noObject = 0;
        this.noComplexProperty = 0;
        this.noComplexList = 0;
        this.noSimpleCollection = 0;
        this.noSimple = 0;
        this.conflicts = 0;
        HashMap<PathAddress, Map<String, ModelNode>> expectedValues = new HashMap<PathAddress, Map<String, ModelNode>>();
        this.setExpressions(PathAddress.EMPTY_ADDRESS, expectedValues);
        LOGGER.debug((Object)"Update statistics:");
        LOGGER.debug((Object)"==================");
        LOGGER.debug((Object)("conflicts: " + this.conflicts));
        LOGGER.debug((Object)("no expression simple: " + this.noSimple));
        LOGGER.debug((Object)("no expression simple collection: " + this.noSimpleCollection));
        LOGGER.debug((Object)("no expression complex list: " + this.noComplexList));
        LOGGER.debug((Object)("no expression object: " + this.noObject));
        LOGGER.debug((Object)("no expression complex property: " + this.noComplexProperty));
        LOGGER.debug((Object)("supported but undefined: " + this.supportedUndefined));
        LOGGER.debug((Object)("simple: " + this.simple));
        LOGGER.debug((Object)("simple collection: " + this.simpleCollection));
        LOGGER.debug((Object)("complex list: " + this.complexList));
        LOGGER.debug((Object)("object: " + this.object));
        LOGGER.debug((Object)("complex property: " + this.complexProperty));
        this.restartContainer();
        this.validateExpectedValues(PathAddress.EMPTY_ADDRESS, expectedValues);
    }

    protected void restartContainer() {
        ServerReload.executeReloadAndWaitForCompletion(this.managementClient);
    }

    private void setExpressions(PathAddress address, Map<PathAddress, Map<String, ModelNode>> expectedValues) throws IOException, MgmtOperationException {
        ModelNode description = this.readResourceDescription(address);
        ModelNode resource = this.readResource(address, true, false);
        ModelNode resourceNoDefaults = this.readResource(address, false, false);
        HashMap<String, ModelNode> expressionAttrs = new HashMap<String, ModelNode>();
        HashMap<String, ModelNode> otherAttrs = new HashMap<String, ModelNode>();
        HashMap<String, ModelNode> expectedAttrs = new HashMap<String, ModelNode>();
        this.organizeAttributes(address, description, resource, resourceNoDefaults, expressionAttrs, otherAttrs, expectedAttrs);
        for (Map.Entry entry : expressionAttrs.entrySet()) {
            this.writeAttribute(address, (String)entry.getKey(), (ModelNode)entry.getValue());
        }
        for (Map.Entry entry : otherAttrs.entrySet()) {
            this.writeAttribute(address, (String)entry.getKey(), (ModelNode)entry.getValue());
        }
        if (expectedAttrs.size() > 0 && this.immediateValidation) {
            ModelNode modifiedResource = this.readResource(address, true, true);
            for (Map.Entry entry : expectedAttrs.entrySet()) {
                ModelNode expectedValue = (ModelNode)entry.getValue();
                ModelNode modVal = modifiedResource.get((String)entry.getKey());
                this.validateAttributeValue(address, (String)entry.getKey(), expectedValue, modVal);
            }
        }
        expectedValues.put(address, expectedAttrs);
        for (Property property : description.get("children").asPropertyList()) {
            String string = property.getName();
            List<String> children = this.readChildrenNames(address, string);
            for (String child : children) {
                this.setExpressions(address.append(new PathElement[]{PathElement.pathElement((String)string, (String)child)}), expectedValues);
            }
        }
    }

    private void organizeAttributes(PathAddress address, ModelNode description, ModelNode resource, ModelNode resourceNoDefaults, Map<String, ModelNode> expressionAttrs, Map<String, ModelNode> otherAttrs, Map<String, ModelNode> expectedAttrs) {
        ModelNode attributeDescriptions = description.get("attributes");
        for (Property descProp : attributeDescriptions.asPropertyList()) {
            ModelNode attrDesc;
            String attrName = descProp.getName();
            if (this.isAttributeExcluded(address, attrName, attrDesc = descProp.getValue(), resourceNoDefaults)) continue;
            ModelNode noDefaultValue = resourceNoDefaults.get(attrName);
            if (!noDefaultValue.isDefined()) {
                ModelNode node2;
                HashSet<String> base = new HashSet<String>();
                base.add(attrName);
                if (attrDesc.hasDefined("requires")) {
                    for (ModelNode node2 : attrDesc.get("requires").asList()) {
                        base.add(node2.asString());
                    }
                }
                boolean conflict = false;
                node2 = base.iterator();
                block2: while (node2.hasNext()) {
                    String baseAttr = (String)node2.next();
                    if (!resource.hasDefined(baseAttr)) {
                        conflict = true;
                        break;
                    }
                    ModelNode baseAttrAlts = attributeDescriptions.get(new String[]{baseAttr, "alternatives"});
                    if (!baseAttrAlts.isDefined()) continue;
                    for (ModelNode alt : baseAttrAlts.asList()) {
                        String altName = alt.asString();
                        if (!resourceNoDefaults.hasDefined(alt.asString()) && !expressionAttrs.containsKey(altName) && !otherAttrs.containsKey(altName)) continue;
                        conflict = true;
                        continue block2;
                    }
                }
                if (conflict) {
                    ++this.conflicts;
                    this.logHandling("Skipping conflicted attribute " + attrName + " at " + address.toModelNode().asString());
                    continue;
                }
            }
            ModelNode attrValue = resource.get(attrName);
            ModelType attrType = attrValue.getType();
            if (attrDesc.get("expressions-allowed").asBoolean(false)) {
                if (attrType != ModelType.UNDEFINED && attrType != ModelType.EXPRESSION) {
                    if (COMPLEX_TYPES.contains(attrType)) {
                        ModelNode valueType = attrDesc.get("value-type");
                        if (valueType.getType() == ModelType.TYPE) {
                            this.handleSimpleCollection(address, attrName, attrValue, valueType.asType(), expressionAttrs, otherAttrs, expectedAttrs);
                            continue;
                        }
                        if (valueType.isDefined()) {
                            this.handleComplexCollection(address, attrName, attrValue, attrType, valueType, expressionAttrs, otherAttrs, expectedAttrs);
                            continue;
                        }
                        ++this.noSimple;
                        this.logNoExpressions(address, attrName);
                        otherAttrs.put(attrName, attrValue);
                        expectedAttrs.put(attrName, attrValue);
                        continue;
                    }
                    if (attrType == ModelType.STRING) {
                        this.checkForUnconvertedExpression(address, attrName, attrValue);
                    }
                    String expression = "${exp.test:" + attrValue.asString() + "}";
                    expressionAttrs.put(attrName, new ModelNode(expression));
                    expectedAttrs.put(attrName, new ModelNode().set(new ValueExpression(expression)));
                    ++this.simple;
                    this.logHandling("Added expression to simple attribute " + attrName + " at " + address.toModelNode().asString());
                    continue;
                }
                if (attrType != ModelType.EXPRESSION) {
                    ++this.supportedUndefined;
                    this.logHandling("Expression supported but value undefined on simple attribute " + attrName + " at " + address.toModelNode().asString());
                } else {
                    ++this.simple;
                    this.logHandling("Already found an expression on simple attribute " + attrName + " at " + address.toModelNode().asString());
                }
                otherAttrs.put(attrName, attrValue);
                expectedAttrs.put(attrName, attrValue);
                continue;
            }
            if (COMPLEX_TYPES.contains(attrType) && attrDesc.get("value-type").getType() != ModelType.TYPE && attrDesc.get("value-type").isDefined()) {
                this.handleComplexCollection(address, attrName, attrValue, attrType, attrDesc.get("value-type"), expressionAttrs, otherAttrs, expectedAttrs);
                continue;
            }
            ++this.noSimple;
            this.logNoExpressions(address, attrName);
            otherAttrs.put(attrName, attrValue);
            expectedAttrs.put(attrName, attrValue);
        }
    }

    private boolean isAttributeExcluded(PathAddress address, String attrName, ModelNode attrDesc, ModelNode resourceNoDefaults) {
        if (!attrDesc.get("access-type").isDefined() || !attrDesc.get("access-type").asString().equalsIgnoreCase("read-write")) {
            return true;
        }
        if (attrDesc.get("storage").isDefined() && !attrDesc.get("storage").asString().equalsIgnoreCase("configuration")) {
            return true;
        }
        if (attrDesc.get("deprecated").isDefined()) {
            return true;
        }
        if ("default-web-module".equals(attrName)) {
            PathElement subPe;
            if (address.size() > 1 && "subsystem".equals((subPe = address.getElement(0)).getKey()) && "web".equals(subPe.getValue()) && "virtual-server".equals(address.getLastElement().getKey())) {
                return true;
            }
        } else if ("policy-modules".equals(attrName) || "login-modules".equals(attrName)) {
            PathElement subPe;
            if (address.size() > 2 && "subsystem".equals((subPe = address.getElement(0)).getKey()) && "security".equals(subPe.getValue()) && "security-domain".equals(address.getElement(1).getKey())) {
                return true;
            }
        } else if ("virtual-nodes".equals(attrName)) {
            if (address.size() == 3) {
                PathElement subPe = address.getElement(0);
                PathElement containerPe = address.getElement(1);
                PathElement distPe = address.getElement(2);
                if ("subsystem".equals(subPe.getKey()) && "infinispan".equals(subPe.getValue()) && "cache-container".equals(containerPe.getKey()) && "distributed-cache".equals(distPe.getKey())) {
                    return true;
                }
            }
        } else if (address.size() > 0 && "transactions".equals(address.getLastElement().getValue()) && "subsystem".equals(address.getLastElement().getKey())) {
            if (attrName.contains("jdbc")) {
                return !resourceNoDefaults.hasDefined("use-jdbc-store") || !resourceNoDefaults.get("use-jdbc-store").asBoolean();
            }
            if (attrName.contains("journal")) {
                return !resourceNoDefaults.hasDefined("use-journal-store") || !resourceNoDefaults.get("use-journal-store").asBoolean();
            }
        } else if ("security-application".equals(attrName)) {
            if (address.size() == 3) {
                PathElement subPe = address.getElement(0);
                PathElement raPe = address.getElement(1);
                PathElement connPe = address.getElement(2);
                if ("subsystem".equals(subPe.getKey()) && "resource-adapters".equals(subPe.getValue()) && "resource-adapter".equals(raPe.getKey()) && "connection-definitions".equals(connPe.getKey())) {
                    return true;
                }
            }
        } else if (attrName.startsWith("wm-security")) {
            if (address.size() == 2) {
                PathElement subPe = address.getElement(0);
                PathElement raPe = address.getElement(1);
                if ("subsystem".equals(subPe.getKey()) && "resource-adapters".equals(subPe.getValue()) && "resource-adapter".equals(raPe.getKey())) {
                    return true;
                }
            }
        } else if ("transaction-support".equals(attrName)) {
            if (address.size() == 2) {
                PathElement subPe = address.getElement(0);
                PathElement raPe = address.getElement(1);
                if ("subsystem".equals(subPe.getKey()) && "resource-adapters".equals(subPe.getValue()) && "resource-adapter".equals(raPe.getKey())) {
                    return true;
                }
            }
        } else if ("pool-fair".equals(attrName) || "pad-xid".equals(attrName) || "interleaving".equals(attrName) || "no-tx-separate-pool".equals(attrName) || "wrap-xa-resource".equals(attrName)) {
            if (address.size() == 3) {
                PathElement subPe = address.getElement(0);
                PathElement raPe = address.getElement(1);
                PathElement connPe = address.getElement(2);
                if ("subsystem".equals(subPe.getKey()) && "resource-adapters".equals(subPe.getValue()) && "resource-adapter".equals(raPe.getKey()) && "connection-definitions".equals(connPe.getKey())) {
                    return true;
                }
            }
        } else if ("fixed-source-port".equals(attrName)) {
            if (address.size() == 2) {
                PathElement socketBindingGroupPe = address.getElement(0);
                PathElement remoteDestPe = address.getElement(1);
                if ("socket-binding-group".equals(socketBindingGroupPe.getKey()) && "remote-destination-outbound-socket-binding".equals(remoteDestPe.getKey())) {
                    return true;
                }
            }
        } else if ("console-enabled".equals(attrName)) {
            if (address.size() == 2) {
                PathElement coreServicePe = address.getElement(0);
                PathElement mngmtIfPe = address.getElement(1);
                if ("core-service".equals(coreServicePe.getKey()) && "management".equals(coreServicePe.getValue()) && "management-interface".equals(mngmtIfPe.getKey()) && "http-interface".equals(mngmtIfPe.getValue())) {
                    return true;
                }
            }
        } else if ("async-registration".equals(attrName)) {
            PathElement coreServicePe;
            if (address.size() > 0 && "subsystem".equals((coreServicePe = address.getElement(0)).getKey()) && "xts".equals(coreServicePe.getValue())) {
                return true;
            }
        } else if ("path".equals(attrName) && address.size() == 1 && "path".equals(address.getElement(0).getKey())) {
            try {
                return this.readAttribute(address, "read-only").asBoolean();
            }
            catch (IOException | MgmtOperationException e) {
                throw new RuntimeException(e);
            }
        }
        return false;
    }

    private void logNoExpressions(PathAddress address, String attrName) {
        if (this.logHandling) {
            this.logHandling("No expression support for attribute " + attrName + " at " + address.toModelNode().asString());
        }
    }

    private void logHandling(String msg) {
        if (this.logHandling) {
            LOGGER.info((Object)msg);
        }
    }

    private void handleSimpleCollection(PathAddress address, String attrName, ModelNode attrValue, ModelType valueType, Map<String, ModelNode> expressionAttrs, Map<String, ModelNode> otherAttrs, Map<String, ModelNode> expectedAttrs) {
        if (COMPLEX_TYPES.contains(valueType)) {
            ++this.noSimpleCollection;
            this.logNoExpressions(address, attrName);
            otherAttrs.put(attrName, attrValue);
        } else {
            boolean hasExpression = false;
            ModelNode updated = new ModelNode();
            ModelNode expected = new ModelNode();
            for (ModelNode item : attrValue.asList()) {
                ModelType itemType = item.getType();
                if (itemType == ModelType.PROPERTY) {
                    Property prop = item.asProperty();
                    ModelNode propVal = prop.getValue();
                    ModelType propValType = propVal.getType();
                    if (propVal.isDefined() && propValType != ModelType.EXPRESSION) {
                        if (propValType == ModelType.STRING) {
                            this.checkForUnconvertedExpression(address, attrName, propVal);
                        }
                        String expression = "${exp.test:" + propVal.asString() + "}";
                        updated.get(prop.getName()).set(expression);
                        expected.get(prop.getName()).set(new ModelNode().set(new ValueExpression(expression)));
                        hasExpression = true;
                        continue;
                    }
                    updated.get(prop.getName()).set(propVal);
                    expected.get(prop.getName()).set(propVal);
                    continue;
                }
                if (item.isDefined() && itemType != ModelType.EXPRESSION) {
                    if (itemType == ModelType.STRING) {
                        this.checkForUnconvertedExpression(address, attrName, item);
                    }
                    String expression = "${exp.test:" + item.asString() + "}";
                    updated.add(expression);
                    expected.add(new ModelNode().set(new ValueExpression(expression)));
                    hasExpression = true;
                    continue;
                }
                updated.add(item);
                expected.add(item);
            }
            if (hasExpression) {
                ++this.simpleCollection;
                this.logHandling("Added expression to SIMPLE " + attrValue.getType() + " attribute " + attrName + " at " + address.toModelNode().asString());
                expressionAttrs.put(attrName, updated);
                expectedAttrs.put(attrName, expected);
            } else {
                ++this.noSimpleCollection;
                this.logNoExpressions(address, attrName);
                otherAttrs.put(attrName, attrValue);
                expectedAttrs.put(attrName, attrValue);
            }
        }
    }

    private void handleComplexCollection(PathAddress address, String attrName, ModelNode attrValue, ModelType attrType, ModelNode valueTypeDesc, Map<String, ModelNode> expressionAttrs, Map<String, ModelNode> otherAttrs, Map<String, ModelNode> expectedAttrs) {
        switch (attrType) {
            case LIST: {
                this.handleComplexList(address, attrName, attrValue, valueTypeDesc, expressionAttrs, otherAttrs, expectedAttrs);
                break;
            }
            case OBJECT: {
                this.handleComplexObject(address, attrName, attrValue, valueTypeDesc, expressionAttrs, otherAttrs, expectedAttrs);
                break;
            }
            case PROPERTY: {
                this.handleComplexProperty(address, attrName, attrValue, valueTypeDesc, expressionAttrs, otherAttrs, expectedAttrs);
                break;
            }
            default: {
                throw new IllegalArgumentException(attrType.toString());
            }
        }
    }

    private void handleComplexList(PathAddress address, String attrName, ModelNode attrValue, ModelNode valueTypeDesc, Map<String, ModelNode> expressionAttrs, Map<String, ModelNode> otherAttrs, Map<String, ModelNode> expectedAttrs) {
        ModelNode updatedList = new ModelNode().setEmptyList();
        ModelNode expectedList = new ModelNode().setEmptyList();
        boolean changed = false;
        for (ModelNode item : attrValue.asList()) {
            ModelNode updated = new ModelNode();
            ModelNode toExpect = new ModelNode();
            this.handleComplexItem(address, attrName, item, valueTypeDesc, updated, toExpect);
            changed |= !updated.equals(item);
            updatedList.add(updated);
            expectedList.add(toExpect);
        }
        if (changed) {
            ++this.complexList;
            this.logHandling("Added expression to COMPLEX LIST attribute " + attrName + " at " + address.toModelNode().asString());
            expressionAttrs.put(attrName, updatedList);
            expectedAttrs.put(attrName, expectedList);
        } else {
            ++this.noComplexList;
            this.logNoExpressions(address, attrName);
            otherAttrs.put(attrName, attrValue);
        }
    }

    private void handleComplexObject(PathAddress address, String attrName, ModelNode attrValue, ModelNode valueTypeDesc, Map<String, ModelNode> expressionAttrs, Map<String, ModelNode> otherAttrs, Map<String, ModelNode> expectedAttrs) {
        ModelNode updated = new ModelNode();
        ModelNode toExpect = new ModelNode();
        this.handleComplexItem(address, attrName, attrValue, valueTypeDesc, updated, toExpect);
        if (!updated.equals(attrValue)) {
            ++this.object;
            this.logHandling("Added expression to OBJECT attribute " + attrName + " at " + address.toModelNode().asString());
            expressionAttrs.put(attrName, updated);
            expectedAttrs.put(attrName, toExpect);
        } else {
            ++this.noObject;
            this.logNoExpressions(address, attrName);
            otherAttrs.put(attrName, attrValue);
        }
    }

    private void handleComplexProperty(PathAddress address, String attrName, ModelNode attrValue, ModelNode valueTypeDesc, Map<String, ModelNode> expressionAttrs, Map<String, ModelNode> otherAttrs, Map<String, ModelNode> expectedAttrs) {
        Property prop = attrValue.asProperty();
        ModelNode propVal = prop.getValue();
        ModelNode updatedPropVal = new ModelNode();
        ModelNode propValToExpect = new ModelNode();
        this.handleComplexItem(address, attrName, propVal, valueTypeDesc, updatedPropVal, propValToExpect);
        if (!updatedPropVal.equals(propVal)) {
            ++this.complexProperty;
            ModelNode updatedProp = new ModelNode().set(prop.getName(), updatedPropVal);
            this.logHandling("Added expression to COMPLEX PROPERTY attribute " + attrName + " at " + address.toModelNode().asString());
            expressionAttrs.put(attrName, updatedProp);
            expectedAttrs.put(attrName, new ModelNode().set(prop.getName(), propValToExpect));
        } else {
            ++this.noComplexProperty;
            this.logNoExpressions(address, attrName);
            otherAttrs.put(attrName, attrValue);
        }
    }

    private void handleComplexItem(PathAddress address, String attrName, ModelNode item, ModelNode valueTypeDesc, ModelNode updatedItem, ModelNode itemToExpect) {
        Set keys = valueTypeDesc.keys();
        boolean timeAttr = keys.size() == 2 && keys.contains("time") && keys.contains("unit");
        boolean changed = false;
        for (Property fieldProp : valueTypeDesc.asPropertyList()) {
            String fieldName = fieldProp.getName();
            if (!item.has(fieldName)) continue;
            boolean timeunit = timeAttr && "unit".equals(fieldName);
            ModelNode fieldDesc = fieldProp.getValue();
            ModelNode fieldValue = item.get(fieldName);
            ModelType valueType = fieldValue.getType();
            if (valueType == ModelType.UNDEFINED || valueType == ModelType.EXPRESSION || COMPLEX_TYPES.contains(valueType) || !fieldDesc.get("expressions-allowed").asBoolean(false)) {
                updatedItem.get(fieldName).set(fieldValue);
                itemToExpect.get(fieldName).set(fieldValue);
                continue;
            }
            if (valueType == ModelType.STRING) {
                this.checkForUnconvertedExpression(address, attrName, item);
            }
            String valueString = timeunit ? fieldValue.asString().toLowerCase() : fieldValue.asString();
            String expression = "${exp.test:" + valueString + "}";
            updatedItem.get(fieldName).set(expression);
            itemToExpect.get(fieldName).set(new ModelNode().set(new ValueExpression(expression)));
            changed = true;
        }
        if (!changed) {
            updatedItem.set(item);
            itemToExpect.set(item);
        }
    }

    private ModelNode readResourceDescription(PathAddress address) throws IOException, MgmtOperationException {
        ModelNode op = DomainTestUtils.createOperation((String)"read-resource-description", (PathAddress)address);
        return DomainTestUtils.executeForResult((ModelNode)op, (ModelControllerClient)this.managementClient.getControllerClient());
    }

    private ModelNode readResource(PathAddress address, boolean defaults, boolean failIfMissing) throws IOException, MgmtOperationException {
        try {
            ModelNode op = DomainTestUtils.createOperation((String)"read-resource", (PathAddress)address);
            op.get("include-defaults").set(defaults);
            return DomainTestUtils.executeForResult((ModelNode)op, (ModelControllerClient)this.managementClient.getControllerClient());
        }
        catch (MgmtOperationException e) {
            if (failIfMissing) {
                throw e;
            }
            return new ModelNode();
        }
    }

    private void checkForUnconvertedExpression(PathAddress address, String attrName, ModelNode attrValue) {
        String text = attrValue.asString();
        int start = text.indexOf("${");
        if (start > -1 && text.indexOf("}") > start) {
            Assert.fail((String)(address + " attribute " + attrName + " is storing an unconverted expression: " + text));
        }
    }

    private void writeAttribute(PathAddress address, String attrName, ModelNode value) throws IOException, MgmtOperationException {
        ModelNode op = DomainTestUtils.createOperation((String)"write-attribute", (PathAddress)address);
        op.get("name").set(attrName);
        op.get("value").set(value);
        DomainTestUtils.executeForResult((ModelNode)op, (ModelControllerClient)this.managementClient.getControllerClient());
    }

    private ModelNode readAttribute(PathAddress address, String attrName) throws IOException, MgmtOperationException {
        ModelNode op = DomainTestUtils.createOperation((String)"read-attribute", (PathAddress)address);
        op.get("name").set(attrName);
        return DomainTestUtils.executeForResult((ModelNode)op, (ModelControllerClient)this.managementClient.getControllerClient());
    }

    private List<String> readChildrenNames(PathAddress address, String childType) throws IOException, MgmtOperationException {
        ModelNode op = DomainTestUtils.createOperation((String)"read-children-names", (PathAddress)address);
        op.get("child-type").set(childType);
        ModelNode opResult = DomainTestUtils.executeForResult((ModelNode)op, (ModelControllerClient)this.managementClient.getControllerClient());
        ArrayList<String> result = new ArrayList<String>();
        for (ModelNode child : opResult.asList()) {
            result.add(child.asString());
        }
        return result;
    }

    private void validateExpectedValues(PathAddress address, Map<PathAddress, Map<String, ModelNode>> expectedValues) throws IOException, MgmtOperationException {
        Map<String, ModelNode> expectedModel = expectedValues.get(address);
        if (expectedModel != null && this.isValidatable(address)) {
            ModelNode resource = this.readResource(address, true, true);
            for (Map.Entry entry : expectedModel.entrySet()) {
                String attrName = (String)entry.getKey();
                ModelNode expectedValue = (ModelNode)entry.getValue();
                ModelNode modVal = resource.get((String)entry.getKey());
                this.validateAttributeValue(address, attrName, expectedValue, modVal);
            }
        }
        ModelNode description = this.readResourceDescription(address);
        for (Property property : description.get("children").asPropertyList()) {
            String childType = property.getName();
            List<String> children = this.readChildrenNames(address, childType);
            for (String child : children) {
                this.validateExpectedValues(address.append(new PathElement[]{PathElement.pathElement((String)childType, (String)child)}), expectedValues);
            }
        }
    }

    private void validateAttributeValue(PathAddress address, String attrName, ModelNode expectedValue, ModelNode modelValue) {
        switch (expectedValue.getType()) {
            case EXPRESSION: {
                Assert.assertEquals((String)(address + " attribute " + attrName + " value " + modelValue + " is an unconverted expression"), (Object)expectedValue, (Object)modelValue);
                break;
            }
            case INT: 
            case LONG: {
                Assert.assertTrue((String)(address + " attribute " + attrName + " is a valid type"), (modelValue.getType() == ModelType.INT || modelValue.getType() == ModelType.LONG ? 1 : 0) != 0);
                Assert.assertEquals((String)(address + " -- " + attrName), (long)expectedValue.asLong(), (long)modelValue.asLong());
                break;
            }
            default: {
                Assert.assertEquals((String)(address + " -- " + attrName), (Object)expectedValue, (Object)modelValue);
            }
        }
    }

    private boolean isValidatable(PathAddress address) {
        boolean result = true;
        if (address.size() > 1 && address.getLastElement().getKey().equals("bootstrap-context") && address.getLastElement().getValue().equals("default") && address.getElement(address.size() - 2).getKey().equals("subsystem") && address.getElement(address.size() - 2).getValue().equals("jca")) {
            result = false;
        }
        return result;
    }
}

