/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.shared;

import java.io.File;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.jboss.as.test.layers.LayersTest;
import org.jboss.as.test.shared.util.AssumeTestGroupUtil;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class LayersTestBase {
    private static final String[] NOT_USED_COMMON = new String[]{"ibm.jdk", "javax.api", "javax.sql.api", "javax.xml.stream.api", "sun.jdk", "sun.scripting", "org.jboss.as.clustering.jgroups", "org.wildfly.extension.datasources-agroal", "io.agroal", "org.wildfly.extension.picketlink", "org.jboss.as.jsr77", "org.keycloak.keycloak-adapter-subsystem", "org.jboss.as.security", "org.wildfly.security.http.sfbasic", "org.eclipse.persistence", "org.jboss.genericjms", "org.jboss.as.appclient", "org.jboss.metadata.appclient", "org.bouncycastle", "org.jboss.resteasy.resteasy-rxjava2", "org.jboss.resteasy.resteasy-tracing-api", "org.wildfly.security.jakarta.client.resteasy", "org.wildfly.security.jakarta.client.webservices", "org.jboss.resteasy.microprofile.config", "org.apache.activemq.artemis.protocol.amqp", "org.apache.qpid.proton", "org.apache.activemq.artemis.protocol.hornetq", "org.apache.activemq.artemis.protocol.stomp", "org.hornetq.client", "org.wildfly.extension.rts", "org.jboss.narayana.rts", "org.jboss.as.xts", "org.wildfly.extension.elytron-oidc-client", "org.wildfly.security.elytron-http-oidc", "org.wildfly.security.elytron-jose-jwk", "org.wildfly.security.elytron-jose-util", "org.wildfly.reactive.dep.jts", "org.wildfly.event.logger", "org.wildfly.extension.opentelemetry", "org.wildfly.extension.opentelemetry-api", "io.opentelemetry.exporter", "io.opentelemetry.sdk", "io.opentelemetry.proto", "io.opentelemetry.otlp", "io.opentelemetry.trace", "io.micrometer", "org.wildfly.extension.micrometer", "org.wildfly.micrometer.deployment", "com.squareup.okhttp3", "org.jetbrains.kotlin.kotlin-stdlib", "com.google.protobuf", "org.infinispan.cdi.common", "org.infinispan.cdi.embedded", "org.infinispan.cdi.remote", "org.infinispan.counter", "org.infinispan.lock", "org.infinispan.query", "org.infinispan.query.core", "org.jgroups.aws", "software.amazon.awssdk.s3", "org.wildfly.extension.microprofile.metrics-smallrye", "org.wildfly.extension.microprofile.opentracing-smallrye", "org.apache.xerces"};
    private static final String[] NOT_USED;
    private static final String[] NOT_REFERENCED_COMMON;
    private static final String[] NOT_REFERENCED;
    private static final HashMap<String, List<String>> BANNED_MODULES_CONF;
    public static String root;
    public static String defaultConfigsRoot;

    @BeforeClass
    public static void setUp() {
        root = System.getProperty("layers.install.root");
        defaultConfigsRoot = System.getProperty("std.default.install.root");
    }

    @AfterClass
    public static void cleanUp() {
        Boolean delete = Boolean.getBoolean("layers.delete.installations");
        if (delete.booleanValue()) {
            File[] installations;
            for (File f : installations = new File(root).listFiles(File::isDirectory)) {
                LayersTest.recursiveDelete((Path)f.toPath());
            }
            for (File f : installations = new File(defaultConfigsRoot).listFiles(File::isDirectory)) {
                LayersTest.recursiveDelete((Path)f.toPath());
            }
        }
    }

    @Test
    public void test() throws Exception {
        LayersTest.test((String)root, new HashSet<String>(Arrays.asList(NOT_REFERENCED)), new HashSet<String>(Arrays.asList(NOT_USED)));
    }

    @Test
    public void checkBannedModules() throws Exception {
        HashMap results = LayersTest.checkBannedModules((String)root, BANNED_MODULES_CONF);
        Assert.assertTrue((String)("The following banned modules were provisioned " + results.toString()), (boolean)results.isEmpty());
    }

    @Test
    public void testDefaultConfigs() throws Exception {
        LayersTest.testExecution((String)defaultConfigsRoot);
    }

    static {
        NOT_REFERENCED_COMMON = new String[]{"org.eclipse.yasson", "org.wildfly.naming", "org.jboss.resteasy.resteasy-json-binding-provider", "org.jboss.as.console", "org.jboss.as.domain-add-user", "org.jboss.as.domain-http-error-context", "org.jboss.as.jsf-injection", "org.jboss.as.product", "org.jboss.as.standalone", "org.jboss.logging.jul-to-slf4j-stub", "org.jboss.resteasy.resteasy-client-microprofile", "org.jboss.ws.tools.common", "org.jboss.ws.tools.wsconsume", "org.jboss.ws.tools.wsprovide", "gnu.getopt", "org.wildfly.security.elytron-tool", "org.wildfly.bootable-jar", "org.wildfly.extension.clustering.singleton", "org.wildfly.extension.microprofile.health-smallrye", "org.eclipse.microprofile.health.api", "io.smallrye.health", "org.wildfly.extension.microprofile.lra-coordinator", "org.wildfly.extension.microprofile.lra-participant", "org.jboss.narayana.rts.lra-coordinator", "org.jboss.narayana.rts.lra-participant", "org.eclipse.microprofile.lra.api", "org.wildfly.extension.microprofile.openapi-smallrye", "org.eclipse.microprofile.openapi.api", "io.smallrye.openapi", "com.fasterxml.jackson.dataformat.jackson-dataformat-yaml", "org.wildfly.extension.microprofile.reactive-messaging-smallrye", "org.wildfly.extension.microprofile.telemetry", "org.wildfly.extension.microprofile.reactive-streams-operators-smallrye", "org.wildfly.reactive.mutiny.reactive-streams-operators.cdi-provider", "io.vertx.client", "org.wildfly.security.jakarta.security", "org.jboss.as.system-jmx", "org.jboss.ws.saaj-impl", "org.jboss.ws.cxf.sts"};
        BANNED_MODULES_CONF = new HashMap<String, List<String>>(){
            {
                this.put("org.jboss.as.security", Arrays.asList("test-all-layers-jpa-distributed", "test-all-layers", "legacy-security", "test-standalone-reference"));
            }
        };
        if (AssumeTestGroupUtil.isWildFlyPreview()) {
            NOT_USED = (String[])ArrayUtils.addAll((Object[])NOT_USED_COMMON, (Object[])new String[]{"org.wildfly.extension.metrics", "io.smallrye.fault-tolerance", "org.eclipse.microprofile.fault-tolerance.api", "org.wildfly.extension.microprofile.fault-tolerance-smallrye", "org.wildfly.microprofile.fault-tolerance-smallrye.deployment", "org.hibernate.search.mapper.orm.coordination.outboxpolling"});
            NOT_REFERENCED = (String[])ArrayUtils.addAll((Object[])NOT_REFERENCED_COMMON, (Object[])new String[]{"org.wildfly.extension.metrics", "org.hibernate.search.mapper.orm.coordination.outboxpolling", "org.apache.avro"});
        } else {
            NOT_USED = (String[])ArrayUtils.addAll((Object[])NOT_USED_COMMON, (Object[])new String[]{"org.jboss.xnio.netty.netty-xnio-transport", "org.jboss.as.patching", "org.jboss.as.patching.cli", "org.jboss.as.jpa.hibernate:4", "org.hibernate:5.0", "org.hibernate.jipijapa-hibernate5", "org.jboss.as.jpa.openjpa", "org.apache.openjpa", "javax.management.j2ee.api"});
            NOT_REFERENCED = (String[])ArrayUtils.addAll((Object[])NOT_REFERENCED_COMMON, (Object[])new String[]{"org.wildfly.extension.microprofile.fault-tolerance-smallrye", "io.jaegertracing", "io.netty.netty-codec-dns", "io.netty.netty-codec-http2", "io.netty.netty-resolver-dns", "io.reactivex.rxjava2.rxjava", "io.smallrye.common.vertx-context", "io.smallrye.reactive.messaging", "io.smallrye.reactive.messaging.connector", "io.smallrye.reactive.messaging.connector.kafka", "io.smallrye.reactive.messaging.connector.kafka.api", "io.smallrye.reactive.mutiny", "io.smallrye.reactive.mutiny.reactive-streams-operators", "io.smallrye.reactive.mutiny.vertx-core", "io.smallrye.reactive.mutiny.vertx-kafka-client", "io.smallrye.reactive.mutiny.vertx-runtime", "io.vertx.client.kafka", "io.vertx.core", "org.apache.kafka.client", "org.eclipse.microprofile.reactive-messaging.api", "org.eclipse.microprofile.reactive-streams-operators.api", "org.eclipse.microprofile.reactive-streams-operators.core", "org.wildfly.reactive.messaging.common", "org.wildfly.reactive.messaging.config", "org.wildfly.reactive.messaging.kafka", "org.apache.logging.log4j.api", "org.jboss.logmanager.log4j2", "javax.json.bind.api", "org.hibernate.search.orm", "org.hibernate.search.backend.elasticsearch", "org.hibernate.search.backend.lucene", "org.elasticsearch.client.rest-client", "com.google.code.gson", "com.carrotsearch.hppc", "org.apache.lucene", "wildflyee.api"});
        }
    }
}

