/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.shared.integration.ejb.security;

import java.io.File;
import java.io.FilePermission;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Iterator;

public final class PermissionUtils {
    public static FilePermission createFilePermission(String action, String ... paths) {
        return PermissionUtils.createFilePermission(action, "jboss.inst", Arrays.asList(paths));
    }

    public static FilePermission createFilePermission(String action, String sysPropKey, Iterable<String> paths) {
        String prop = System.getProperty(sysPropKey);
        if (prop == null) {
            throw new IllegalArgumentException(String.format("Could not find the system property %s", sysPropKey));
        }
        Path base = Paths.get(prop, new String[0]);
        if (Files.notExists(base, new LinkOption[0])) {
            throw new RuntimeException(String.format("The system property %s resolved to %s which does not exist.", sysPropKey, base));
        }
        if (!Files.isDirectory(base, new LinkOption[0])) {
            throw new RuntimeException(String.format("The system property %s resolved to %s which is not a directory.", sysPropKey, base));
        }
        StringBuilder path = new StringBuilder(256).append(base.toAbsolutePath().normalize()).append(File.separatorChar);
        Iterator<String> iter = paths.iterator();
        while (iter.hasNext()) {
            path.append(iter.next());
            if (!iter.hasNext()) continue;
            path.append(File.separatorChar);
        }
        return new FilePermission(path.toString(), action);
    }
}

