/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.test.security.servlets;

import jakarta.annotation.security.DeclareRoles;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.HttpConstraint;
import jakarta.servlet.annotation.ServletSecurity;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.Principal;

@DeclareRoles(value={"JBossAdmin"})
@ServletSecurity(value=@HttpConstraint(rolesAllowed={"JBossAdmin"}))
@WebServlet(value={"/principal"})
public class SecuredPrincipalPrintingServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    public static final String SERVLET_PATH = "/principal";
    public static final String ALLOWED_ROLE = "JBossAdmin";

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setContentType("text/plain");
        resp.setCharacterEncoding("UTF-8");
        Principal userPrincipal = req.getUserPrincipal();
        if (userPrincipal != null) {
            PrintWriter writer = resp.getWriter();
            writer.print(userPrincipal.getName());
            writer.close();
        }
    }
}

