/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.shared.observability.setuptasks;

import org.jboss.arquillian.testcontainers.api.DockerRequired;
import org.jboss.arquillian.testcontainers.api.Testcontainer;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.as.test.shared.ServerReload;
import org.jboss.as.test.shared.observability.containers.OpenTelemetryCollectorContainer;
import org.jboss.as.test.shared.observability.setuptasks.AbstractSetupTask;
import org.jboss.dmr.ModelNode;
import org.junit.AssumptionViolatedException;

@DockerRequired(value=AssumptionViolatedException.class)
public class MicrometerSetupTask
extends AbstractSetupTask {
    private static final ModelNode micrometerExtension = Operations.createAddress((String[])new String[]{"extension", "org.wildfly.extension.micrometer"});
    private static final ModelNode micrometerSubsystem = Operations.createAddress((String[])new String[]{"subsystem", "micrometer"});
    @Testcontainer
    private OpenTelemetryCollectorContainer otelCollector;

    public void setup(ManagementClient managementClient, String containerId) throws Exception {
        this.executeOp(managementClient, this.writeAttribute("undertow", "statistics-enabled", "true"));
        if (!Operations.isSuccessfulOutcome((ModelNode)this.executeRead(managementClient, micrometerExtension))) {
            this.executeOp(managementClient, Operations.createAddOperation((ModelNode)micrometerExtension));
        }
        if (!Operations.isSuccessfulOutcome((ModelNode)this.executeRead(managementClient, micrometerSubsystem))) {
            ModelNode addOp = Operations.createAddOperation((ModelNode)micrometerSubsystem);
            addOp.get("endpoint").set(this.otelCollector.getOtlpHttpEndpoint() + "/v1/metrics");
            this.executeOp(managementClient, addOp);
        }
        this.executeOp(managementClient, this.writeAttribute("micrometer", "endpoint", this.otelCollector.getOtlpHttpEndpoint() + "/v1/metrics"));
        this.executeOp(managementClient, this.writeAttribute("micrometer", "step", "1"));
        ServerReload.reloadIfRequired(managementClient);
    }

    public void tearDown(ManagementClient managementClient, String containerId) throws Exception {
        this.otelCollector.stop();
        this.executeOp(managementClient, this.clearAttribute("undertow", "statistics-enabled"));
        this.executeOp(managementClient, Operations.createRemoveOperation((ModelNode)micrometerSubsystem));
        this.executeOp(managementClient, Operations.createRemoveOperation((ModelNode)micrometerExtension));
        ServerReload.reloadIfRequired(managementClient);
    }
}

