/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.integration.transactions;

import java.util.Collection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.jboss.as.test.integration.transactions.TestXAResource;
import org.jboss.as.test.integration.transactions.TransactionCheckerSingleton;
import org.jboss.as.test.integration.transactions.XidsPersister;
import org.jboss.logging.Logger;

public class PersistentTestXAResource
extends TestXAResource
implements XAResource {
    private static final Logger log = Logger.getLogger(PersistentTestXAResource.class);
    private XidsPersister xidsPersister = new XidsPersister(PersistentTestXAResource.class.getSimpleName());

    public PersistentTestXAResource() {
    }

    public PersistentTestXAResource(TransactionCheckerSingleton checker) {
        super(checker);
    }

    public PersistentTestXAResource(TestXAResource.TestAction testAction) {
        super(testAction);
    }

    public PersistentTestXAResource(TestXAResource.TestAction testAction, TransactionCheckerSingleton checker) {
        super(testAction, checker);
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        int prepareResult = super.prepare(xid);
        this.xidsPersister.writeToDisk(super.getPreparedXids());
        log.debugf("Prepared xid [%s] was persisted", (Object)xid);
        return prepareResult;
    }

    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        super.commit(xid, onePhase);
        this.xidsPersister.writeToDisk(super.getPreparedXids());
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        super.rollback(xid);
        this.xidsPersister.writeToDisk(super.getPreparedXids());
    }

    @Override
    public void forget(Xid xid) throws XAException {
        super.forget(xid);
        this.xidsPersister.writeToDisk(super.getPreparedXids());
    }

    @Override
    public Xid[] recover(int flag) throws XAException {
        Collection<Xid> recoveredXids = this.xidsPersister.recoverFromDisk();
        log.debugf("Recover call with flag %d returned %s", recoveredXids);
        return recoveredXids.toArray(new Xid[0]);
    }
}

