/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.integration.domain.management.util;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.as.protocol.ProtocolChannelClient;
import org.jboss.as.protocol.mgmt.ManagementChannelAssociation;
import org.jboss.as.protocol.mgmt.ManagementChannelHandler;
import org.jboss.as.protocol.mgmt.ManagementClientChannelStrategy;
import org.jboss.as.protocol.mgmt.ManagementRequestHandlerFactory;
import org.jboss.as.test.integration.domain.management.util.DomainTestClient;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.CloseHandler;
import org.jboss.remoting3.Connection;
import org.xnio.IoFuture;
import org.xnio.OptionMap;

class DomainTestConnection
implements Closeable {
    private static final String DEFAULT_CHANNEL_SERVICE_TYPE = "management";
    private final ProtocolChannelClient client;
    private final CallbackHandler callbackHandler;
    private final ExecutorService executorService;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    volatile Connection connection;

    DomainTestConnection(ProtocolChannelClient client, CallbackHandler callbackHandler, ExecutorService executorService) {
        this.client = client;
        this.callbackHandler = callbackHandler;
        this.executorService = executorService;
    }

    protected DomainTestClient createClient() {
        return this.createClient(this.executorService);
    }

    protected DomainTestClient createClient(ExecutorService executorService) {
        final ChannelStrategy strategy = new ChannelStrategy(executorService);
        final ManagementChannelHandler handler = strategy.handler;
        DomainTestClient client = new DomainTestClient(){

            @Override
            Connection getConnection() {
                return DomainTestConnection.this.connection;
            }

            protected ManagementChannelAssociation getChannelAssociation() throws IOException {
                return handler;
            }

            @Override
            Channel getChannel() {
                return strategy.channel;
            }

            public void close() throws IOException {
                strategy.close();
            }
        };
        handler.addHandlerFactory((ManagementRequestHandlerFactory)client);
        return client;
    }

    protected Connection connect() throws IOException {
        return this.connect(this.callbackHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Connection connect(CallbackHandler callbackHandler) throws IOException {
        if (this.closed.get()) {
            throw new IllegalStateException();
        }
        DomainTestConnection domainTestConnection = this;
        synchronized (domainTestConnection) {
            if (this.isConnected()) {
                return this.connection;
            }
            this.connection = this.client.connectSync(callbackHandler, Collections.emptyMap(), null);
            this.connection.addCloseHandler((CloseHandler)new CloseHandler<Connection>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void handleClose(Connection old, IOException exception) {
                    DomainTestConnection domainTestConnection = DomainTestConnection.this;
                    synchronized (domainTestConnection) {
                        if (DomainTestConnection.this.connection == old) {
                            DomainTestConnection.this.connection = null;
                        }
                        DomainTestConnection.this.notifyAll();
                    }
                }
            });
            return this.connection;
        }
    }

    protected boolean isConnected() {
        return this.connection != null;
    }

    protected void disconnect() throws IOException {
        Connection connection = this.connection;
        if (connection != null) {
            connection.close();
        }
    }

    protected void awaitConnectionClosed(Connection ref) throws InterruptedException {
        DomainTestConnection domainTestConnection = this;
        synchronized (domainTestConnection) {
            while (true) {
                Connection connection;
                if ((connection = this.connection) == null) {
                    return;
                }
                if (connection != ref) {
                    return;
                }
                this.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        DomainTestConnection domainTestConnection = this;
        synchronized (domainTestConnection) {
            Connection connection;
            if (this.closed.compareAndSet(false, true) && (connection = this.connection) != null) {
                connection.close();
            }
        }
    }

    class ChannelStrategy
    extends ManagementClientChannelStrategy {
        volatile Channel channel;
        private final ManagementChannelHandler handler;

        ChannelStrategy(ExecutorService executorService) {
            this.handler = new ManagementChannelHandler((ManagementClientChannelStrategy)this, executorService);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Channel getChannel() throws IOException {
            if (this.channel == null) {
                ChannelStrategy channelStrategy = this;
                synchronized (channelStrategy) {
                    if (this.channel == null) {
                        Connection connection = DomainTestConnection.this.connect();
                        this.channel = this.openChannel(connection);
                        this.channel.receiveMessage(this.handler.getReceiver());
                    }
                }
            }
            return this.channel;
        }

        Channel openChannel(Connection connection) throws IOException {
            IoFuture future = connection.openChannel(DomainTestConnection.DEFAULT_CHANNEL_SERVICE_TYPE, OptionMap.EMPTY);
            Channel channel = (Channel)future.get();
            channel.addCloseHandler((CloseHandler)new CloseHandler<Channel>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void handleClose(Channel old, IOException e) {
                    ChannelStrategy channelStrategy = ChannelStrategy.this;
                    synchronized (channelStrategy) {
                        if (ChannelStrategy.this.channel == old) {
                            ChannelStrategy.this.channel = null;
                        }
                    }
                    ChannelStrategy.this.handler.handleChannelClosed(old, e);
                }
            });
            return channel;
        }

        public void close() throws IOException {
            Channel channel = this.channel;
            if (channel != null) {
                channel.close();
            }
        }
    }
}

