/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.integration.domain.management.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.test.integration.management.util.MgmtOperationException;
import org.jboss.dmr.ModelNode;
import org.junit.Assert;

public class DomainTestUtils {
    private static final int DEFAULT_TIMEOUT = 60;

    private DomainTestUtils() {
    }

    public static ModelNode getHostAddress(String hostName) {
        ModelNode address = new ModelNode();
        address.add("host", hostName);
        return address;
    }

    public static ModelNode getRunningServerAddress(String hostName, String serverName) {
        ModelNode address = DomainTestUtils.getHostAddress(hostName);
        address.add("server", serverName);
        return address;
    }

    public static ModelNode getServerConfigAddress(String hostName, String serverName) {
        ModelNode address = DomainTestUtils.getHostAddress(hostName);
        address.add("server-config", serverName);
        return address;
    }

    public static ModelNode createCompositeOperation(ModelNode ... steps) {
        ModelNode composite = new ModelNode();
        composite.get("operation").set("composite");
        composite.get("address").setEmptyList();
        composite.get("steps").setEmptyList();
        for (ModelNode step : steps) {
            composite.get("steps").add(step);
        }
        return composite;
    }

    public static List<ModelNode> executeStepsForResult(ModelControllerClient client, ModelNode ... steps) throws IOException, MgmtOperationException {
        ModelNode operationResult = DomainTestUtils.executeForResult(DomainTestUtils.createCompositeOperation(steps), client);
        if (!operationResult.hasDefined("result")) {
            return Collections.singletonList(operationResult);
        }
        ArrayList<ModelNode> result = new ArrayList<ModelNode>();
        int size = operationResult.get("result").asPropertyList().size();
        for (int i = 0; i < size; ++i) {
            result.add(operationResult.get("result").require("steps-" + (i + 1)));
        }
        return result;
    }

    public static ModelNode executeForResult(ModelNode op, ModelControllerClient modelControllerClient) throws IOException, MgmtOperationException {
        ModelNode ret = modelControllerClient.execute(op);
        if (!"success".equals(ret.get("outcome").asString())) {
            System.out.println(ret);
            throw new MgmtOperationException("Management operation failed.", op, ret);
        }
        return ret.get("result");
    }

    public static ModelNode executeForFailure(ModelNode op, ModelControllerClient modelControllerClient) throws IOException, MgmtOperationException {
        ModelNode ret = modelControllerClient.execute(op);
        if (!"failed".equals(ret.get("outcome").asString())) {
            System.out.println(ret);
            throw new MgmtOperationException("Management operation succeeded.", op, ret);
        }
        return ret.get("failure-description");
    }

    public static void waitUntilState(ModelControllerClient client, String hostName, String serverName, String state) throws IOException {
        DomainTestUtils.waitUntilState(client, DomainTestUtils.getServerConfigAddress(hostName, serverName), state);
    }

    public static void waitUntilState(ModelControllerClient client, ModelNode serverAddress, String state) throws IOException {
        DomainTestUtils.waitUntilState(client, serverAddress, state, 60L, TimeUnit.SECONDS);
    }

    public static boolean exists(ModelNode address, ModelControllerClient client) throws IOException, MgmtOperationException {
        return DomainTestUtils.exists(PathAddress.pathAddress((ModelNode)address), client);
    }

    public static boolean exists(PathAddress address, ModelControllerClient client) throws IOException, MgmtOperationException {
        ModelNode operation;
        ModelNode e;
        PathElement element = address.getLastElement();
        PathAddress subAddress = address.subAddress(0, address.size() - 1);
        boolean checkType = element.isWildcard();
        if (checkType) {
            e = new ModelNode().set(element.getKey());
            operation = DomainTestUtils.createOperation("read-children-types", subAddress);
        } else {
            e = new ModelNode().set(element.getValue());
            operation = DomainTestUtils.createOperation("read-children-names", subAddress);
            operation.get("child-type").set(element.getKey());
        }
        try {
            ModelNode result = DomainTestUtils.executeForResult(operation, client);
            return result.asList().contains(e);
        }
        catch (MgmtOperationException ex) {
            String failureDescription;
            if (!checkType && (failureDescription = ex.getResult().get("failure-description").asString()).contains("JBAS014793") && failureDescription.contains(element.getKey())) {
                return false;
            }
            throw ex;
        }
    }

    public static String startServer(ModelControllerClient connection, String host, String server) throws IOException, MgmtOperationException {
        return DomainTestUtils.startServer(connection, host, server, true);
    }

    public static String startServer(ModelControllerClient connection, String host, String server, boolean blocking) throws IOException, MgmtOperationException {
        ModelNode address = DomainTestUtils.getServerConfigAddress(host, server);
        ModelNode operation = new ModelNode();
        operation.get("operation").set("start");
        operation.get("address").set(address);
        operation.get("blocking").set(blocking);
        DomainTestUtils.executeForResult(operation, connection);
        return DomainTestUtils.getServerState(connection, address);
    }

    public static void waitUntilState(ModelControllerClient client, ModelNode serverAddress, String required, long timeout, TimeUnit unit) throws IOException {
        long remaining;
        long deadline = System.currentTimeMillis() + unit.toMillis(timeout);
        while ((remaining = deadline - System.currentTimeMillis()) > 0L) {
            if (DomainTestUtils.checkState(client, serverAddress, required)) {
                return;
            }
            try {
                TimeUnit.SECONDS.sleep(1L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
        }
        String state = DomainTestUtils.getServerState(client, serverAddress);
        Assert.assertEquals((String)serverAddress.toString(), (Object)required, (Object)state);
    }

    public static String getServerState(ModelControllerClient client, ModelNode serverAddress) throws IOException {
        ModelNode operation = new ModelNode();
        operation.get("operation").set("read-attribute");
        operation.get("address").set(serverAddress);
        operation.get("name").set("status");
        ModelNode status = client.execute(operation);
        return status.get("result").asString();
    }

    public static boolean checkState(ModelControllerClient client, ModelNode serverAddress, String state) throws IOException {
        String serverState = DomainTestUtils.getServerState(client, serverAddress);
        return state.equals(serverState);
    }

    public static ModelNode createOperation(String op, ModelNode address) {
        ModelNode operation = new ModelNode();
        operation.get("operation").set(op);
        operation.get("address").set(address);
        return operation;
    }

    public static ModelNode createOperation(String op, PathAddress address) {
        return DomainTestUtils.createOperation(op, address.toModelNode());
    }
}

