/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.configadmin;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;

public class ConfigAdminManagement {
    public static void addConfiguration(ModelControllerClient client, String pid, Dictionary<String, String> entries) throws Exception {
        ConfigAdminManagement.updateConfiguration(client, pid, entries, "add");
    }

    public static List<String> listConfigurations(ModelControllerClient client) throws Exception {
        return ConfigAdminManagement.listChildrenNames(client, "configuration");
    }

    public static Map<String, String> readConfiguration(ModelControllerClient client, String pid) throws Exception {
        ModelNode op = ConfigAdminManagement.createOpNode("subsystem=configadmin/configuration=" + pid, "read-resource");
        ModelNode result = ConfigAdminManagement.executeOperation(client, op, true);
        ModelNode entries = result.get("entries");
        HashMap<String, String> map = new HashMap<String, String>();
        for (String key : entries.keys()) {
            map.put(key, entries.get(key).asString());
        }
        return map;
    }

    public static void removeConfiguration(ModelControllerClient client, String pid) throws Exception {
        ConfigAdminManagement.updateConfiguration(client, pid, null, "remove");
    }

    public static void updateConfiguration(ModelControllerClient client, String pid, Dictionary<String, String> entries) throws Exception {
        ConfigAdminManagement.updateConfiguration(client, pid, entries, "update");
    }

    private static void updateConfiguration(ModelControllerClient client, String pid, Dictionary<String, String> entries, String operation) throws Exception {
        ModelNode op = ConfigAdminManagement.createOpNode("subsystem=configadmin/configuration=" + pid, operation);
        if (entries != null) {
            ModelNode en = new ModelNode();
            Enumeration<String> keys = entries.keys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                en.get(key).set(entries.get(key));
            }
            op.get("entries").set(en);
        }
        ConfigAdminManagement.executeOperation(client, op, true);
    }

    private static List<String> listChildrenNames(ModelControllerClient client, String type) throws Exception {
        ModelNode op = ConfigAdminManagement.createOpNode("subsystem=configadmin", "read-children-names");
        op.get("child-type").set(type);
        ModelNode result = ConfigAdminManagement.executeOperation(client, op, true);
        ArrayList<String> names = new ArrayList<String>();
        for (ModelNode n : result.asList()) {
            names.add(n.asString());
        }
        return names;
    }

    private static ModelNode createOpNode(String address, String operation) {
        ModelNode op = new ModelNode();
        ModelNode list = op.get("address").setEmptyList();
        if (address != null) {
            String[] pathSegments;
            for (String segment : pathSegments = address.split("/")) {
                String[] elements = segment.split("=");
                list.add(elements[0], elements[1]);
            }
        }
        op.get("operation").set(operation);
        return op;
    }

    private static ModelNode executeOperation(ModelControllerClient client, ModelNode op, boolean unwrapResult) throws Exception {
        ModelNode ret = client.execute(op);
        if (!unwrapResult) {
            return ret;
        }
        if (!"success".equals(ret.get("outcome").asString())) {
            throw new IllegalStateException("Management operation failed: " + ret.get("failure-description"));
        }
        return ret.get("result");
    }

    static interface ModelConstants {
        public static final String CONFIGURATION = "configuration";
        public static final String ENTRIES = "entries";
        public static final String UPDATE = "update";
        public static final String REMOVE = "remove";
    }
}

