/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.integration.domain.management.util;

import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.as.protocol.ProtocolChannelClient;
import org.jboss.as.test.integration.domain.management.util.DomainTestConnection;
import org.jboss.remoting3.Endpoint;
import org.jboss.remoting3.Remoting;
import org.jboss.remoting3.remote.RemoteConnectionProviderFactory;
import org.jboss.remoting3.spi.ConnectionProviderFactory;
import org.jboss.threads.JBossThreadFactory;
import org.wildfly.security.manager.GetAccessControlContextAction;
import org.xnio.OptionMap;

public class DomainControllerClientConfig
implements Closeable {
    private static final String ENDPOINT_NAME = "mgmt-endpoint";
    private static final AtomicInteger executorCount = new AtomicInteger();
    private final Endpoint endpoint;
    private final ExecutorService executorService;
    private final boolean destroyExecutor;

    static ExecutorService createDefaultExecutor() {
        ThreadGroup group = new ThreadGroup("mgmt-client-thread");
        JBossThreadFactory threadFactory = new JBossThreadFactory(group, Boolean.FALSE, null, "%G " + executorCount.incrementAndGet() + "-%t", null, null, (AccessControlContext)AccessController.doPrivileged(GetAccessControlContextAction.getInstance()));
        return new ThreadPoolExecutor(4, 4, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(256), (ThreadFactory)threadFactory);
    }

    DomainControllerClientConfig(Endpoint endpoint, ExecutorService executorService, boolean destroyExecutor) {
        this.endpoint = endpoint;
        this.executorService = executorService;
        this.destroyExecutor = destroyExecutor;
    }

    DomainTestConnection createConnection(URI connectionURI, CallbackHandler callbackHandler) throws IOException {
        ProtocolChannelClient.Configuration configuration = new ProtocolChannelClient.Configuration();
        configuration.setEndpoint(this.endpoint);
        configuration.setUri(connectionURI);
        ProtocolChannelClient client = ProtocolChannelClient.create((ProtocolChannelClient.Configuration)configuration);
        return new DomainTestConnection(client, callbackHandler, this.executorService);
    }

    @Override
    public void close() throws IOException {
        if (this.destroyExecutor) {
            this.executorService.shutdown();
        }
        if (this.endpoint != null) {
            try {
                this.endpoint.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.destroyExecutor) {
            this.executorService.shutdownNow();
        }
    }

    public static DomainControllerClientConfig create() throws IOException {
        return DomainControllerClientConfig.create(DomainControllerClientConfig.createDefaultExecutor(), true);
    }

    public static DomainControllerClientConfig create(ExecutorService executorService) throws IOException {
        return DomainControllerClientConfig.create(executorService, false);
    }

    static DomainControllerClientConfig create(ExecutorService executorService, boolean destroyExecutor) throws IOException {
        Endpoint endpoint = Remoting.createEndpoint((String)ENDPOINT_NAME, (OptionMap)OptionMap.EMPTY);
        endpoint.addConnectionProvider("remote", (ConnectionProviderFactory)new RemoteConnectionProviderFactory(), OptionMap.EMPTY);
        return new DomainControllerClientConfig(endpoint, executorService, destroyExecutor);
    }
}

