/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.osgi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.Assert;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.VersionRange;
import org.osgi.framework.startlevel.FrameworkStartLevel;
import org.osgi.framework.wiring.FrameworkWiring;
import org.osgi.util.tracker.ServiceTracker;

public final class FrameworkUtils {
    private FrameworkUtils() {
    }

    public static Bundle[] getBundles(BundleContext context, String symbolicName, VersionRange versionRange) {
        ArrayList<Bundle> result = new ArrayList<Bundle>();
        if ("system.bundle".equals(symbolicName) && versionRange == null) {
            result.add(context.getBundle(0L));
        } else {
            for (Bundle aux : context.getBundles()) {
                if (symbolicName != null && !symbolicName.equals(aux.getSymbolicName()) || versionRange != null && !versionRange.includes(aux.getVersion())) continue;
                result.add(aux);
            }
        }
        return !result.isEmpty() ? result.toArray(new Bundle[result.size()]) : null;
    }

    public static int getFrameworkStartLevel(BundleContext context) {
        return ((FrameworkStartLevel)context.getBundle().adapt(FrameworkStartLevel.class)).getStartLevel();
    }

    public static void setFrameworkStartLevel(BundleContext context, int level) throws InterruptedException, TimeoutException {
        FrameworkUtils.setFrameworkStartLevel(context, level, 10L, TimeUnit.SECONDS);
    }

    public static void setFrameworkStartLevel(BundleContext context, final int level, long timeout, TimeUnit units) throws InterruptedException, TimeoutException {
        final FrameworkStartLevel startLevel = (FrameworkStartLevel)context.getBundle().adapt(FrameworkStartLevel.class);
        if (level != startLevel.getStartLevel()) {
            final CountDownLatch latch = new CountDownLatch(1);
            FrameworkListener listener = new FrameworkListener(){

                public void frameworkEvent(FrameworkEvent event) {
                    if (event.getType() == 8 && level == startLevel.getStartLevel()) {
                        latch.countDown();
                    }
                }
            };
            startLevel.setStartLevel(level, new FrameworkListener[]{listener});
            if (!latch.await(timeout, units)) {
                throw new TimeoutException("Timeout changing start level");
            }
        }
    }

    public static void refreshBundles(BundleContext context, Collection<Bundle> bundles) throws InterruptedException, TimeoutException {
        FrameworkUtils.refreshBundles(context, bundles, 10L, TimeUnit.SECONDS);
    }

    public static void refreshBundles(BundleContext context, Collection<Bundle> bundles, long timeout, TimeUnit units) throws InterruptedException, TimeoutException {
        final CountDownLatch latch = new CountDownLatch(1);
        FrameworkListener listener = new FrameworkListener(){

            public void frameworkEvent(FrameworkEvent event) {
                if (event.getType() == 4) {
                    latch.countDown();
                }
            }
        };
        FrameworkWiring fwrkWiring = (FrameworkWiring)context.getBundle().adapt(FrameworkWiring.class);
        fwrkWiring.refreshBundles(bundles, new FrameworkListener[]{listener});
        latch.await(10L, TimeUnit.SECONDS);
    }

    public static <T> T waitForService(BundleContext context, Class<T> clazz) {
        return FrameworkUtils.waitForService(context, clazz, 10L, TimeUnit.SECONDS);
    }

    public static <T> T waitForService(BundleContext context, Class<T> clazz, long timeout, TimeUnit unit) {
        ServiceReference<T> sref = FrameworkUtils.waitForServiceReference(context, clazz, timeout, unit);
        Object service = sref != null ? context.getService(sref) : null;
        Assert.assertNotNull((String)("Service registered: " + clazz.getName()), (Object)service);
        return (T)service;
    }

    public static <T> ServiceReference<T> waitForServiceReference(BundleContext context, Class<T> clazz) {
        return FrameworkUtils.waitForServiceReference(context, clazz, 10L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> ServiceReference<T> waitForServiceReference(BundleContext context, Class<T> clazz, long timeout, TimeUnit unit) {
        ServiceTracker tracker = new ServiceTracker(context, clazz.getName(), null);
        tracker.open();
        ServiceReference sref = null;
        try {
            if (tracker.waitForService(unit.toMillis(timeout)) != null) {
                sref = context.getServiceReference(clazz);
            }
        }
        catch (InterruptedException e) {
        }
        finally {
            tracker.close();
        }
        Assert.assertNotNull((String)("Service registered: " + clazz.getName()), (Object)sref);
        return sref;
    }
}

