/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.integration.management.rbac;

import java.io.IOException;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.test.integration.management.interfaces.ManagementInterface;
import org.jboss.as.test.integration.management.rbac.Outcome;
import org.jboss.as.test.integration.management.util.ModelUtil;
import org.jboss.dmr.ModelNode;
import org.junit.Assert;

public class RbacUtil {
    public static final String MONITOR_USER = "Monitor";
    public static final String OPERATOR_USER = "Operator";
    public static final String MAINTAINER_USER = "Maintainer";
    public static final String DEPLOYER_USER = "Deployer";
    public static final String ADMINISTRATOR_USER = "Administrator";
    public static final String AUDITOR_USER = "Auditor";
    public static final String SUPERUSER_USER = "SuperUser";
    public static final String MONITOR_ROLE = "Monitor";
    public static final String OPERATOR_ROLE = "Operator";
    public static final String MAINTAINER_ROLE = "Maintainer";
    public static final String DEPLOYER_ROLE = "Deployer";
    public static final String ADMINISTRATOR_ROLE = "Administrator";
    public static final String AUDITOR_ROLE = "Auditor";
    public static final String SUPERUSER_ROLE = "SuperUser";
    public static final String ROLE_MAPPING_ADDRESS_BASE = "core-service=management/access=authorization/role-mapping=";
    private static final String ROLE_MAPPING_USER_INCLUDE_ADDRESS_BASE = "/include=user-";

    private RbacUtil() {
    }

    public static ModelNode executeOperation(ModelControllerClient client, ModelNode operation, Outcome expectedOutcome) throws IOException {
        ModelNode result = client.execute(operation);
        return RbacUtil.checkOperationResult(operation, result, expectedOutcome);
    }

    public static ModelNode executeOperation(ManagementInterface client, ModelNode operation, Outcome expectedOutcome) throws IOException {
        ModelNode result = client.execute(operation);
        return RbacUtil.checkOperationResult(operation, result, expectedOutcome);
    }

    public static ModelNode checkOperationResult(ModelNode operation, ModelNode result, Outcome expectedOutcome) {
        String outcome = result.get("outcome").asString();
        switch (expectedOutcome) {
            case SUCCESS: {
                if ("success".equals(outcome)) break;
                System.out.println("Failed: " + operation);
                System.out.print("Result: " + result);
                Assert.fail((String)result.get("failure-description").asString());
                break;
            }
            case UNAUTHORIZED: {
                if (!"failed".equals(outcome)) {
                    Assert.fail((String)("Didn't fail: " + result.asString()));
                }
                if (result.get("failure-description").asString().contains("13456") || result.asString().contains("11360") || result.asString().contains("11361") || result.asString().contains("11362") || result.asString().contains("11363")) break;
                Assert.fail((String)("Incorrect failure type: " + result.asString()));
                break;
            }
            case HIDDEN: {
                String failureDesc;
                if (!"failed".equals(outcome)) {
                    Assert.fail((String)("Didn't fail: " + result.asString()));
                }
                if ((failureDesc = result.get("failure-description").asString()).contains("14807") || failureDesc.contains("14883") || failureDesc.contains("11340")) break;
                Assert.fail((String)("Incorrect failure type: " + result.asString()));
                break;
            }
            case FAILED: {
                String failureDesc;
                if (!"failed".equals(outcome)) {
                    Assert.fail((String)("Didn't fail: " + result.asString()));
                }
                if (!(failureDesc = result.get("failure-description").asString()).contains("14807") && !failureDesc.contains("14883") && !failureDesc.contains("13456") && !failureDesc.contains("11340")) break;
                Assert.fail((String)("Incorrect failure type: " + result.asString()));
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return result;
    }

    public static void addRoleMapping(String role, ModelControllerClient client) throws IOException {
        String address = ROLE_MAPPING_ADDRESS_BASE + role;
        ModelNode readOp = ModelUtil.createOpNode(address, "read-resource");
        if ("failed".equals(client.execute(readOp).get("outcome").asString())) {
            ModelNode addOp = ModelUtil.createOpNode(address, "add");
            RbacUtil.executeOperation(client, addOp, Outcome.SUCCESS);
        }
    }

    public static void addRoleUser(String role, String user, ModelControllerClient client) throws IOException {
        ModelNode op = ModelUtil.createOpNode(ROLE_MAPPING_ADDRESS_BASE + role + ROLE_MAPPING_USER_INCLUDE_ADDRESS_BASE + user, "add");
        op.get("type").set("user");
        op.get("name").set(user);
        RbacUtil.executeOperation(client, op, Outcome.SUCCESS);
    }

    public static void removeRoleUser(String role, String user, ModelControllerClient client) throws IOException {
        ModelNode op = ModelUtil.createOpNode(ROLE_MAPPING_ADDRESS_BASE + role + ROLE_MAPPING_USER_INCLUDE_ADDRESS_BASE + user, "remove");
        RbacUtil.executeOperation(client, op, Outcome.SUCCESS);
    }

    public static void removeRoleMapping(String role, ModelControllerClient client) throws IOException {
        ModelNode op = ModelUtil.createOpNode(ROLE_MAPPING_ADDRESS_BASE + role, "remove");
        RbacUtil.executeOperation(client, op, Outcome.SUCCESS);
    }

    public static void addRoleHeader(ModelNode operation, String ... roles) {
        ModelNode header = operation.get(new String[]{"operation-headers", "roles"});
        for (String role : roles) {
            header.add(role);
        }
    }

    public static String[] allStandardRoles() {
        return new String[]{"Monitor", "Operator", "Maintainer", "Deployer", "Administrator", "Auditor", "SuperUser"};
    }
}

